/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String ENGINE_CLASS = "MessageDigest";
    private final String algorithm;
    private MessageDigestSpi engine;
    private Provider provider;
    private static String NONSPI_MSG = "This MessageDigest is not a MessageDigestSpi. MessageDigestSpi methods should not be used on MessageDigest objects.";

    protected MessageDigest(String string) {
        this.Block$();
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(Security.getCryptInstance(ENGINE_CLASS, string));
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance(Security.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static MessageDigest getInstance(Security.Engine engine) {
        MessageDigest messageDigest;
        Object object = engine.getEngine();
        if (object instanceof MessageDigest) {
            messageDigest = (MessageDigest)object;
        } else {
            messageDigest = new NonSpiMessageDigest(engine.algorithm);
            messageDigest.engine = (MessageDigestSpi)object;
        }
        messageDigest.provider = engine.getProvider();
        return messageDigest;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.engine.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.engine.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public byte[] digest() {
        byte[] byArray = this.engine.engineDigest();
        this.engine.engineReset();
        return byArray;
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        int n3 = this.engine.engineGetDigestLength();
        if (n2 < n3) {
            throw new DigestException(new StringBuffer().append("buf.length < ").append(n3).toString());
        }
        System.arraycopy(this.digest(), 0, byArray, n, n3);
        return n3;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        return super.toString();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        return Arrays.equals(byArray, byArray2);
    }

    public void reset() {
        this.engine.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engine.engineGetDigestLength();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private /* synthetic */ void Block$() {
        this.engine = this;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonSpiMessageDigest
    extends MessageDigest {
        protected NonSpiMessageDigest(String string) {
            super(string);
        }

        @Override
        protected int engineGetDigestLength() {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineUpdate(byte by) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected byte[] engineDigest() {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected int engineDigest(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineReset() {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }
    }
}

