/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Random;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureRandom
extends Random {
    static final String ENGINE_CLASS = "SecureRandom";
    private final Provider provider;
    private final SecureRandomSpi engine;

    public SecureRandom() {
        try {
            Security.Engine engine = Security.getCryptInstance(ENGINE_CLASS);
            this.provider = engine.getProvider();
            this.engine = (SecureRandomSpi)engine.getEngine();
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("no SecureRandom found");
        }
    }

    public SecureRandom(byte[] byArray) {
        this();
        this.setSeed(byArray);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.engine = secureRandomSpi;
        this.provider = provider;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        Security.Engine engine = Security.getCryptInstance(ENGINE_CLASS, string);
        return new SecureRandom((SecureRandomSpi)engine.getEngine(), engine.getProvider());
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Security.Engine engine = Security.getCryptInstance(ENGINE_CLASS, string, string2);
        return new SecureRandom((SecureRandomSpi)engine.getEngine(), engine.getProvider());
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void setSeed(byte[] byArray) {
        if (this.engine != null) {
            this.engine.engineSetSeed(byArray);
        }
    }

    @Override
    public void setSeed(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(l >> n * 8);
            ++n;
        }
        this.setSeed(byArray);
    }

    @Override
    public void nextBytes(byte[] byArray) {
        this.engine.engineNextBytes(byArray);
    }

    @Override
    protected final int next(int n) {
        byte[] byArray = new byte[(n + 7) / 8];
        int n2 = 0;
        this.nextBytes(byArray);
        int n3 = byArray.length - 1;
        while (n3 >= 0) {
            n2 |= byArray[byArray.length - n3 - 1] << 8 * n3 & 0xFF;
            --n3;
        }
        return n2 >> byArray.length * 8 - n;
    }

    public static byte[] getSeed(int n) {
        new SecureRandom();
        return SecureRandom.getSeed(n);
    }

    public byte[] generateSeed(int n) {
        return this.engine.engineGenerateSeed(n);
    }
}

