/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import kaffe.security.Engine;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateFactory {
    private static final String ENGINE_CLASS = "CertificateFactory";
    private CertificateFactorySpi certFacSpi;
    private Provider provider;
    private String type;

    protected CertificateFactory(CertificateFactorySpi certificateFactorySpi, Provider provider, String string) {
        this.certFacSpi = certificateFactorySpi;
        this.provider = provider;
        this.type = string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(inputStream);
    }

    public final Collection generateCertificates(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(inputStream);
    }

    public final CRL generateCRL(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(inputStream);
    }

    public final Collection generateCRLs(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(inputStream);
    }

    public static final CertificateFactory getInstance(String string) throws CertificateException {
        try {
            return CertificateFactory.getInstance(Engine.getCryptInstance(ENGINE_CLASS, string));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException("No such type");
        }
    }

    public static final CertificateFactory getInstance(String string, String string2) throws CertificateException, NoSuchProviderException {
        try {
            return CertificateFactory.getInstance(Engine.getCryptInstance(ENGINE_CLASS, string, string2));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException("No such type");
        }
    }

    private static CertificateFactory getInstance(Engine engine) {
        return new CertificateFactory((CertificateFactorySpi)engine.getEngine(), engine.getProvider(), engine.getAlgorithm());
    }
}

