/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class X509CRL
extends CRL
implements X509Extension {
    protected X509CRL() {
        super("X.509");
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract int getVersion();

    public abstract Principal getIssuerDN();

    public abstract Date getThisUpdate();

    public abstract Date getNextUpdate();

    public abstract X509CRLEntry getRevokedCertificate(BigInteger var1);

    public abstract Set getRevokedCertificates();

    public abstract byte[] getTBSCertList() throws CRLException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof X509CRL) {
            X509CRL x509CRL = (X509CRL)object;
            try {
                byte[] byArray = x509CRL.getEncoded();
                byte[] byArray2 = this.getEncoded();
                if (byArray != null && byArray2 != null && byArray.length == byArray2.length) {
                    bl = true;
                    int n = 0;
                    while (n < byArray.length && bl) {
                        if (byArray[n] != byArray2[n]) {
                            bl = false;
                        }
                        ++n;
                    }
                }
            }
            catch (CRLException cRLException) {
                // empty catch block
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            if (byArray != null) {
                switch (byArray.length) {
                    case 1: {
                        n = byArray[0];
                        break;
                    }
                    case 2: {
                        n = byArray[0] << 8 | byArray[1];
                        break;
                    }
                    case 3: {
                        n = byArray[0] << 16 | byArray[1] << 8 | byArray[2];
                        break;
                    }
                    default: {
                        n = byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3];
                        break;
                    }
                }
            }
        }
        catch (CRLException cRLException) {
            // empty catch block
        }
        return n;
    }
}

