/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timestamp
extends java.util.Date {
    static final long serialVersionUID = 2745179027874758501L;
    private static SimpleDateFormat parse_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
    private static SimpleDateFormat format_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int nanos;

    public static Timestamp valueOf(String string) {
        try {
            Date date = (Date)parse_sdf.parseObject(string);
            if (date == null) {
                throw new IllegalArgumentException(string);
            }
            return new Timestamp(date.getTime());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(string);
        }
    }

    public Timestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6);
        this.nanos = n7;
    }

    public Timestamp(long l) {
        super(l);
    }

    @Override
    public String toString() {
        return new StringBuffer().append(format_sdf.format(this)).append(".").append(this.getNanos()).toString();
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int n) {
        this.nanos = n;
    }

    public boolean before(Timestamp timestamp) {
        if (timestamp.getTime() > this.getTime()) {
            return true;
        }
        return timestamp.getNanos() > this.getNanos();
    }

    public boolean after(Timestamp timestamp) {
        if (timestamp.getTime() < this.getTime()) {
            return true;
        }
        return timestamp.getNanos() < this.getNanos();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Timestamp)) {
            return false;
        }
        return this.equals((Timestamp)object);
    }

    public boolean equals(Timestamp timestamp) {
        if (timestamp == null) {
            return false;
        }
        if (timestamp.getTime() != this.getTime()) {
            return false;
        }
        return timestamp.getNanos() == this.getNanos();
    }

    public int compareTo(Timestamp timestamp) {
        int n = super.compareTo(timestamp);
        if (n != 0) {
            return n;
        }
        return this.nanos - timestamp.nanos;
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((Timestamp)object);
    }
}

