/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributedStringIterator
implements AttributedCharacterIterator {
    private CharacterIterator ci;
    private AttributedString.AttributeRange[] attribs;
    private AttributedCharacterIterator.Attribute[] restricts;

    AttributedStringIterator(StringCharacterIterator stringCharacterIterator, AttributedString.AttributeRange[] attributeRangeArray, int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        this.ci = new StringCharacterIterator(stringCharacterIterator, n, n2);
        this.attribs = attributeRangeArray;
        this.restricts = attributeArray;
    }

    @Override
    public Object clone() {
        return this.ci.clone();
    }

    @Override
    public char current() {
        return this.ci.current();
    }

    @Override
    public char next() {
        return this.ci.next();
    }

    @Override
    public char previous() {
        return this.ci.previous();
    }

    @Override
    public char first() {
        return this.ci.first();
    }

    @Override
    public char last() {
        return this.ci.last();
    }

    @Override
    public int getIndex() {
        return this.ci.getIndex();
    }

    @Override
    public char setIndex(int n) {
        return this.ci.setIndex(n);
    }

    @Override
    public int getBeginIndex() {
        return this.ci.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.ci.getEndIndex();
    }

    @Override
    public Set getAllAttributeKeys() {
        HashSet hashSet = new HashSet();
        if (this.attribs == null) {
            return hashSet;
        }
        int n = 0;
        while (n < this.attribs.length) {
            Set set = this.attribs[n].attribs.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
            ++n;
        }
        return hashSet;
    }

    @Override
    public int getRunLimit() {
        return this.getRunLimit(this.getAttributes().keySet());
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        HashSet hashSet = new HashSet();
        hashSet.add(attribute);
        return this.getRunLimit(hashSet);
    }

    @Override
    public synchronized int getRunLimit(Set set) {
        int n;
        boolean bl;
        int n2 = this.ci.getIndex();
        block0: do {
            n = this.ci.getIndex();
            Map map = this.getAttributes();
            bl = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (map.containsKey(iterator.next())) continue;
                bl = true;
                continue block0;
            }
        } while (!bl && this.ci.next() != '\uffff');
        boolean bl2 = this.ci.previous() == '\uffff';
        this.ci.setIndex(n2);
        if (n == n2) {
            return -1;
        }
        return n;
    }

    @Override
    public int getRunStart() {
        return this.getRunStart(this.getAttributes().keySet());
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        HashSet hashSet = new HashSet();
        hashSet.add(attribute);
        return this.getRunStart(hashSet);
    }

    @Override
    public int getRunStart(Set set) {
        int n;
        Iterator iterator;
        int n2 = this.ci.getIndex();
        block0: do {
            n = this.ci.getIndex();
            Map map = this.getAttributes();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!map.containsKey(iterator.next())) continue block0;
            }
        } while (!iterator.hasNext() && this.ci.previous() != '\uffff');
        boolean bl = this.ci.previous() == '\uffff';
        this.ci.setIndex(n2);
        if (n == n2) {
            return -1;
        }
        if (!bl) {
            ++n;
        }
        return n;
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        if (this.attribs == null) {
            return null;
        }
        int n = 0;
        while (n < this.attribs.length) {
            Set set = this.attribs[n].attribs.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!object.equals(attribute) || this.ci.getIndex() < this.attribs[n].begin_index || this.ci.getIndex() > this.attribs[n].end_index) continue;
                return this.attribs[n].attribs.get(object);
            }
            ++n;
        }
        return null;
    }

    @Override
    public Map getAttributes() {
        HashMap hashMap = new HashMap();
        if (this.attribs == null) {
            return hashMap;
        }
        int n = 0;
        while (n < this.attribs.length) {
            if (this.ci.getIndex() >= this.attribs[n].begin_index && this.ci.getIndex() <= this.attribs[n].end_index) {
                hashMap.putAll(this.attribs[n].attribs);
            }
            ++n;
        }
        return hashMap;
    }
}

