/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormat
extends Format {
    private Locale locale;
    private Format[] formats;
    private int[] argumentNumber;
    private transient String[] strs;
    private int maxOffset;
    private int[] offsets;
    private String pattern;

    public MessageFormat(String string) {
        this.Block$();
        this.applyPattern(string);
    }

    public void applyPattern(String string) {
        MessagePatternDescription messagePatternDescription = this.tryToApplyPattern(string);
        this.formats = messagePatternDescription.formats;
        this.strs = messagePatternDescription.strs;
        this.argumentNumber = messagePatternDescription.argumentNumber;
        this.pattern = string;
    }

    private MessagePatternDescription tryToApplyPattern(String string) {
        int n = string.length();
        int n2 = 0;
        MessagePatternDescription messagePatternDescription = new MessagePatternDescription();
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '{') {
                ++n2;
                while (string.charAt(n3) != '}' && n3 < n) {
                    ++n3;
                }
            }
            ++n3;
        }
        messagePatternDescription.formats = new Format[n2];
        messagePatternDescription.strs = new String[n2 + 1];
        messagePatternDescription.argumentNumber = new int[n2];
        n2 = 0;
        n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (string.charAt(n4) == '{') {
                messagePatternDescription.strs[n2] = string.substring(n3, n4);
                n3 = ++n4;
                while (string.charAt(n4) != '}' && n4 < n) {
                    ++n4;
                }
                this.parseFormat(string.substring(n3, n4), messagePatternDescription, n2);
                ++n2;
                n3 = n4 + 1;
            }
            ++n4;
        }
        messagePatternDescription.strs[n2] = string.substring(n3, n);
        return messagePatternDescription;
    }

    private void parseFormat(String string, MessagePatternDescription messagePatternDescription, int n) {
        int n2;
        int n3 = string.indexOf(44);
        int n4 = n3 + 1;
        if (n3 == -1) {
            n4 = n3 = string.length();
        }
        int n5 = string.indexOf(44, n3 + 1);
        int n6 = n5 + 1;
        if (n5 == -1) {
            n6 = n5 = string.length();
        }
        try {
            n2 = Integer.parseInt(string.substring(0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        String string2 = string.substring(n4, n5);
        String string3 = string.substring(n6, string.length());
        messagePatternDescription.argumentNumber[n] = n2;
        if (string2.equals("time")) {
            if (string3.equals("")) {
                messagePatternDescription.formats[n] = DateFormat.getTimeInstance(2, this.locale);
                return;
            }
            if (string3.equals("short")) {
                messagePatternDescription.formats[n] = DateFormat.getTimeInstance(3, this.locale);
                return;
            }
            if (string3.equals("medium")) {
                messagePatternDescription.formats[n] = DateFormat.getTimeInstance(2, this.locale);
                return;
            }
            if (string3.equals("long")) {
                messagePatternDescription.formats[n] = DateFormat.getTimeInstance(1, this.locale);
                return;
            }
            if (string3.equals("full")) {
                messagePatternDescription.formats[n] = DateFormat.getTimeInstance(0, this.locale);
                return;
            }
            messagePatternDescription.formats[n] = new SimpleDateFormat(string3, this.locale);
            return;
        }
        if (string2.equals("date")) {
            if (string3.equals("")) {
                messagePatternDescription.formats[n] = DateFormat.getDateInstance(2, this.locale);
                return;
            }
            if (string3.equals("short")) {
                messagePatternDescription.formats[n] = DateFormat.getDateInstance(3, this.locale);
                return;
            }
            if (string3.equals("medium")) {
                messagePatternDescription.formats[n] = DateFormat.getDateInstance(2, this.locale);
                return;
            }
            if (string3.equals("long")) {
                messagePatternDescription.formats[n] = DateFormat.getDateInstance(1, this.locale);
                return;
            }
            if (string3.equals("full")) {
                messagePatternDescription.formats[n] = DateFormat.getDateInstance(0, this.locale);
                return;
            }
            messagePatternDescription.formats[n] = new SimpleDateFormat(string3, this.locale);
            return;
        }
        if (string2.equals("number")) {
            if (string3.equals("")) {
                messagePatternDescription.formats[n] = NumberFormat.getInstance(this.locale);
                return;
            }
            if (string3.equals("currency")) {
                messagePatternDescription.formats[n] = NumberFormat.getCurrencyInstance(this.locale);
                return;
            }
            if (string3.equals("percent")) {
                messagePatternDescription.formats[n] = NumberFormat.getPercentInstance(this.locale);
                return;
            }
            if (string3.equals("integer")) {
                messagePatternDescription.formats[n] = NumberFormat.getNumberInstance(this.locale);
                return;
            }
            messagePatternDescription.formats[n] = new DecimalFormat(string3, this.locale);
            return;
        }
        if (string2.equals("choice")) {
            messagePatternDescription.formats[n] = new ChoiceFormat(string3);
            return;
        }
        messagePatternDescription.formats[n] = null;
    }

    @Override
    public Object clone() {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.locale = this.locale;
        messageFormat.strs = this.strs;
        messageFormat.formats = this.formats;
        messageFormat.argumentNumber = this.argumentNumber;
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (object instanceof MessageFormat) {
            MessageFormat messageFormat = (MessageFormat)object;
            if (this.locale != messageFormat.locale) {
                return false;
            }
            int n = this.formats.length;
            while (n-- > 0) {
                if (!this.formats[n].equals(messageFormat.formats[n])) {
                    return false;
                }
                if (this.strs[n].equals(messageFormat.strs[n])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String format(String string, Object[] objectArray) {
        return new MessageFormat(string).format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2;
        FieldPosition fieldPosition2 = new FieldPosition(0);
        MessagePatternDescription messagePatternDescription = new MessagePatternDescription();
        boolean bl = true;
        messagePatternDescription.formats = this.formats;
        messagePatternDescription.strs = this.strs;
        messagePatternDescription.argumentNumber = this.argumentNumber;
        do {
            stringBuffer2 = new StringBuffer();
            int n = 0;
            while (n < messagePatternDescription.formats.length) {
                stringBuffer2.append(messagePatternDescription.strs[n]);
                if (messagePatternDescription.formats[n] == null) {
                    stringBuffer2.append(objectArray[messagePatternDescription.argumentNumber[n]].toString());
                } else {
                    messagePatternDescription.formats[n].format(objectArray[messagePatternDescription.argumentNumber[n]], stringBuffer2, fieldPosition2);
                }
                ++n;
            }
            stringBuffer2.append(messagePatternDescription.strs[messagePatternDescription.strs.length - 1]);
            messagePatternDescription = this.tryToApplyPattern(stringBuffer2.toString());
            if (messagePatternDescription.argumentNumber.length != 0) continue;
            bl = false;
        } while (bl);
        stringBuffer.append(stringBuffer2.toString());
        return stringBuffer;
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Object[]) {
            return this.format((Object[])object, stringBuffer, fieldPosition);
        }
        return this.format(new Object[]{object}, stringBuffer, fieldPosition);
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        Object[] objectArray = new Object[this.argumentNumber.length];
        ParsePosition parsePosition2 = new ParsePosition(0);
        int n = parsePosition.getIndex();
        string = string.substring(parsePosition.getIndex());
        n = 0;
        int n2 = 0;
        while (n2 < this.strs.length) {
            int n3 = this.strs[n2].length();
            if (!this.strs[n2].equals(string.substring(0, n3))) {
                parsePosition.setErrorIndex(n);
                return null;
            }
            string = string.substring(n3);
            n += n3;
            if (n2 == this.strs.length - 1) break;
            if (this.formats[n2] != null) {
                parsePosition2.setIndex(0);
                objectArray[n2] = this.formats[n2].parseObject(string, parsePosition2);
                if (objectArray[n2] == null) {
                    parsePosition.setErrorIndex(parsePosition2.getErrorIndex() + n);
                    return null;
                }
                string = string.substring(parsePosition2.getIndex());
                n += parsePosition2.getIndex();
            } else {
                int n4;
                if (n2 == this.strs.length - 2 && this.strs[this.strs.length - 1].equals("")) {
                    n4 = string.length();
                } else {
                    n4 = string.indexOf(this.strs[n2 + 1]);
                    if (n4 == -1) {
                        parsePosition.setErrorIndex(n);
                        return null;
                    }
                }
                objectArray[n2] = string.substring(0, n4);
                string = string.substring(n4);
                n += n4;
            }
            ++n2;
        }
        parsePosition.setIndex(n);
        return objectArray;
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (objectArray == null) {
            throw new ParseException("Message parsing error", parsePosition.getErrorIndex());
        }
        return objectArray;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setFormat(int n, Format format) {
        this.formats[n] = format;
    }

    public void setFormats(Format[] formatArray) {
        this.formats = formatArray;
    }

    public void setLocale(Locale locale2) {
        this.locale = locale2;
    }

    public String toPattern() {
        return this.pattern;
    }

    private /* synthetic */ void Block$() {
        this.locale = Locale.getDefault();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessagePatternDescription {
        String[] strs;
        Format[] formats;
        int[] argumentNumber;

        private MessagePatternDescription() {
        }
    }
}

