/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.RandomAccessSubList;
import java.util.SubList;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList
extends AbstractCollection
implements List {
    protected int modCount;

    protected AbstractList() {
    }

    @Override
    public abstract Object get(int var1);

    @Override
    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        int n2;
        Iterator iterator = collection.iterator();
        int n3 = n2 = collection.size();
        while (n3 > 0) {
            this.add(n++, iterator.next());
            --n3;
        }
        return n2 > 0;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        int n = this.size();
        if (n != ((List)object).size()) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ((List)object).iterator();
        while (--n >= 0) {
            if (AbstractCollection.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        int n2 = this.size();
        while (--n2 >= 0) {
            n = 31 * n + AbstractCollection.hashCode(iterator.next());
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (AbstractCollection.equals(object, listIterator.next())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return new 2();
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.size();
        ListIterator listIterator = this.listIterator(n);
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, listIterator.previous())) continue;
            return n;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException(new StringBuffer().append("Index: ").append(n).append(", Size:").append(this.size()).toString());
        }
        return new 1(this, n);
    }

    @Override
    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int n, int n2) {
        ListIterator listIterator = this.listIterator(n);
        int n3 = n;
        while (n3 < n2) {
            listIterator.next();
            listIterator.remove();
            ++n3;
        }
    }

    @Override
    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List subList(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException(new StringBuffer().append(n).append(" > ").append(n2).toString());
        }
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, n, n2);
        }
        return new SubList(this, n, n2);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements ListIterator {
        private int knownMod;
        private int position;
        private int lastReturned;
        private int size;
        private final /* synthetic */ AbstractList this$0;
        private final /* synthetic */ int var$index;

        private void checkMod() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkMod();
            return this.position < this.size;
        }

        @Override
        public boolean hasPrevious() {
            this.checkMod();
            return this.position > 0;
        }

        @Override
        public Object next() {
            this.checkMod();
            if (this.position == this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.position;
            return this.this$0.get(this.position++);
        }

        @Override
        public Object previous() {
            this.checkMod();
            if (this.position == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.position += -1;
            return this.this$0.get(this.lastReturned);
        }

        @Override
        public int nextIndex() {
            this.checkMod();
            return this.position;
        }

        @Override
        public int previousIndex() {
            this.checkMod();
            return this.position - 1;
        }

        @Override
        public void remove() {
            this.checkMod();
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.lastReturned);
            this.size += -1;
            this.position = this.lastReturned;
            this.lastReturned = -1;
            this.knownMod = this.this$0.modCount;
        }

        @Override
        public void set(Object object) {
            this.checkMod();
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            this.this$0.set(this.lastReturned, object);
        }

        @Override
        public void add(Object object) {
            this.checkMod();
            this.this$0.add(this.position++, object);
            ++this.size;
            this.lastReturned = -1;
            this.knownMod = this.this$0.modCount;
        }

        public 1() {
            this.this$0 = var1_1;
            this.var$index = n;
            this.Block$();
        }

        private /* synthetic */ void Block$() {
            this.knownMod = this.this$0.modCount;
            this.position = this.var$index;
            this.lastReturned = -1;
            this.size = this.this$0.size();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 2
    implements Iterator {
        private int pos;
        private int size;
        private int last;
        private int knownMod;

        private void checkMod() {
            if (this.knownMod != AbstractList.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkMod();
            return this.pos < this.size;
        }

        @Override
        public Object next() {
            this.checkMod();
            if (this.pos == this.size) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            return AbstractList.this.get(this.pos++);
        }

        @Override
        public void remove() {
            this.checkMod();
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            AbstractList.this.remove(this.last);
            this.pos += -1;
            this.size += -1;
            this.last = -1;
            this.knownMod = AbstractList.this.modCount;
        }

        public 2() {
            this.Block$();
        }

        private /* synthetic */ void Block$() {
            this.pos = 0;
            this.size = AbstractList.this.size();
            this.last = -1;
            this.knownMod = AbstractList.this.modCount;
        }
    }
}

