/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList
extends AbstractList
implements Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 32;
    private boolean fixed;
    private Object[] a;
    private int off;
    private int len;

    public ArrayList() {
        this(32);
    }

    public ArrayList(Collection collection) {
        Iterator iterator = collection.iterator();
        this.a = new Object[collection.size() * 11 / 10];
        int n = 0;
        while (iterator.hasNext()) {
            this.a[n] = iterator.next();
            ++n;
        }
        this.len = n;
    }

    public ArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity < 0");
        }
        this.a = new Object[n];
    }

    ArrayList(Object[] objectArray) {
        this.a = objectArray;
        this.len = objectArray.length;
        this.fixed = true;
    }

    public void trimToSize() {
        if (this.off != 0 || this.len != this.a.length) {
            Object[] objectArray = new Object[this.len];
            System.arraycopy(this.a, this.off, objectArray, 0, this.len);
            ++this.modCount;
            this.off = 0;
            this.a = objectArray;
        }
    }

    public void ensureCapacity(int n) {
        if (this.fixed || this.a.length - this.off >= n) {
            return;
        }
        int n2 = 16;
        while (n2 != Integer.MIN_VALUE) {
            if (n2 - 12 >= n) break;
            n2 <<= 1;
        }
        if (n2 == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("too big");
        }
        int n3 = n2 - 12;
        Object[] objectArray = new Object[n3];
        System.arraycopy(this.a, this.off, objectArray, 0, this.len);
        ++this.modCount;
        this.a = objectArray;
        this.off = 0;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int indexOf(Object object) {
        int n = this.off;
        while (n < this.off + this.len) {
            if (!(object != null ? !object.equals(this.a[n]) : this.a[n] != null)) {
                return n - this.off;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.off + this.len - 1;
        while (n >= this.off) {
            if (!(object != null ? !object.equals(this.a[n]) : this.a[n] != null)) {
                return n - this.off;
            }
            --n;
        }
        return -1;
    }

    public Object clone() {
        ArrayList arrayList;
        try {
            arrayList = (ArrayList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        arrayList.a = new Object[this.len];
        System.arraycopy(this.a, this.off, arrayList.a, 0, this.len);
        arrayList.off = 0;
        arrayList.fixed = false;
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.a, this.off, objectArray, 0, this.len);
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.len) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.len);
        }
        System.arraycopy(this.a, this.off, objectArray, 0, this.len);
        if (objectArray.length > this.len) {
            objectArray[this.len] = null;
        }
        return objectArray;
    }

    @Override
    public Object get(int n) {
        if (n < 0 || n >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.a[this.off + n];
    }

    @Override
    public Object set(int n, Object object) {
        if (n < 0 || n >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        Object object2 = this.a[this.off + n];
        this.a[this.off + n] = object;
        return object2;
    }

    @Override
    public boolean add(Object object) {
        if (this.fixed) {
            throw new UnsupportedOperationException();
        }
        this.addInternal(this.len, object);
        return true;
    }

    @Override
    public void add(int n, Object object) {
        if (this.fixed) {
            throw new UnsupportedOperationException();
        }
        if (n < 0 || n > this.len) {
            throw new IndexOutOfBoundsException();
        }
        this.addInternal(n, object);
    }

    private void addInternal(int n, Object object) {
        int n2 = this.modCount;
        if (this.off > 0 && n < this.len / 2) {
            System.arraycopy(this.a, this.off, this.a, this.off - 1, n);
            this.off += -1;
        } else {
            this.ensureCapacity(this.len + 1);
            System.arraycopy(this.a, this.off + n, this.a, this.off + n + 1, this.len - n);
        }
        this.modCount = n2 + 1;
        this.a[this.off + n] = object;
        ++this.len;
    }

    @Override
    public Object remove(int n) {
        if (this.fixed) {
            throw new UnsupportedOperationException();
        }
        Object object = this.a[this.off + n];
        this.removeRange(n, n + 1);
        return object;
    }

    @Override
    public void clear() {
        if (this.fixed) {
            throw new UnsupportedOperationException();
        }
        ++this.modCount;
        this.len = 0;
        this.off = 0;
    }

    @Override
    public boolean addAll(Collection collection) {
        if (this.fixed) {
            throw new UnsupportedOperationException();
        }
        this.addAll(this.len, collection);
        return true;
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        if (this.fixed) {
            throw new UnsupportedOperationException();
        }
        if (n < 0 || n > this.len) {
            throw new IndexOutOfBoundsException();
        }
        Iterator iterator = collection.iterator();
        int n2 = collection.size();
        int n3 = this.modCount++;
        if (this.off >= n2 && n < this.len / 2) {
            System.arraycopy(this.a, this.off, this.a, this.off - n2, n);
            this.off -= n2;
        } else {
            this.ensureCapacity(this.len + n2);
            this.modCount = n3 + 1;
            System.arraycopy(this.a, this.off + n, this.a, this.off + n + n2, this.len - n);
        }
        int n4 = this.off + n;
        while (iterator.hasNext()) {
            this.a[n4] = iterator.next();
            ++n4;
        }
        this.len += n2;
        return true;
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (this.fixed) {
            throw new UnsupportedOperationException();
        }
        if (n < 0 || n2 > this.len) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 <= 0) {
            return;
        }
        ++this.modCount;
        if (n == 0) {
            this.off += n2;
        } else {
            System.arraycopy(this.a, this.off + n2, this.a, this.off + n, this.len - n2);
        }
        this.len -= n3;
    }
}

