/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7997698588986878753L;
    private static final int LONG_MASK = 63;
    private long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        int n2 = n >>> 6;
        if ((n & 0x3F) != 0) {
            ++n2;
        }
        this.bits = new long[n2];
    }

    public void and(BitSet bitSet) {
        int n = Math.min(this.bits.length, bitSet.bits.length);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & bitSet.bits[n2];
            ++n2;
        }
        while (n2 < this.bits.length) {
            this.bits[n2++] = 0L;
        }
    }

    public void andNot(BitSet bitSet) {
        int n = Math.min(this.bits.length, bitSet.bits.length);
        while (--n >= 0) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] & (bitSet.bits[n] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.bits.length - 1;
        while (n2 >= 0) {
            long l = this.bits[n2];
            if (l != 0L) {
                if (l == -1L) {
                    n += 64;
                } else {
                    l = (l >> 1 & 0x5555555555555555L) + (l & 0x5555555555555555L);
                    l = (l >> 2 & 0x3333333333333333L) + (l & 0x3333333333333333L);
                    int n3 = (int)((l >>> 32) + l);
                    n3 = (n3 >> 4 & 0xF0F0F0F) + (n3 & 0xF0F0F0F);
                    n3 = (n3 >> 8 & 0xFF00FF) + (n3 & 0xFF00FF);
                    n += (n3 >> 16 & 0xFFFF) + (n3 & 0xFFFF);
                }
            }
            --n2;
        }
        return n;
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
    }

    public void clear(int n) {
        int n2 = n >> 6;
        this.ensure(n2);
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        int n3 = n >>> 6;
        int n4 = n2 >>> 6;
        this.ensure(n4);
        if (n3 == n4) {
            int n5 = n4;
            this.bits[n5] = this.bits[n5] & ((1L << n) - 1L | -1L << n2);
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] & (1L << n) - 1L;
        int n7 = n4;
        this.bits[n7] = this.bits[n7] & -1L << n2;
        int n8 = n3 + 1;
        while (n8 < n4) {
            this.bits[n8] = 0L;
            ++n8;
        }
    }

    public Object clone() {
        try {
            BitSet bitSet = (BitSet)super.clone();
            bitSet.bits = (long[])this.bits.clone();
            return bitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitSet)) {
            return false;
        }
        BitSet bitSet = (BitSet)object;
        int n = Math.min(this.bits.length, bitSet.bits.length);
        int n2 = 0;
        while (n2 < n) {
            if (this.bits[n2] != bitSet.bits[n2]) {
                return false;
            }
            ++n2;
        }
        int n3 = n2;
        while (n3 < this.bits.length) {
            if (this.bits[n3] != 0L) {
                return false;
            }
            ++n3;
        }
        n3 = n2;
        while (n3 < bitSet.bits.length) {
            if (bitSet.bits[n3] != 0L) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void flip(int n) {
        int n2 = n >> 6;
        this.ensure(n2);
        int n3 = n2;
        this.bits[n3] = this.bits[n3] ^ 1L << n;
    }

    public void flip(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        int n3 = n >>> 6;
        int n4 = n2 >>> 6;
        this.ensure(n4);
        if (n3 == n4) {
            int n5 = n4;
            this.bits[n5] = this.bits[n5] ^ -1L << n & (1L << n2) - 1L;
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] ^ -1L << n;
        int n7 = n4;
        this.bits[n7] = this.bits[n7] ^ (1L << n2) - 1L;
        int n8 = n3 + 1;
        while (n8 < n4) {
            int n9 = n8++;
            this.bits[n9] = this.bits[n9] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public boolean get(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & 1L << n) != 0L;
    }

    public BitSet get(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        BitSet bitSet = new BitSet(n2 - n);
        int n3 = n >>> 6;
        if (n3 >= this.bits.length) {
            return bitSet;
        }
        int n4 = n & 0x3F;
        int n5 = n2 >>> 6;
        if (n4 == 0) {
            int n6 = Math.min(n5 - n3 + 1, this.bits.length - n3);
            System.arraycopy(this.bits, n3, bitSet.bits, 0, n6);
            if (n5 < this.bits.length) {
                int n7 = n5 - n3;
                bitSet.bits[n7] = bitSet.bits[n7] & (1L << n2) - 1L;
            }
            return bitSet;
        }
        int n8 = Math.min(n5, this.bits.length - 1);
        int n9 = ~n4;
        int n10 = 0;
        while (n3 < n8) {
            bitSet.bits[n10] = this.bits[n3] >>> n4 | this.bits[n3 + 1] << n9;
            ++n3;
            ++n10;
        }
        if ((n2 & 0x3F) > n4) {
            bitSet.bits[n10++] = this.bits[n3] >>> n4;
        }
        if (n5 < this.bits.length) {
            int n11 = n10 - 1;
            bitSet.bits[n11] = bitSet.bits[n11] & (1L << n2 - n) - 1L;
        }
        return bitSet;
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (n > 0) {
            l ^= (long)n * this.bits[--n];
        }
        return (int)(l >> 32 ^ l);
    }

    public boolean intersects(BitSet bitSet) {
        int n = Math.min(this.bits.length, bitSet.bits.length);
        while (--n >= 0) {
            if ((this.bits[n] & bitSet.bits[n]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        int n = this.bits.length - 1;
        while (n >= 0) {
            if (this.bits[n] != 0L) {
                return false;
            }
            --n;
        }
        return true;
    }

    public int length() {
        int n = this.bits.length - 1;
        while (n >= 0 && this.bits[n] == 0L) {
            --n;
        }
        if (n < 0) {
            return 0;
        }
        long l = this.bits[n];
        int n2 = (n + 1) * 64;
        while (l >= 0L) {
            --n2;
            l <<= 1;
        }
        return n2;
    }

    public int nextClearBit(int n) {
        int n2 = n >> 6;
        long l = 1L << n;
        while (n2 < this.bits.length) {
            long l2 = this.bits[n2];
            do {
                if ((l2 & l) == 0L) {
                    return n;
                }
                ++n;
            } while ((l <<= 1) != 0L);
            l = 1L;
            ++n2;
        }
        return n;
    }

    public int nextSetBit(int n) {
        int n2 = n >> 6;
        long l = 1L << n;
        while (n2 < this.bits.length) {
            long l2 = this.bits[n2];
            do {
                if ((l2 & l) != 0L) {
                    return n;
                }
                ++n;
            } while ((l <<= 1) != 0L);
            l = 1L;
            ++n2;
        }
        return -1;
    }

    public void or(BitSet bitSet) {
        this.ensure(bitSet.bits.length - 1);
        int n = bitSet.bits.length - 1;
        while (n >= 0) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] | bitSet.bits[n];
            --n;
        }
    }

    public void set(int n) {
        int n2 = n >> 6;
        this.ensure(n2);
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | 1L << n;
    }

    public void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
            return;
        }
        this.clear(n);
    }

    public void set(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        int n3 = n >>> 6;
        int n4 = n2 >>> 6;
        this.ensure(n4);
        if (n3 == n4) {
            int n5 = n4;
            this.bits[n5] = this.bits[n5] | -1L << n & (1L << n2) - 1L;
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] | -1L << n;
        int n7 = n4;
        this.bits[n7] = this.bits[n7] | (1L << n2) - 1L;
        int n8 = n3 + 1;
        while (n8 < n4) {
            this.bits[n8] = -1L;
            ++n8;
        }
    }

    public void set(int n, int n2, boolean bl) {
        if (bl) {
            this.set(n, n2);
            return;
        }
        this.clear(n, n2);
    }

    public int size() {
        return this.bits.length * 64;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        boolean bl = true;
        int n = 0;
        while (n < this.bits.length) {
            long l = 1L;
            long l2 = this.bits[n];
            if (l2 != 0L) {
                int n2 = 0;
                while (n2 < 64) {
                    if ((l2 & l) != 0L) {
                        if (!bl) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(64 * n + n2);
                        bl = false;
                    }
                    l <<= 1;
                    ++n2;
                }
            }
            ++n;
        }
        return stringBuffer.append("}").toString();
    }

    public void xor(BitSet bitSet) {
        this.ensure(bitSet.bits.length - 1);
        int n = bitSet.bits.length - 1;
        while (n >= 0) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] ^ bitSet.bits[n];
            --n;
        }
    }

    private final void ensure(int n) {
        if (n >= this.bits.length) {
            long[] lArray = new long[n + 1];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
    }
}

