/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Calendar
implements Serializable,
Cloneable {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    protected int[] fields;
    protected boolean[] isSet;
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    private TimeZone zone;
    private boolean lenient;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private int serialVersionOnStream;
    static final long serialVersionUID = -1807547505821590642L;
    private static final String bundleName = "gnu.java.locale.Calendar";
    private static final String[] fieldNames = new String[]{",ERA=", ",YEAR=", ",MONTH=", ",WEEK_OF_YEAR=", ",WEEK_OF_MONTH=", ",DAY_OF_MONTH=", ",DAY_OF_YEAR=", ",DAY_OF_WEEK=", ",DAY_OF_WEEK_IN_MONTH=", ",AM_PM=", ",HOUR=", ",HOUR_OF_DAY=", ",MINUTE=", ",SECOND=", ",MILLISECOND=", ",ZONE_OFFSET=", ",DST_OFFSET="};

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale2) {
        this.Block$();
        this.zone = timeZone;
        this.lenient = true;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, locale2);
        this.firstDayOfWeek = (Integer)resourceBundle.getObject("firstDayOfWeek");
        this.minimalDaysInFirstWeek = (Integer)resourceBundle.getObject("minimalDaysInFirstWeek");
    }

    public static synchronized Calendar getInstance() {
        return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static synchronized Calendar getInstance(TimeZone timeZone) {
        return Calendar.getInstance(timeZone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale2) {
        return Calendar.getInstance(TimeZone.getDefault(), locale2);
    }

    public static synchronized Calendar getInstance(TimeZone timeZone, Locale locale2) {
        String string = null;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, locale2);
        string = resourceBundle.getString("calendarClass");
        if (string != null) {
            try {
                Class clazz = Class.forName(string);
                if (Class.forName("java.util.Calendar").isAssignableFrom(clazz)) {
                    return (Calendar)clazz.getConstructor(new Class[]{Class.forName("java.util.TimeZone"), Class.forName("java.util.Locale")}).newInstance(new Object[]{timeZone, locale2});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return new GregorianCalendar(timeZone, locale2);
    }

    public static synchronized Locale[] getAvailableLocales() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, new Locale("", ""));
        return (Locale[])resourceBundle.getObject("availableLocales");
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return new Date(this.time);
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    public void setTimeInMillis(long l) {
        this.time = l;
        this.isTimeSet = true;
        this.computeFields();
    }

    public int get(int n) {
        if (!this.isSet[n]) {
            this.areFieldsSet = false;
        }
        this.complete();
        return this.fields[n];
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    public void set(int n, int n2) {
        this.isTimeSet = false;
        this.fields[n] = n2;
        this.isSet[n] = true;
        switch (n) {
            case 1: 
            case 2: 
            case 5: {
                this.isSet[3] = false;
                this.isSet[6] = false;
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                return;
            }
            case 9: {
                this.isSet[11] = false;
                return;
            }
            case 11: {
                this.isSet[9] = false;
                this.isSet[10] = false;
                return;
            }
            case 10: {
                this.isSet[11] = false;
            }
        }
    }

    public final void set(int n, int n2, int n3) {
        this.isTimeSet = false;
        this.fields[1] = n;
        this.fields[2] = n2;
        this.fields[5] = n3;
        this.isSet[5] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[3] = false;
        this.isSet[6] = false;
        this.isSet[4] = false;
        this.isSet[7] = false;
        this.isSet[8] = false;
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.set(n, n2, n3);
        this.fields[11] = n4;
        this.fields[12] = n5;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[9] = false;
        this.isSet[10] = false;
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(n, n2, n3, n4, n5);
        this.fields[13] = n6;
        this.isSet[13] = true;
    }

    public final void clear() {
        this.isTimeSet = false;
        this.areFieldsSet = false;
        int n = 0;
        while (n < 17) {
            this.isSet[n] = false;
            this.fields[n] = 0;
            ++n;
        }
    }

    public final void clear(int n) {
        this.isTimeSet = false;
        this.areFieldsSet = false;
        this.isSet[n] = false;
        this.fields[n] = 0;
    }

    public final boolean isSet(int n) {
        return this.isSet[n];
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    public boolean equals(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() == ((Calendar)object).getTimeInMillis();
    }

    public int hashCode() {
        long l = this.getTimeInMillis();
        return (int)(l & 0xFFFFFFFFL ^ l >> 32);
    }

    public boolean before(Object object) {
        return this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
    }

    public boolean after(Object object) {
        return this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
    }

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int n, int n2) {
        while (n2 > 0) {
            this.roll(n, true);
            --n2;
        }
        while (n2 < 0) {
            this.roll(n, false);
            ++n2;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int n) {
        this.firstDayOfWeek = n;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        this.minimalDaysInFirstWeek = n;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public abstract int getActualMinimum(int var1);

    public abstract int getActualMaximum(int var1);

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = (int[])this.fields.clone();
            calendar.isSet = (boolean[])this.isSet.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append('[');
        stringBuffer.append("time=");
        if (this.isTimeSet) {
            stringBuffer.append(this.time);
        } else {
            stringBuffer.append("?");
        }
        stringBuffer.append(new StringBuffer().append(",zone=").append(this.zone).toString());
        stringBuffer.append(new StringBuffer().append(",areFieldsSet=").append(this.areFieldsSet).toString());
        int n = 0;
        while (n < 17) {
            stringBuffer.append(fieldNames[n]);
            if (this.isSet[n]) {
                stringBuffer.append(this.fields[n]);
            } else {
                stringBuffer.append("?");
            }
            ++n;
        }
        stringBuffer.append(",lenient=").append(this.lenient);
        stringBuffer.append(",firstDayOfWeek=").append(this.firstDayOfWeek);
        stringBuffer.append(",minimalDaysInFirstWeek=").append(this.minimalDaysInFirstWeek);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (this.serialVersionOnStream > 1) {
            this.fields = new int[17];
            this.isSet = new boolean[17];
            this.areFieldsSet = false;
        }
    }

    private /* synthetic */ void Block$() {
        this.fields = new int[17];
        this.isSet = new boolean[17];
        this.serialVersionOnStream = 1;
    }
}

