/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private long gregorianCutover;
    static final long serialVersionUID = -8125100834729963327L;
    private static final String bundleName = "gnu.java.locale.Calendar";
    private static final int[] minimums = new int[]{0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, -43200000, 0};
    private static final int[] maximums = new int[]{1, 5000000, 11, 53, 5, 31, 366, 7, 5, 1, 12, 23, 59, 59, 999, 43200000, 43200000};

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale2) {
        this(TimeZone.getDefault(), locale2);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale2) {
        super(timeZone, locale2);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, locale2);
        this.gregorianCutover = ((Date)resourceBundle.getObject("gregorianCutOver")).getTime();
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        this.set(n, n2, n3, n4, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(n, n2, n3, n4, n5, n6);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int n) {
        if ((n & 3) != 0) {
            return false;
        }
        int n2 = ((n - 1) * 1461 >> 2) + -719105;
        if ((long)n2 * 86400000L < this.gregorianCutover) {
            return true;
        }
        return n % 100 != 0 || n % 400 == 0;
    }

    private long getLinearTime(int n, int n2, int n3) {
        int n4 = (n * 1461 >> 2) + n2 - 719530;
        long l = (long)n4 * 86400000L + (long)n3;
        if (l >= this.gregorianCutover) {
            int n5 = n / 400 - n / 100 + 2;
            if (this.isLeapYear(n, true) && n2 < 60) {
                --n5;
            }
            l += (long)n5 * 86400000L;
        }
        return l;
    }

    private int getWeekDay(int n, int n2) {
        int n3 = (int)(this.getLinearTime(n, n2, 0) / 86400000L);
        int n4 = (n3 + 5) % 7;
        if (n4 <= 0) {
            n4 += 7;
        }
        return n4;
    }

    private int[] getDayOfYear(int n) {
        int n2;
        if (this.isSet[2]) {
            if (this.fields[2] > 1) {
                n2 = (this.fields[2] * 153 - 9) / 5;
                if (this.isLeapYear(n)) {
                    ++n2;
                }
            } else {
                n2 = 31 * this.fields[2];
            }
            if (this.isSet[5]) {
                return new int[]{n2 + this.fields[5], 0};
            }
            if (this.isSet[4] && this.isSet[7]) {
                int n3 = this.getWeekDay(n, ++n2);
                return new int[]{n2, this.fields[7] - n3 + 7 * (this.fields[4] + (this.fields[7] < this.getFirstDayOfWeek() ? 0 : -1) + (n3 < this.getFirstDayOfWeek() ? -1 : 0))};
            }
            if (this.isSet[7] && this.isSet[8]) {
                int n4 = this.getWeekDay(n, ++n2);
                return new int[]{n2, this.fields[7] - n4 + 7 * (this.fields[8] + (this.fields[7] < n4 ? 0 : -1))};
            }
        }
        if (this.isSet[6]) {
            return new int[]{0, this.fields[6]};
        }
        if (this.isSet[7] && this.isSet[3]) {
            n2 = this.getMinimalDaysInFirstWeek();
            int n5 = this.getWeekDay(n, n2);
            return new int[]{n2, this.fields[7] - n5 + 7 * (this.fields[3] + (this.fields[7] < this.getFirstDayOfWeek() ? 0 : -1) + (n5 < this.getFirstDayOfWeek() ? -1 : 0))};
        }
        return new int[]{1, 0};
    }

    @Override
    protected synchronized void computeTime() {
        int n;
        int n2;
        int n3;
        int n4 = this.isSet[0] ? this.fields[0] : 1;
        int n5 = n3 = this.isSet[1] ? this.fields[1] : 1970;
        if (n4 == 0) {
            n3 = 1 - n3;
        }
        int[] nArray = this.getDayOfYear(n3);
        int n6 = 0;
        if (this.isSet[11]) {
            n6 = this.fields[11];
        } else if (this.isSet[10]) {
            n6 = this.fields[10];
            if (this.isSet[9] && this.fields[9] == 1) {
                n6 += 12;
            }
        }
        int n7 = this.isSet[12] ? this.fields[12] : 0;
        int n8 = this.isSet[13] ? this.fields[13] : 0;
        int n9 = n2 = this.isSet[14] ? this.fields[14] : 0;
        if (this.isLenient()) {
            long l = (((long)n6 * 60L + (long)n7) * 60L + (long)n8) * 1000L + (long)n2;
            nArray[1] = (int)((long)nArray[1] + l / 86400000L);
            n = (int)(l % 86400000L);
        } else {
            if (n6 < 0 || n6 >= 24 || n7 < 0 || n7 > 59 || n8 < 0 || n8 > 59 || n2 < 0 || n2 >= 1000) {
                throw new IllegalArgumentException();
            }
            n = ((n6 * 60 + n7) * 60 + n8) * 1000 + n2;
        }
        this.time = this.getLinearTime(n3, nArray[0], n);
        this.time += (long)nArray[1] * 86400000L;
        TimeZone timeZone = this.getTimeZone();
        int n10 = this.isSet[15] ? this.fields[15] : timeZone.getRawOffset();
        int n11 = nArray[0] + nArray[1];
        int n12 = (n11 * 5 + 3) / 153;
        int n13 = (6 + (n11 * 5 + 3) % 153) / 5;
        int n14 = ((int)(this.time / 86400000L) + 5) % 7;
        if (n14 <= 0) {
            n14 += 7;
        }
        int n15 = this.isSet[16] ? this.fields[16] : timeZone.getOffset(n3 < 0 ? 0 : 1, n3 < 0 ? 1 - n3 : n3, n12, n13, n14, n) - timeZone.getRawOffset();
        this.time -= (long)(n10 + n15);
        this.isTimeSet = true;
    }

    private boolean isLeapYear(int n, boolean bl) {
        if ((n & 3) != 0) {
            return false;
        }
        if (!bl) {
            return true;
        }
        return n % 100 != 0 || n % 400 == 0;
    }

    private int getLinearDay(int n, int n2, boolean bl) {
        int n3 = (n * 1461 >> 2) + n2 - 719530;
        if (bl) {
            int n4 = n / 400 - n / 100 + 2;
            if (this.isLeapYear(n, true) && n2 < 60) {
                --n4;
            }
            n3 += n4;
        }
        return n3;
    }

    private void calculateDay(int n, boolean bl) {
        int n2;
        int n3;
        int n4 = (n + 5) % 7;
        if (n4 <= 0) {
            n4 += 7;
        }
        this.fields[7] = n4;
        int n5 = 1970 + (bl ? (n - 100) * 400 / 146097 : (n - 100) * 4 / 1461);
        if (n >= 0) {
            ++n5;
        }
        if (n < (n3 = this.getLinearDay(n5, 1, bl))) {
            n3 = this.getLinearDay(--n5, 1, bl);
        }
        this.fields[6] = n -= n3 - 1;
        if (n5 <= 0) {
            this.fields[0] = 0;
            this.fields[1] = 1 - n5;
        } else {
            this.fields[0] = 1;
            this.fields[1] = n5;
        }
        int n6 = n2 = this.isLeapYear(n5, bl) ? 1 : 0;
        if (n <= 59 + n2) {
            this.fields[2] = n / 32;
            this.fields[5] = n - 31 * this.fields[2];
            return;
        }
        int n7 = (n - n2) * 5 + 8;
        this.fields[2] = n7 / 153;
        this.fields[5] = n7 % 153 / 5 + 1;
    }

    @Override
    protected synchronized void computeFields() {
        int n;
        boolean bl = this.time >= this.gregorianCutover;
        TimeZone timeZone = this.getTimeZone();
        this.fields[15] = timeZone.getRawOffset();
        long l = this.time + (long)this.fields[15];
        int n2 = (int)(l / 86400000L);
        int n3 = (int)(l % 86400000L);
        if (n3 < 0) {
            n3 += 86400000;
            --n2;
        }
        this.calculateDay(n2, bl);
        this.fields[16] = timeZone.getOffset(this.fields[0], this.fields[1], this.fields[2], this.fields[5], this.fields[7], n3) - this.fields[15];
        if ((n3 += this.fields[16]) >= 86400000) {
            n3 -= 86400000;
            this.calculateDay(++n2, bl);
        }
        this.fields[8] = (this.fields[5] + 6) / 7;
        int n4 = (7 + this.fields[7] - this.getFirstDayOfWeek()) % 7;
        this.fields[4] = (this.fields[5] - n4 + 12) / 7;
        int n5 = (this.fields[6] - n4 + 6) / 7;
        int n6 = this.getMinimalDaysInFirstWeek();
        if (n6 - (n = (7 + this.getWeekDay(this.fields[1], n6) - this.getFirstDayOfWeek()) % 7) < 1) {
            // empty if block
        }
        this.fields[3] = ++n5;
        int n7 = n3 / 3600000;
        this.fields[9] = n7 < 12 ? 0 : 1;
        int n8 = n7 % 12;
        this.fields[10] = n8 == 0 ? 12 : n8;
        this.fields[11] = n7;
        this.fields[12] = (n3 %= 3600000) / 60000;
        this.fields[13] = (n3 %= 60000) / 1000;
        this.fields[14] = n3 % 1000;
        this.isSet[16] = true;
        this.isSet[15] = true;
        this.isSet[14] = true;
        this.isSet[13] = true;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[10] = true;
        this.isSet[9] = true;
        this.isSet[8] = true;
        this.isSet[7] = true;
        this.isSet[6] = true;
        this.isSet[5] = true;
        this.isSet[4] = true;
        this.isSet[3] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[0] = true;
        this.areFieldsSet = true;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        return gregorianCalendar.getTimeInMillis() == this.getTimeInMillis();
    }

    @Override
    public void add(int n, int n2) {
        switch (n) {
            case 1: {
                this.complete();
                this.fields[1] = this.fields[1] + n2;
                this.isTimeSet = false;
                return;
            }
            case 2: {
                this.complete();
                int n3 = this.fields[2] + n2;
                this.fields[1] = this.fields[1] + n3 / 12;
                this.fields[2] = n3 % 12;
                if (this.fields[2] < 0) {
                    this.fields[2] = this.fields[2] + 12;
                    this.fields[1] = this.fields[1] + -1;
                }
                this.isTimeSet = false;
                int n4 = this.getActualMaximum(5);
                if (this.fields[5] <= n4) break;
                this.fields[5] = n4;
                this.isTimeSet = false;
                return;
            }
            case 5: 
            case 6: 
            case 7: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 86400000L;
                this.areFieldsSet = false;
                return;
            }
            case 3: 
            case 4: 
            case 8: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 604800000L;
                this.areFieldsSet = false;
                return;
            }
            case 9: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 43200000L;
                this.areFieldsSet = false;
                return;
            }
            case 10: 
            case 11: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 3600000L;
                this.areFieldsSet = false;
                return;
            }
            case 12: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 60000L;
                this.areFieldsSet = false;
                return;
            }
            case 13: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 1000L;
                this.areFieldsSet = false;
                return;
            }
            case 14: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2;
                this.areFieldsSet = false;
                return;
            }
            case 15: {
                this.complete();
                this.fields[15] = this.fields[15] + n2;
                this.time -= (long)n2;
                return;
            }
            case 16: {
                this.complete();
                this.fields[16] = this.fields[16] + n2;
                this.isTimeSet = false;
                return;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer().append("Unknown Calendar field: ").append(n).toString());
            }
        }
    }

    @Override
    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    private void cleanUpAfterRoll(int n, int n2) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (this.fields[5] > this.getActualMaximum(5)) {
                    this.fields[5] = this.getActualMaximum(5);
                }
                this.isTimeSet = false;
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                return;
            }
            case 5: {
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 86400000L;
                return;
            }
            case 4: {
                this.isSet[5] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 604800000L;
                return;
            }
            case 8: {
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 604800000L;
                return;
            }
            case 6: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[7] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 86400000L;
                return;
            }
            case 3: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.time += (long)n2 * 604800000L;
                return;
            }
            case 9: {
                this.isSet[11] = false;
                this.time += (long)n2 * 43200000L;
                return;
            }
            case 10: {
                this.isSet[11] = false;
                this.time += (long)n2 * 3600000L;
                return;
            }
            case 11: {
                this.isSet[10] = false;
                this.isSet[9] = false;
                this.time += (long)n2 * 3600000L;
                return;
            }
            case 12: {
                this.time += (long)n2 * 60000L;
                return;
            }
            case 13: {
                this.time += (long)n2 * 1000L;
                return;
            }
            case 14: {
                this.time += (long)n2;
            }
        }
    }

    @Override
    public void roll(int n, int n2) {
        switch (n) {
            case 7: {
                this.add(n, n2);
                return;
            }
            case 15: 
            case 16: {
                throw new IllegalArgumentException("Can't roll time zone");
            }
        }
        this.complete();
        int n3 = this.getActualMinimum(n);
        int n4 = this.getActualMaximum(n) - n3 + 1;
        int n5 = this.fields[n];
        int n6 = (n5 - n3 + n4 + n2) % n4 + n3;
        if (n6 < n3) {
            n6 += n4;
        }
        this.fields[n] = n6;
        this.cleanUpAfterRoll(n, n6 - n5);
    }

    @Override
    public int getMinimum(int n) {
        return minimums[n];
    }

    @Override
    public int getMaximum(int n) {
        return maximums[n];
    }

    @Override
    public int getGreatestMinimum(int n) {
        if (n == 3) {
            return 1;
        }
        return minimums[n];
    }

    @Override
    public int getLeastMaximum(int n) {
        switch (n) {
            case 3: {
                return 52;
            }
            case 5: {
                return 28;
            }
            case 6: {
                return 365;
            }
            case 4: 
            case 8: {
                return 4;
            }
        }
        return maximums[n];
    }

    @Override
    public int getActualMinimum(int n) {
        if (n == 3) {
            int n2;
            int n3;
            int n4 = this.getMinimalDaysInFirstWeek();
            if (n4 == 0) {
                return 1;
            }
            if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                this.complete();
            }
            if ((7 + (n3 = this.getWeekDay(n2 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1], n4)) - this.getFirstDayOfWeek()) % 7 >= n4 - 1) {
                return 1;
            }
            return 0;
        }
        return minimums[n];
    }

    @Override
    public int getActualMaximum(int n) {
        switch (n) {
            case 3: {
                int n2;
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int n3 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                int n4 = this.isLeapYear(n3) ? 366 : 365;
                int n5 = this.getWeekDay(n3, n4);
                int n6 = (n4 + 6 - (7 + n5 - this.getFirstDayOfWeek()) % 7) / 7;
                int n7 = this.getMinimalDaysInFirstWeek();
                if (n7 - (7 + (n2 = this.getWeekDay(n3, n7)) - this.getFirstDayOfWeek()) % 7 < 1) {
                    return n6 + 1;
                }
            }
            case 5: {
                int n4;
                int n3;
                if (!this.areFieldsSet || !this.isSet[2]) {
                    this.complete();
                }
                if ((n3 = this.fields[2]) == 1) {
                    if (!this.isSet[1] || !this.isSet[0]) {
                        this.complete();
                    }
                    int n8 = n4 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                    if (this.isLeapYear(n4)) {
                        return 29;
                    }
                    return 28;
                }
                if (n3 < 7) {
                    return 31 - (n3 & 1);
                }
                return 30 + (n3 & 1);
            }
            case 6: {
                int n9;
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int n10 = n9 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                if (this.isLeapYear(n9)) {
                    return 366;
                }
                return 365;
            }
            case 8: {
                int n11 = this.getActualMaximum(5);
                return (n11 - (this.fields[5] - 1) % 7 + 6) / 7;
            }
            case 4: {
                int n12 = this.getActualMaximum(5);
                int n13 = (n12 - this.fields[5] + this.fields[7] - 1) % 7 + 1;
                return (n12 + 6 - (7 + n13 - this.getFirstDayOfWeek()) % 7) / 7;
            }
        }
        return maximums[n];
    }
}

