/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1421746759512286392L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("threshold", Integer.TYPE), new ObjectStreamField("loadFactor", Float.TYPE)};
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOADFACTOR = 0.75f;
    private transient HashMap map;

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        this.map = new HashMap(n, f);
    }

    public Hashtable(Map map) {
        this.map = new HashMap(map);
    }

    private Hashtable(HashMap hashMap) {
        this.map = hashMap;
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized Enumeration keys() {
        return new Vector(this.map.keySet()).elements();
    }

    @Override
    public synchronized Enumeration elements() {
        return new Vector(this.map.values()).elements();
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.map.containsValue(object);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.map.containsKey(object);
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.map.containsValue(object);
    }

    @Override
    public synchronized Object get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.map.get(object);
    }

    protected synchronized void rehash() {
        this.map.rehash();
    }

    @Override
    public synchronized Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        return this.map.put(object, object2);
    }

    @Override
    public synchronized Object remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public synchronized void putAll(Map map) {
        this.map.putAll(map);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.map = (HashMap)this.map.clone();
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public synchronized String toString() {
        return this.map.toString();
    }

    @Override
    public synchronized Set keySet() {
        return this.map.keySet();
    }

    @Override
    public synchronized Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public synchronized Collection values() {
        return this.map.values();
    }

    @Override
    public synchronized boolean equals(Object object) {
        return AbstractMap.equals(this, object);
    }

    @Override
    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    private void readObjectNoData() {
        this.map = new HashMap();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        float f = getField.get("loadFactor", 0.75f);
        int n = getField.get("threshold", 0);
        int n2 = objectInputStream.readInt();
        this.map = new HashMap(n2, f);
        int n3 = objectInputStream.readInt();
        while (n3-- > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.map.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("loadFactor", this.map.loadFactor);
        putField.put("threshold", (int)((float)this.map.size() * this.map.loadFactor));
        objectOutputStream.writeFields();
        Hashtable hashtable = this;
        synchronized (hashtable) {
            objectOutputStream.writeInt(this.map.getTableLength());
            objectOutputStream.writeInt(this.map.size());
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                objectOutputStream.writeObject(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
            return;
        }
    }
}

