/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Locale
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9149081749638150636L;
    public static final PropertyPermission SET_PERMISSION = new PropertyPermission("user.language", "write");
    public static final Locale CANADA = new Locale("en", "CA");
    public static final Locale CANADA_FRENCH = new Locale("fr", "CA");
    public static final Locale CHINA = new Locale("zh", "CN");
    public static final Locale CHINESE = new Locale("zh", null);
    public static final Locale ENGLISH = new Locale("en", null);
    public static final Locale FRANCE = new Locale("fr", "FR");
    public static final Locale FRENCH = new Locale("fr", null);
    public static final Locale GERMAN = new Locale("de", null);
    public static final Locale GERMANY = new Locale("de", "DE");
    public static final Locale ITALY = new Locale("it", "IT");
    public static final Locale ITALIAN = new Locale("it", null);
    public static final Locale JAPAN = new Locale("ja", "JP");
    public static final Locale JAPANESE = new Locale("ja", null);
    public static final Locale KOREA = new Locale("ko", "KR");
    public static final Locale KOREAN = new Locale("ko", null);
    public static final Locale PRC = CHINA;
    public static final Locale SIMPLIFIED_CHINESE = CHINA;
    public static final Locale TAIWAN;
    public static final Locale TRADITIONAL_CHINESE;
    public static final Locale UK;
    public static final Locale US;
    private static final String RESOURCEBASE = "kaffe.util.locale.";
    private static final String COUNTRY = "kaffe.util.locale.Country";
    private static final String COUNTRY_CODES = "kaffe.util.locale.CountryCodes";
    private static final String LANGUAGE = "kaffe.util.locale.Language";
    private static final String LANGUAGE_CODES = "kaffe.util.locale.LanguageCodes";
    private static Locale defaultLocale;
    private String lang;
    private String cntry;
    private String var;
    private int hashcode;

    private static String toLowerCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toLowerCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private static String toUpperCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toUpperCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    public Locale(String string) {
        this(string, "");
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string, String string2, String string3) {
        this.lang = string != null ? Locale.toLowerCase(string) : "";
        this.cntry = string2 != null ? Locale.toUpperCase(string2) : "";
        this.var = string3 != null ? Locale.toUpperCase(string3) : "";
        this.hashcode = this.lang.hashCode() ^ this.cntry.hashCode() ^ this.var.hashCode();
    }

    public Object clone() {
        return new Locale(this.lang, this.cntry, this.var);
    }

    public boolean equals(Object object) {
        if (object instanceof Locale) {
            Locale locale2 = (Locale)object;
            if (!(this.lang != locale2.lang && !this.lang.equals(locale2.lang) || this.cntry != locale2.cntry && !this.cntry.equals(locale2.cntry) || this.var != locale2.var && !this.var.equals(locale2.var))) {
                return true;
            }
        }
        return false;
    }

    public String getCountry() {
        return this.cntry;
    }

    public static synchronized Locale getDefault() {
        return defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale2) {
        return this.getDisplayResource(locale2, COUNTRY, this.getCountry());
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale2) {
        return this.getDisplayResource(locale2, LANGUAGE, this.getLanguage());
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale2) {
        String string = this.getDisplayCountry(locale2);
        if (string.equals("")) {
            return this.getDisplayLanguage(locale2);
        }
        return new StringBuffer().append(this.getDisplayLanguage(locale2)).append(" (").append(string).append(')').toString();
    }

    private String getDisplayResource(Locale locale2, String string, String string2) {
        if (string2.equals("")) {
            return "";
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale2);
        String string3 = resourceBundle.getString(string2);
        if (string3.equals("")) {
            resourceBundle = ResourceBundle.getBundle(string, this);
            string3 = resourceBundle.getString(string2);
        }
        return string3;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale2) {
        return this.var;
    }

    public String getISO3Country() throws MissingResourceException {
        return Locale.getDefault().getDisplayResource(this, COUNTRY_CODES, this.getCountry());
    }

    public static String[] getISOCountries() {
        return Locale.getKeys(ResourceBundle.getBundle(COUNTRY_CODES));
    }

    public String getISO3Language() throws MissingResourceException {
        return Locale.getDefault().getDisplayResource(this, LANGUAGE_CODES, this.getLanguage());
    }

    public static String[] getISOLanguages() {
        return Locale.getKeys(ResourceBundle.getBundle(LANGUAGE_CODES));
    }

    private static String[] getKeys(ResourceBundle resourceBundle) {
        return (String[])Collections.list(resourceBundle.getKeys()).toArray(new String[0]);
    }

    public String getLanguage() {
        return this.lang;
    }

    public String getVariant() {
        return this.var;
    }

    public synchronized int hashCode() {
        return this.hashcode;
    }

    public static synchronized void setDefault(Locale locale2) {
        if (locale2 == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_PERMISSION);
        }
        defaultLocale = locale2;
    }

    public final String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.lang.length() > 0;
        boolean bl3 = this.cntry.length() > 0;
        boolean bl4 = bl = this.var.length() > 0;
        if (bl2) {
            stringBuffer.append(this.lang);
        }
        if (bl3) {
            stringBuffer.append('_');
            stringBuffer.append(this.cntry);
        } else if (bl2 && bl) {
            stringBuffer.append('_');
        }
        if (bl && (bl2 || bl3)) {
            stringBuffer.append('_');
            stringBuffer.append(this.var);
        }
        return new String(stringBuffer);
    }

    static {
        TRADITIONAL_CHINESE = TAIWAN = new Locale("zh", "TW");
        UK = new Locale("en", "GB");
        US = new Locale("en", "US");
        String string = System.getProperty("user.language", "en");
        String string2 = System.getProperty("user.region", "US");
        String string3 = "";
        int n = string2.indexOf(95);
        if (n != -1) {
            string3 = string2.substring(n + 1);
            string2 = string2.substring(n);
        }
        defaultLocale = new Locale(string, string2, string3);
    }
}

