/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Object NULL_KEY = new 1();
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    private static final boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private static final int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    public WeakHashMap() {
        this(11, 0.75f);
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
        this.theEntrySet = new WeakEntrySet();
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[n];
    }

    public WeakHashMap(Map map) {
        this(map.size(), 0.75f);
        this.putAll(map);
    }

    private int hash(Object object) {
        return Math.abs(object.hashCode() % this.buckets.length);
    }

    void cleanQueue() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.internalRemove((WeakBucket)reference);
            reference = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] weakBucketArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new WeakBucket[n];
        int n2 = 0;
        while (n2 < weakBucketArray.length) {
            WeakBucket weakBucket = weakBucketArray[n2];
            while (weakBucket != null) {
                WeakBucket weakBucket2 = weakBucket.next;
                Object object = weakBucket.get();
                if (object == null) {
                    weakBucket.slot = -1;
                    this.size += -1;
                } else {
                    int n3;
                    weakBucket.slot = n3 = this.hash(object);
                    weakBucket.next = this.buckets[n3];
                    this.buckets[n3] = weakBucket;
                }
                weakBucket = weakBucket2;
            }
            ++n2;
        }
    }

    private WeakBucket.WeakEntry internalGet(Object object) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = this.buckets[n];
        while (weakBucket != null) {
            WeakBucket.WeakEntry weakEntry = weakBucket.getEntry();
            if (weakEntry != null && object.equals(weakEntry.key)) {
                return weakEntry;
            }
            weakBucket = weakBucket.next;
        }
        return null;
    }

    private void internalAdd(Object object, Object object2) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = new WeakBucket(object, this.queue, object2, n);
        weakBucket.next = this.buckets[n];
        this.buckets[n] = weakBucket;
        ++this.size;
    }

    void internalRemove(WeakBucket weakBucket) {
        int n = weakBucket.slot;
        if (n == -1) {
            return;
        }
        weakBucket.slot = -1;
        if (this.buckets[n] == weakBucket) {
            this.buckets[n] = weakBucket.next;
        } else {
            WeakBucket weakBucket2 = this.buckets[n];
            while (weakBucket2.next != weakBucket) {
                weakBucket2 = weakBucket2.next;
            }
            weakBucket2.next = weakBucket.next;
        }
        this.size += -1;
    }

    @Override
    public int size() {
        this.cleanQueue();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        this.cleanQueue();
        return this.internalGet(object) != null;
    }

    @Override
    public Object get(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry == null) {
            return null;
        }
        return weakEntry.getValue();
    }

    @Override
    public Object put(Object object, Object object2) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry != null) {
            return weakEntry.setValue(object2);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(object, object2);
        return null;
    }

    @Override
    public Object remove(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(weakEntry.getBucket());
        return weakEntry.getValue();
    }

    @Override
    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean containsValue(Object object) {
        this.cleanQueue();
        return super.containsValue(object);
    }

    @Override
    public Set keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    @Override
    public void putAll(Map map) {
        super.putAll(map);
    }

    @Override
    public Collection values() {
        this.cleanQueue();
        return super.values();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WeakEntrySet
    extends AbstractSet {
        WeakEntrySet() {
        }

        @Override
        public int size() {
            return WeakHashMap.this.size;
        }

        @Override
        public Iterator iterator() {
            return new 1();
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 1
        implements Iterator {
            WeakBucket.WeakEntry lastEntry;
            WeakBucket.WeakEntry nextEntry;
            int knownMod;

            private void checkMod() {
                WeakHashMap.this.cleanQueue();
                if (this.knownMod != ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            private WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry weakEntry) {
                int n;
                WeakBucket weakBucket;
                if (weakEntry != null) {
                    weakBucket = weakEntry.getBucket().next;
                    n = weakEntry.getBucket().slot;
                } else {
                    weakBucket = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets[0];
                    n = 0;
                }
                while (true) {
                    if (weakBucket != null) {
                        WeakBucket.WeakEntry weakEntry2 = weakBucket.getEntry();
                        if (weakEntry2 != null) {
                            return weakEntry2;
                        }
                        weakBucket = weakBucket.next;
                        continue;
                    }
                    if (++n == ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets.length) {
                        return null;
                    }
                    weakBucket = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets[n];
                }
            }

            @Override
            public boolean hasNext() {
                this.checkMod();
                return this.nextEntry != null;
            }

            @Override
            public Object next() {
                this.checkMod();
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.findNext(this.lastEntry);
                return this.lastEntry;
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.lastEntry == null) {
                    throw new IllegalStateException();
                }
                ++((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount;
                WeakHashMap.this.internalRemove(this.lastEntry.getBucket());
                this.lastEntry = null;
                ++this.knownMod;
            }

            public 1() {
                this.Block$();
            }

            private /* synthetic */ void Block$() {
                this.nextEntry = this.findNext(null);
                this.knownMod = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount;
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        public WeakBucket(Object object, ReferenceQueue referenceQueue, Object object2, int n) {
            super(object, referenceQueue);
            this.value = object2;
            this.slot = n;
        }

        WeakEntry getEntry() {
            Object object = this.get();
            if (object == null) {
                return null;
            }
            return new WeakEntry(object);
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WeakEntry
        implements Map.Entry {
            Object key;

            public WeakEntry(Object object) {
                this.key = object;
            }

            public WeakBucket getBucket() {
                return WeakBucket.this;
            }

            @Override
            public Object getKey() {
                if (this.key == NULL_KEY) {
                    return null;
                }
                return this.key;
            }

            @Override
            public Object getValue() {
                return WeakBucket.this.value;
            }

            @Override
            public Object setValue(Object object) {
                Object object2 = WeakBucket.this.value;
                WeakBucket.this.value = object;
                return object2;
            }

            @Override
            public int hashCode() {
                return this.key.hashCode() ^ WeakHashMap.hashCode(WeakBucket.this.value);
            }

            @Override
            public boolean equals(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return this.key.equals(entry.getKey()) && WeakHashMap.equals(WeakBucket.this.value, entry.getValue());
                }
                return false;
            }

            public String toString() {
                return new StringBuffer().append(this.key).append("=").append(WeakBucket.this.value).toString();
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1 {
        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object == null || this == object;
        }
    }
}

