/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manifest
implements Cloneable {
    private static final Attributes.Name NAME = new Attributes.Name("Name");
    private static final String MANIFEST_ENCODING = "8859_1";
    private Attributes main;
    private HashMap ents;

    public Manifest() {
        this.main = new Attributes();
        this.ents = new HashMap();
    }

    public Manifest(InputStream inputStream) throws IOException {
        this.main = new Attributes();
        this.ents = new HashMap();
        this.read(inputStream, false);
    }

    public Manifest(Manifest manifest) {
        this.main = (Attributes)manifest.main.clone();
        this.ents = (HashMap)manifest.ents.clone();
    }

    public Attributes getMainAttributes() {
        return this.main;
    }

    public Map getEntries() {
        return this.ents;
    }

    public Attributes getAttributes(String string) {
        return (Attributes)this.getEntries().get(string);
    }

    public void clear() {
        this.main.clear();
        this.ents.clear();
    }

    public void write(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, MANIFEST_ENCODING)));
        String string = this.main.getValue(Attributes.Name.MANIFEST_VERSION);
        if (string == null) {
            string = "1.0";
        }
        printWriter.println(new StringBuffer().append(Attributes.Name.MANIFEST_VERSION).append(": ").append(string).toString());
        this.writeAttributes(printWriter, this.main, Attributes.Name.MANIFEST_VERSION);
        printWriter.println();
        Iterator iterator = this.ents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Attributes attributes = (Attributes)entry.getValue();
            printWriter.println(new StringBuffer().append("Name: ").append(attributes.getValue(NAME)).toString());
            this.writeAttributes(printWriter, attributes, NAME);
            printWriter.println();
        }
        printWriter.flush();
    }

    private void writeAttributes(PrintWriter printWriter, Attributes attributes, Attributes.Name name) {
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Attributes.Name name2 = (Attributes.Name)entry.getKey();
            String string = (String)entry.getValue();
            if (name2.equals(name)) continue;
            printWriter.println(new StringBuffer().append(name2).append(": ").append(string).toString());
        }
    }

    public void read(InputStream inputStream) throws IOException {
        this.read(inputStream, true);
    }

    private void read(InputStream inputStream, boolean bl) throws IOException {
        boolean bl2 = false;
        boolean bl3 = true;
        int n = 2;
        int n2 = 3;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        PushbackReader pushbackReader = new PushbackReader(new BufferedReader(new InputStreamReader(inputStream, MANIFEST_ENCODING)));
        try {
            while (true) {
                Attributes attributes = new Attributes();
                StringBuffer stringBuffer = null;
                StringBuffer stringBuffer2 = null;
                block9: while (true) {
                    int n6;
                    if ((n6 = pushbackReader.read()) == -1 && n3 != 3) {
                        throw new EOFException();
                    }
                    if (n6 == 13) {
                        n6 = pushbackReader.read();
                        if (n6 != -1 && n6 != 10) {
                            pushbackReader.unread(n6);
                        }
                        n6 = 10;
                    }
                    if (n6 == 10) {
                        ++n5;
                    }
                    switch (n3) {
                        case 0: {
                            if (n6 == 0) {
                                int n7 = pushbackReader.read();
                                if (n7 == -1) {
                                    throw new EOFException();
                                }
                                pushbackReader.unread(n7);
                            }
                            if (n6 == 10) {
                                if (attributes.size() != 0) break block9;
                                continue block9;
                            }
                            if (!(n6 >= 48 && n6 <= 57 || n6 >= 65 && n6 <= 90 || n6 >= 97 && n6 <= 122)) {
                                throw new IOException(new StringBuffer().append("invalid manifest, line ").append(n5).toString());
                            }
                            stringBuffer = new StringBuffer();
                            stringBuffer.append((char)n6);
                            n3 = 1;
                            continue block9;
                        }
                        case 1: {
                            if (n6 == 58) {
                                n6 = pushbackReader.read();
                                if (n6 != 32) {
                                    throw new IOException(new StringBuffer().append("invalid manifest, line ").append(n5).toString());
                                }
                                stringBuffer2 = new StringBuffer();
                                n3 = 2;
                                continue block9;
                            }
                            if (!(n6 >= 48 && n6 <= 57 || n6 >= 65 && n6 <= 90 || n6 >= 97 && n6 <= 122 || n6 == 95 || n6 == 45)) {
                                throw new IOException(new StringBuffer().append("invalid manifest, line ").append(n5).toString());
                            }
                            stringBuffer.append((char)n6);
                            continue block9;
                        }
                        case 2: {
                            if (n6 == 10) {
                                n3 = 3;
                                continue block9;
                            }
                            stringBuffer2.append((char)n6);
                            continue block9;
                        }
                        case 3: {
                            if (n6 == 32 || n6 == 9) {
                                n3 = 2;
                                continue block9;
                            }
                            attributes.putValue(stringBuffer.toString(), stringBuffer2.toString());
                            n3 = 0;
                            if (n6 == -1) break block9;
                            pushbackReader.unread(n6);
                        }
                        default: {
                            continue block9;
                        }
                    }
                    break;
                }
                if (n4++ == 0) {
                    if (bl) {
                        this.main.putAll(attributes);
                        continue;
                    }
                    this.main = attributes;
                    continue;
                }
                String string = attributes.getValue(NAME);
                if (string == null) {
                    throw new IOException(new StringBuffer().append("invalid manifest, line ").append(n5).append(": missing ``Name'' header").toString());
                }
                Attributes attributes2 = (Attributes)this.ents.get(string);
                if (attributes2 == null) {
                    this.ents.put(string, attributes);
                    continue;
                }
                if (!bl) continue;
                attributes2.putAll(attributes);
            }
        }
        catch (EOFException eOFException) {
            if (n4 == 0 || n3 != 0) {
                throw new IOException(new StringBuffer().append("premature EOF, line ").append(n5).toString());
            }
            return;
        }
    }

    public boolean equals(Object object) {
        return object instanceof Manifest && this.main.equals(((Manifest)object).main) && this.ents.equals(((Manifest)object).ents);
    }

    public int hashCode() {
        return this.main.hashCode() ^ this.ents.hashCode();
    }

    public Object clone() {
        return new Manifest(this);
    }
}

