/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryHandler
extends Handler {
    private final LogRecord[] buffer;
    private int position;
    private int numPublished;
    private Level pushLevel;
    private final Handler target;

    public MemoryHandler() {
        this((Handler)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.target", Class.forName("java.util.logging.Handler"), null), LogManager.getIntPropertyClamped("java.util.logging.MemoryHandler.size", 1000, 1, Integer.MAX_VALUE), LogManager.getLevelProperty("java.util.logging.MemoryHandler.push", Level.SEVERE));
    }

    public MemoryHandler(Handler handler, int n, Level level) {
        if (handler == null || n <= 0 || level == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = new LogRecord[n];
        this.pushLevel = level;
        this.target = handler;
        this.setLevel(LogManager.getLevelProperty("java.util.logging.MemoryHandler.level", Level.ALL));
        this.setFilter((Filter)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.filter", Class.forName("java.util.logging.Filter"), null));
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        this.buffer[this.position] = logRecord;
        this.position = (this.position + 1) % this.buffer.length;
        ++this.numPublished;
        if (logRecord.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public void push() {
        if (this.numPublished < this.buffer.length) {
            int n = 0;
            while (n < this.position) {
                this.target.publish(this.buffer[n]);
                ++n;
            }
        } else {
            int n = this.position;
            while (n < this.buffer.length) {
                this.target.publish(this.buffer[n]);
                ++n;
            }
            n = 0;
            while (n < this.position) {
                this.target.publish(this.buffer[n]);
                ++n;
            }
        }
        this.numPublished = 0;
        this.position = 0;
    }

    @Override
    public void flush() {
        this.target.flush();
    }

    @Override
    public void close() throws SecurityException {
        this.push();
        this.target.close();
    }

    public Level getPushLevel() {
        return this.pushLevel;
    }

    public void setPushLevel(Level level) {
        LogManager.getLogManager().checkAccess();
        level.getClass();
        this.pushLevel = level;
    }
}

