/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.ZipConstants;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntry
implements Cloneable,
ZipConstants {
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    String name;
    long time;
    int dosTime;
    long crc;
    long size;
    int method;
    byte[] extra;
    String comment;
    int flag;
    int version;
    long csize;
    long offset;

    ZipEntry() {
        this.Block$();
    }

    public ZipEntry(String string) {
        this.Block$();
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() > 65535) {
            throw new IllegalArgumentException("name length > 0xFFFF");
        }
        this.name = string;
        this.time = new Date().getTime();
        this.dosTime = this.computeDosTime(this.time);
        this.crc = -1L;
        this.size = -1L;
        this.method = -1;
        this.extra = null;
        this.comment = null;
        this.flag = 0;
        this.version = 0;
        this.csize = -1L;
        this.offset = 0L;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this.Block$();
        this.name = zipEntry.name;
        this.time = zipEntry.time;
        this.dosTime = zipEntry.dosTime;
        this.crc = zipEntry.crc;
        this.size = zipEntry.size;
        this.method = zipEntry.method;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
        this.flag = zipEntry.flag;
        this.version = zipEntry.version;
        this.csize = zipEntry.csize;
        this.offset = zipEntry.offset;
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l) {
        this.time = l;
        this.dosTime = this.computeDosTime(l);
    }

    public long getTime() {
        if (this.time == -1L && this.dosTime != 0) {
            this.setDosTime(this.dosTime);
        }
        return this.time;
    }

    public void setSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("size < 0 or size > 0xFFFFFFFF");
        }
        this.size = l;
    }

    public long getSize() {
        return this.size;
    }

    public void setCrc(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(new StringBuffer().append("crc < 0 or > 0xFFFFFFFF: ").append(l).toString());
        }
        this.crc = l;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException("unsupported compression method");
        }
        this.method = n;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        if (byArray != null && byArray.length > 1048575) {
            throw new IllegalArgumentException("extra length > 0xFFFFF");
        }
        this.extra = byArray;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException("comment length > 0xFFFF");
        }
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setCompressedSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("csize < 0 or csize > 0xFFFFFFFF");
        }
        this.csize = l;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public String toString() {
        return this.getName();
    }

    int computeDosTime(long l) {
        l = l + 1L & 0xFFFFFFFFFFFFFFFEL;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l));
        return this.encodeDosTime(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13));
    }

    int encodeDosTime(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 1980) {
            return this.encodeDosTime(1980, 1, 1, 0, 0, 0);
        }
        return n - 1980 << 25 | n2 << 21 | n3 << 16 | n4 << 11 | n5 << 5 | n6 >>> 1;
    }

    void setDosTime(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        gregorianCalendar.set((n >> 25 & 0x7F) + 1980, (n >> 21 & 0xF) - 1, n >> 16 & 0x1F, n >> 11 & 0x1F, n >> 5 & 0x3F, n << 1 & 0x3E);
        this.time = gregorianCalendar.getTime().getTime();
        this.dosTime = n;
    }

    private /* synthetic */ void Block$() {
        this.time = -1L;
    }
}

