/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttributes
implements Attributes {
    private boolean ignoreCase;
    private transient Vector attributes;

    public BasicAttributes() {
        this(false);
    }

    public BasicAttributes(boolean bl) {
        this.ignoreCase = bl;
        this.attributes = new Vector();
    }

    public BasicAttributes(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttributes(String string, Object object, boolean bl) {
        this.ignoreCase = bl;
        this.attributes = new Vector();
        this.attributes.add(new BasicAttribute(string, object));
    }

    @Override
    public Object clone() {
        BasicAttributes basicAttributes = new BasicAttributes(this.ignoreCase);
        basicAttributes.attributes = (Vector)this.attributes.clone();
        return basicAttributes;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicAttributes)) {
            return false;
        }
        BasicAttributes basicAttributes = (BasicAttributes)object;
        if (this.ignoreCase != basicAttributes.ignoreCase || this.attributes.size() != basicAttributes.attributes.size()) {
            return false;
        }
        int n = 0;
        while (n < this.attributes.size()) {
            if (!this.attributes.get(n).equals(basicAttributes.attributes.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public Attribute get(String string) {
        int n = 0;
        while (n < this.attributes.size()) {
            Attribute attribute = (Attribute)this.attributes.get(n);
            if (this.ignoreCase && string.equalsIgnoreCase(attribute.getID()) || !this.ignoreCase && string.equals(attribute.getID())) {
                return attribute;
            }
            ++n;
        }
        return null;
    }

    @Override
    public NamingEnumeration getAll() {
        return new BasicAttributesEnumeration(false);
    }

    @Override
    public NamingEnumeration getIDs() {
        return new BasicAttributesEnumeration(true);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.attributes.size()) {
            n += this.attributes.get(n2).hashCode();
            ++n2;
        }
        return n;
    }

    @Override
    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    @Override
    public Attribute put(Attribute attribute) {
        Attribute attribute2 = this.remove(attribute.getID());
        this.attributes.add(attribute);
        return attribute2;
    }

    @Override
    public Attribute put(String string, Object object) {
        return this.put(new BasicAttribute(string, object));
    }

    @Override
    public Attribute remove(String string) {
        int n = 0;
        while (n < this.attributes.size()) {
            Attribute attribute = (Attribute)this.attributes.get(n);
            if (this.ignoreCase && string.equalsIgnoreCase(attribute.getID()) || !this.ignoreCase && string.equals(attribute.getID())) {
                this.attributes.remove(n);
                return attribute;
            }
            ++n;
        }
        return null;
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.attributes.size()) {
            if (n > 0) {
                string = string.concat("; ");
            }
            string = string.concat(this.attributes.get(n).toString());
            ++n;
        }
        return string;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BasicAttributesEnumeration
    implements NamingEnumeration {
        int where;
        boolean id;

        public BasicAttributesEnumeration(boolean bl) {
            this.Block$();
            this.id = bl;
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMoreElements() {
            return this.where < BasicAttributes.this.attributes.size();
        }

        @Override
        public Object nextElement() throws NoSuchElementException {
            if (this.where + 1 >= BasicAttributes.this.attributes.size()) {
                throw new NoSuchElementException("no more elements");
            }
            ++this.where;
            Attribute attribute = (Attribute)BasicAttributes.this.attributes.get(this.where);
            if (this.id) {
                return attribute.getID();
            }
            return attribute;
        }

        private /* synthetic */ void Block$() {
            this.where = -1;
        }
    }
}

