/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.MidiUtils;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MidiMessage
implements Cloneable {
    protected byte[] data;
    protected int length;

    protected MidiMessage(byte[] byArray) {
        if (byArray != null) {
            this.copyToData(byArray, byArray.length);
        }
    }

    protected void setMessage(byte[] byArray, int n) throws InvalidMidiDataException {
        this.copyToData(byArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToData(byte[] byArray, int n) {
        MidiMessage midiMessage = this;
        synchronized (midiMessage) {
            this.data = new byte[n];
            System.arraycopy(byArray, 0, this.data, 0, n);
            this.length = n;
            return;
        }
    }

    public byte[] getMessage() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        return byArray;
    }

    public int getStatus() {
        int n = MidiUtils.getUnsignedInteger(this.data[0]);
        return n;
    }

    public int getLength() {
        return this.length;
    }

    public abstract Object clone();

    private void outputData() {
        String string = "MidiMessage.outputData(): data: [";
        int n = 0;
        while (n < this.data.length) {
            string = string.concat(new StringBuffer().append(this.data[n]).append(", ").toString());
            ++n;
        }
        string = string.concat("]");
        TDebug.out(string);
    }
}

