/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;
import org.tritonus.core.TAudioConfig;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;
    private static final AudioFormat[] EMPTY_FORMAT_ARRAY = new AudioFormat[0];
    private static final AudioFormat.Encoding[] EMPTY_ENCODING_ARRAY = new AudioFormat.Encoding[0];
    private static final AudioFileFormat.Type[] EMPTY_TYPE_ARRAY = new AudioFileFormat.Type[0];
    private static final Mixer.Info[] EMPTY_MIXER_INFO_ARRAY = new Mixer.Info[0];
    private static final Line.Info[] EMPTY_LINE_INFO_ARRAY = new Line.Info[0];

    public static Mixer.Info[] getMixerInfo() {
        GetMixerInfoMixerProviderAction getMixerInfoMixerProviderAction = new GetMixerInfoMixerProviderAction();
        AudioSystem.doMixerProviderIteration(getMixerInfoMixerProviderAction);
        Mixer.Info[] infoArray = getMixerInfoMixerProviderAction.getMixerInfos();
        return getMixerInfoMixerProviderAction.getMixerInfos();
    }

    public static Mixer getMixer(Mixer.Info info) {
        if (info == null) {
            info = TAudioConfig.getDefaultMixerInfo();
        }
        GetMixerMixerProviderAction getMixerMixerProviderAction = new GetMixerMixerProviderAction(info);
        AudioSystem.doMixerProviderIteration(getMixerMixerProviderAction);
        Mixer mixer = getMixerMixerProviderAction.getMixer();
        if (mixer != null) {
            return mixer;
        }
        throw new IllegalArgumentException(new StringBuffer().append("no mixer found for ").append(info).toString());
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        GetSourceLineInfoMixerAction getSourceLineInfoMixerAction = new GetSourceLineInfoMixerAction(info);
        AudioSystem.doMixerIteration(getSourceLineInfoMixerAction);
        return getSourceLineInfoMixerAction.getInfos();
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        GetTargetLineInfoMixerAction getTargetLineInfoMixerAction = new GetTargetLineInfoMixerAction(info);
        AudioSystem.doMixerIteration(getTargetLineInfoMixerAction);
        return getTargetLineInfoMixerAction.getInfos();
    }

    public static boolean isLineSupported(Line.Info info) {
        IsLineSupportedMixerAction isLineSupportedMixerAction = new IsLineSupportedMixerAction(info);
        AudioSystem.doMixerIteration(isLineSupportedMixerAction);
        return isLineSupportedMixerAction.isSupported();
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        GetLineMixerAction getLineMixerAction = new GetLineMixerAction(info);
        AudioSystem.doMixerIteration(getLineMixerAction);
        Line line = getLineMixerAction.getLine();
        if (line != null) {
            return line;
        }
        if (getLineMixerAction.isLineTypeSupported()) {
            throw new LineUnavailableException("currently no line available due to resource restrictions");
        }
        throw new IllegalArgumentException(new StringBuffer().append("no mixer supporting this type of line: ").append(info).toString());
    }

    private static void doEncodingActionWorkaround(boolean bl, AudioFormat.Encoding encoding, GetTargetEncodingsFormatConversionProviderAction getTargetEncodingsFormatConversionProviderAction) {
        AudioFormat audioFormat = new AudioFormat(encoding, -1.0f, -1, -1, -1, -1.0f, bl);
        getTargetEncodingsFormatConversionProviderAction.setSourceDescription(audioFormat);
        AudioSystem.doFormatConversionProviderIteration(getTargetEncodingsFormatConversionProviderAction);
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        GetTargetEncodingsFormatConversionProviderAction getTargetEncodingsFormatConversionProviderAction = new GetTargetEncodingsFormatConversionProviderAction();
        AudioSystem.doEncodingActionWorkaround(false, encoding, getTargetEncodingsFormatConversionProviderAction);
        AudioSystem.doEncodingActionWorkaround(true, encoding, getTargetEncodingsFormatConversionProviderAction);
        return getTargetEncodingsFormatConversionProviderAction.getEncodings();
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        return AudioSystem.getTargetEncodings((Object)audioFormat);
    }

    private static AudioFormat.Encoding[] getTargetEncodings(Object object) {
        GetTargetEncodingsFormatConversionProviderAction getTargetEncodingsFormatConversionProviderAction = new GetTargetEncodingsFormatConversionProviderAction(object);
        AudioSystem.doFormatConversionProviderIteration(getTargetEncodingsFormatConversionProviderAction);
        return getTargetEncodingsFormatConversionProviderAction.getEncodings();
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        IsConversionSupportedFormatConversionProviderAction isConversionSupportedFormatConversionProviderAction = new IsConversionSupportedFormatConversionProviderAction(audioFormat, encoding);
        AudioSystem.doFormatConversionProviderIteration(isConversionSupportedFormatConversionProviderAction);
        return isConversionSupportedFormatConversionProviderAction.isSupported();
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        return AudioSystem.getAudioInputStreamImpl(encoding, audioInputStream);
    }

    private static AudioInputStream getAudioInputStreamImpl(Object object, AudioInputStream audioInputStream) {
        GetAudioInputStreamFormatConversionProviderAction getAudioInputStreamFormatConversionProviderAction = new GetAudioInputStreamFormatConversionProviderAction(audioInputStream, object);
        AudioSystem.doFormatConversionProviderIteration(getAudioInputStreamFormatConversionProviderAction);
        AudioInputStream audioInputStream2 = getAudioInputStreamFormatConversionProviderAction.getAudioInputStream();
        if (audioInputStream2 != null) {
            return audioInputStream2;
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        return null;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        IsConversionSupportedFormatConversionProviderAction isConversionSupportedFormatConversionProviderAction = new IsConversionSupportedFormatConversionProviderAction(audioFormat2, audioFormat);
        AudioSystem.doFormatConversionProviderIteration(isConversionSupportedFormatConversionProviderAction);
        return isConversionSupportedFormatConversionProviderAction.isSupported();
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return AudioSystem.getAudioInputStreamImpl(audioFormat, audioInputStream);
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioFileFormatImpl(inputStream);
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioFileFormatImpl(uRL);
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioFileFormatImpl(file);
    }

    private static AudioFileFormat getAudioFileFormatImpl(Object object) throws UnsupportedAudioFileException, IOException {
        GetAudioFileFormatAudioFileReaderAction getAudioFileFormatAudioFileReaderAction = new GetAudioFileFormatAudioFileReaderAction(object);
        AudioSystem.doAudioFileReaderIteration(getAudioFileFormatAudioFileReaderAction);
        AudioFileFormat audioFileFormat = getAudioFileFormatAudioFileReaderAction.getAudioFileFormat();
        if (audioFileFormat != null) {
            return audioFileFormat;
        }
        throw new UnsupportedAudioFileException("format not supported");
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioInputStreamImpl(inputStream);
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioInputStreamImpl(uRL);
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioInputStreamImpl(file);
    }

    private static AudioInputStream getAudioInputStreamImpl(Object object) throws UnsupportedAudioFileException, IOException {
        GetAudioInputStreamAudioFileReaderAction getAudioInputStreamAudioFileReaderAction = new GetAudioInputStreamAudioFileReaderAction(object);
        AudioSystem.doAudioFileReaderIteration(getAudioInputStreamAudioFileReaderAction);
        AudioInputStream audioInputStream = getAudioInputStreamAudioFileReaderAction.getAudioInputStream();
        if (audioInputStream != null) {
            return audioInputStream;
        }
        throw new UnsupportedAudioFileException("format not supported");
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        HashSet hashSet = new HashSet();
        Iterator iterator = TAudioConfig.getAudioFileWriters();
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.getAudioFileTypes()");
        }
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out(new StringBuffer().append("trying AudioFileWriter: ").append(audioFileWriter).toString());
            }
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes();
            if (TDebug.TraceAudioSystem) {
                TDebug.out("this AudioFileWriter supports the following Types:");
            }
            int n = 0;
            while (n < typeArray.length) {
                if (TDebug.TraceAudioSystem) {
                    TDebug.out(typeArray[n].toString());
                }
                hashSet.add(typeArray[n]);
                ++n;
            }
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out(new StringBuffer().append("< returning ").append(hashSet.size()).append(" types.").toString());
        }
        return (AudioFileFormat.Type[])hashSet.toArray(EMPTY_TYPE_ARRAY);
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        return AudioSystem.isFileTypeSupported(type, null);
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        HashSet hashSet = new HashSet();
        Iterator iterator = TAudioConfig.getAudioFileWriters();
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.getAudioFileTypes()");
        }
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out(new StringBuffer().append("trying AudioFileWriter: ").append(audioFileWriter).toString());
            }
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes(audioInputStream);
            if (TDebug.TraceAudioSystem) {
                TDebug.out("this AudioFileWriter supports the following Types:");
            }
            int n = 0;
            while (n < typeArray.length) {
                if (TDebug.TraceAudioSystem) {
                    TDebug.out(typeArray[n].toString());
                }
                hashSet.add(typeArray[n]);
                ++n;
            }
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out(new StringBuffer().append("< returning ").append(hashSet.size()).append(" types.").toString());
        }
        return (AudioFileFormat.Type[])hashSet.toArray(EMPTY_TYPE_ARRAY);
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        IsFileTypeSupportedAudioFileWriterAction isFileTypeSupportedAudioFileWriterAction;
        block2: {
            isFileTypeSupportedAudioFileWriterAction = new IsFileTypeSupportedAudioFileWriterAction(type, audioInputStream);
            try {
                AudioSystem.doAudioFileWriterIteration(isFileTypeSupportedAudioFileWriterAction);
            }
            catch (IOException iOException) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(iOException);
            }
        }
        return isFileTypeSupportedAudioFileWriterAction.isSupported();
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        return AudioSystem.writeImpl(audioInputStream, type, outputStream);
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        return AudioSystem.writeImpl(audioInputStream, type, file);
    }

    private static int writeImpl(AudioInputStream audioInputStream, AudioFileFormat.Type type, Object object) throws IOException {
        WriteAudioFileWriterAction writeAudioFileWriterAction = new WriteAudioFileWriterAction(audioInputStream, type, object);
        AudioSystem.doAudioFileWriterIteration(writeAudioFileWriterAction);
        int n = writeAudioFileWriterAction.getWritten();
        if (n == -1) {
            throw new IllegalArgumentException("format not  supported");
        }
        return n;
    }

    private static void doMixerProviderIteration(MixerProviderAction mixerProviderAction) {
        Iterator iterator = TAudioConfig.getMixerProviders();
        boolean bl = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doMixerProviderIteration()");
        }
        while (iterator.hasNext() && !bl) {
            MixerProvider mixerProvider = (MixerProvider)iterator.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out(new StringBuffer().append("handling MixerProvider: ").append(mixerProvider).toString());
            }
            bl = mixerProviderAction.handleMixerProvider(mixerProvider);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out(new StringBuffer().append("< completed=").append(bl).toString());
        }
    }

    private static void doMixerIteration(MixerAction mixerAction) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        boolean bl = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doMixerIteration()");
        }
        int n = 0;
        while (n < infoArray.length && !bl) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            if (TDebug.TraceAudioSystem) {
                TDebug.out(new StringBuffer().append("handling Mixer: ").append(mixer).toString());
            }
            bl = mixerAction.handleMixer(mixer);
            ++n;
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out(new StringBuffer().append("< completed=").append(bl).toString());
        }
    }

    private static void doFormatConversionProviderIteration(FormatConversionProviderAction formatConversionProviderAction) {
        Iterator iterator = TAudioConfig.getFormatConversionProviders();
        boolean bl = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doFormatConversionProviderIteration()");
        }
        while (iterator.hasNext() && !bl) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out(new StringBuffer().append("handling FormatConversionProvider: ").append(formatConversionProvider).toString());
            }
            bl = formatConversionProviderAction.handleFormatConversionProvider(formatConversionProvider);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out(new StringBuffer().append("< completed=").append(bl).toString());
        }
    }

    private static void doAudioFileReaderIteration(AudioFileReaderAction audioFileReaderAction) throws IOException {
        Iterator iterator = TAudioConfig.getAudioFileReaders();
        boolean bl = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doAudioFileReaderIteration()");
        }
        while (iterator.hasNext() && !bl) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out(new StringBuffer().append("handling AudioFileReader: ").append(audioFileReader).toString());
            }
            bl = audioFileReaderAction.handleAudioFileReader(audioFileReader);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out(new StringBuffer().append("< completed=").append(bl).toString());
        }
    }

    private static void doAudioFileWriterIteration(AudioFileWriterAction audioFileWriterAction) throws IOException {
        Iterator iterator = TAudioConfig.getAudioFileWriters();
        boolean bl = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doAudioFileWriterIteration()");
        }
        while (iterator.hasNext() && !bl) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out(new StringBuffer().append("handling AudioFileWriter: ").append(audioFileWriter).toString());
            }
            bl = audioFileWriterAction.handleAudioFileWriter(audioFileWriter);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out(new StringBuffer().append("< completed=").append(bl).toString());
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetMixerInfoMixerProviderAction
    implements MixerProviderAction {
        private Collection m_mixerInfos;

        public GetMixerInfoMixerProviderAction() {
            this.Block$();
        }

        @Override
        public boolean handleMixerProvider(MixerProvider mixerProvider) {
            Object[] objectArray = mixerProvider.getMixerInfo();
            if (objectArray != null) {
                if (objectArray.length > 0) {
                    if (TDebug.TraceAudioSystem) {
                        TDebug.out("AudioSystem.getMixerInfo(): MixerProvider returns array:");
                        int n = 0;
                        while (n < objectArray.length) {
                            TDebug.out(new StringBuffer().append("").append(objectArray[n]).toString());
                            ++n;
                        }
                    }
                } else if (TDebug.TraceAudioSystem) {
                    TDebug.out("AudioSystem.getMixerInfo(): MixerProvider returns empty array.");
                }
                this.m_mixerInfos.addAll(Arrays.asList(objectArray));
            } else if (TDebug.TraceAudioSystem) {
                TDebug.out("AudioSystem.getMixerInfo(): MixerProvider returns null.");
            }
            return false;
        }

        public Mixer.Info[] getMixerInfos() {
            return (Mixer.Info[])this.m_mixerInfos.toArray(EMPTY_MIXER_INFO_ARRAY);
        }

        private /* synthetic */ void Block$() {
            this.m_mixerInfos = new ArrayList();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetMixerMixerProviderAction
    implements MixerProviderAction {
        private Mixer.Info m_info;
        private Mixer m_mixer;

        public GetMixerMixerProviderAction(Mixer.Info info) {
            this.Block$();
            this.m_info = info;
        }

        @Override
        public boolean handleMixerProvider(MixerProvider mixerProvider) {
            block3: {
                try {
                    Mixer mixer = mixerProvider.getMixer(this.m_info);
                    if (this.m_mixer == null) {
                        this.m_mixer = mixer;
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!TDebug.TraceAudioSystem && !TDebug.TraceAllExceptions) break block3;
                    TDebug.out(illegalArgumentException);
                }
            }
            return false;
        }

        public Mixer getMixer() {
            return this.m_mixer;
        }

        private /* synthetic */ void Block$() {
            this.m_info = null;
            this.m_mixer = null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSourceLineInfoMixerAction
    implements MixerAction {
        private Line.Info m_info;
        private Set m_infos;

        public GetSourceLineInfoMixerAction(Line.Info info) {
            this.Block$();
            this.m_info = info;
            this.m_infos = new ArraySet();
        }

        @Override
        public boolean handleMixer(Mixer mixer) {
            Object[] objectArray = mixer.getSourceLineInfo(this.m_info);
            this.m_infos.addAll(Arrays.asList(objectArray));
            return false;
        }

        public Line.Info[] getInfos() {
            return (Line.Info[])this.m_infos.toArray(EMPTY_LINE_INFO_ARRAY);
        }

        private /* synthetic */ void Block$() {
            this.m_info = null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetTargetLineInfoMixerAction
    implements MixerAction {
        private Line.Info m_info;
        private Set m_infos;

        public GetTargetLineInfoMixerAction(Line.Info info) {
            this.Block$();
            this.m_info = info;
            this.m_infos = new ArraySet();
        }

        @Override
        public boolean handleMixer(Mixer mixer) {
            Object[] objectArray = mixer.getTargetLineInfo(this.m_info);
            this.m_infos.addAll(Arrays.asList(objectArray));
            return false;
        }

        public Line.Info[] getInfos() {
            return (Line.Info[])this.m_infos.toArray(EMPTY_LINE_INFO_ARRAY);
        }

        private /* synthetic */ void Block$() {
            this.m_info = null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsLineSupportedMixerAction
    implements MixerAction {
        private Line.Info m_info;
        private boolean m_bSupported;

        public IsLineSupportedMixerAction(Line.Info info) {
            this.Block$();
            this.m_info = info;
        }

        @Override
        public boolean handleMixer(Mixer mixer) {
            boolean bl = mixer.isLineSupported(this.m_info);
            this.m_bSupported |= bl;
            return bl;
        }

        public boolean isSupported() {
            return this.m_bSupported;
        }

        private /* synthetic */ void Block$() {
            this.m_info = null;
            this.m_bSupported = false;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetLineMixerAction
    implements MixerAction {
        private Line.Info m_info;
        private Line m_line;
        private boolean m_bLineTypeSupported;

        public GetLineMixerAction(Line.Info info) {
            this.Block$();
            this.m_info = info;
        }

        @Override
        public boolean handleMixer(Mixer mixer) {
            block5: {
                try {
                    Line line = mixer.getLine(this.m_info);
                    if (this.m_line == null) {
                        this.m_line = line;
                        return true;
                    }
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.m_bLineTypeSupported = true;
                    if (TDebug.TraceAudioSystem || TDebug.TraceAllExceptions) {
                        TDebug.out(lineUnavailableException);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!TDebug.TraceAudioSystem && !TDebug.TraceAllExceptions) break block5;
                    TDebug.out(illegalArgumentException);
                }
            }
            return false;
        }

        public Line getLine() {
            return this.m_line;
        }

        public boolean isLineTypeSupported() {
            return this.m_bLineTypeSupported;
        }

        private /* synthetic */ void Block$() {
            this.m_info = null;
            this.m_line = null;
            this.m_bLineTypeSupported = false;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetTargetEncodingsFormatConversionProviderAction
    implements FormatConversionProviderAction {
        private Object m_sourceDescription;
        private Collection m_targetEncodings;

        public GetTargetEncodingsFormatConversionProviderAction() {
            this(null);
        }

        public GetTargetEncodingsFormatConversionProviderAction(Object object) {
            this.m_sourceDescription = object;
            this.m_targetEncodings = new ArraySet();
        }

        @Override
        public boolean handleFormatConversionProvider(FormatConversionProvider formatConversionProvider) {
            Object[] objectArray = EMPTY_ENCODING_ARRAY;
            if (!(this.m_sourceDescription instanceof AudioFormat.Encoding) && this.m_sourceDescription instanceof AudioFormat) {
                objectArray = formatConversionProvider.getTargetEncodings((AudioFormat)this.m_sourceDescription);
            }
            this.m_targetEncodings.addAll(Arrays.asList(objectArray));
            return false;
        }

        public AudioFormat.Encoding[] getEncodings() {
            return (AudioFormat.Encoding[])this.m_targetEncodings.toArray(EMPTY_ENCODING_ARRAY);
        }

        public void setSourceDescription(Object object) {
            this.m_sourceDescription = object;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsConversionSupportedFormatConversionProviderAction
    implements FormatConversionProviderAction {
        private AudioFormat m_sourceFormat;
        private Object m_targetDescription;
        private boolean m_bSupported;

        public IsConversionSupportedFormatConversionProviderAction(AudioFormat audioFormat, Object object) {
            this.m_sourceFormat = audioFormat;
            this.m_targetDescription = object;
            this.m_bSupported = false;
        }

        @Override
        public boolean handleFormatConversionProvider(FormatConversionProvider formatConversionProvider) {
            boolean bl = false;
            if (this.m_targetDescription instanceof AudioFormat.Encoding) {
                bl = formatConversionProvider.isConversionSupported((AudioFormat.Encoding)this.m_targetDescription, this.m_sourceFormat);
            } else if (this.m_targetDescription instanceof AudioFormat) {
                bl = formatConversionProvider.isConversionSupported((AudioFormat)this.m_targetDescription, this.m_sourceFormat);
            }
            this.m_bSupported |= bl;
            return bl;
        }

        public boolean isSupported() {
            return this.m_bSupported;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetAudioInputStreamFormatConversionProviderAction
    implements FormatConversionProviderAction {
        private AudioInputStream m_sourceAudioInputStream;
        private Object m_targetDescription;
        private AudioInputStream m_targetAudioInputStream;

        public GetAudioInputStreamFormatConversionProviderAction(AudioInputStream audioInputStream, Object object) {
            this.m_sourceAudioInputStream = audioInputStream;
            this.m_targetDescription = object;
            this.m_targetAudioInputStream = null;
        }

        @Override
        public boolean handleFormatConversionProvider(FormatConversionProvider formatConversionProvider) {
            AudioInputStream audioInputStream = null;
            try {
                if (this.m_targetDescription instanceof AudioFormat.Encoding) {
                    audioInputStream = formatConversionProvider.getAudioInputStream((AudioFormat.Encoding)this.m_targetDescription, this.m_sourceAudioInputStream);
                } else if (this.m_targetDescription instanceof AudioFormat) {
                    audioInputStream = formatConversionProvider.getAudioInputStream((AudioFormat)this.m_targetDescription, this.m_sourceAudioInputStream);
                }
                this.m_targetAudioInputStream = audioInputStream;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (TDebug.TraceAudioSystem || TDebug.TraceAllExceptions) {
                    TDebug.out(illegalArgumentException);
                }
                return false;
            }
        }

        public AudioInputStream getAudioInputStream() {
            return this.m_targetAudioInputStream;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetAudioFileFormatAudioFileReaderAction
    implements AudioFileReaderAction {
        private Object m_source;
        private AudioFileFormat m_audioFileFormat;

        public GetAudioFileFormatAudioFileReaderAction(Object object) {
            this.Block$();
            this.m_source = object;
        }

        @Override
        public boolean handleAudioFileReader(AudioFileReader audioFileReader) throws IOException {
            block8: {
                AudioFileFormat audioFileFormat = null;
                try {
                    if (this.m_source instanceof InputStream) {
                        audioFileFormat = audioFileReader.getAudioFileFormat((InputStream)this.m_source);
                    } else if (this.m_source instanceof File) {
                        audioFileFormat = audioFileReader.getAudioFileFormat((File)this.m_source);
                    } else if (this.m_source instanceof URL) {
                        audioFileFormat = audioFileReader.getAudioFileFormat((URL)this.m_source);
                    }
                    if (this.m_audioFileFormat == null) {
                        this.m_audioFileFormat = audioFileFormat;
                        return true;
                    }
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    if (!TDebug.TraceAudioSystem && !TDebug.TraceAllExceptions) break block8;
                    TDebug.out(unsupportedAudioFileException);
                }
            }
            return false;
        }

        public AudioFileFormat getAudioFileFormat() {
            return this.m_audioFileFormat;
        }

        private /* synthetic */ void Block$() {
            this.m_source = null;
            this.m_audioFileFormat = null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetAudioInputStreamAudioFileReaderAction
    implements AudioFileReaderAction {
        private Object m_source;
        private AudioInputStream m_audioInputStream;

        public GetAudioInputStreamAudioFileReaderAction(Object object) {
            this.Block$();
            this.m_source = object;
        }

        @Override
        public boolean handleAudioFileReader(AudioFileReader audioFileReader) throws IOException {
            block8: {
                AudioInputStream audioInputStream = null;
                try {
                    if (this.m_source instanceof InputStream) {
                        audioInputStream = audioFileReader.getAudioInputStream((InputStream)this.m_source);
                    } else if (this.m_source instanceof File) {
                        audioInputStream = audioFileReader.getAudioInputStream((File)this.m_source);
                    } else if (this.m_source instanceof URL) {
                        audioInputStream = audioFileReader.getAudioInputStream((URL)this.m_source);
                    }
                    if (this.m_audioInputStream == null) {
                        this.m_audioInputStream = audioInputStream;
                        return true;
                    }
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    if (!TDebug.TraceAudioSystem && !TDebug.TraceAllExceptions) break block8;
                    TDebug.out(unsupportedAudioFileException);
                }
            }
            return false;
        }

        public AudioInputStream getAudioInputStream() {
            return this.m_audioInputStream;
        }

        private /* synthetic */ void Block$() {
            this.m_source = null;
            this.m_audioInputStream = null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsFileTypeSupportedAudioFileWriterAction
    implements AudioFileWriterAction {
        private AudioFileFormat.Type m_fileType;
        private AudioInputStream m_audioInputStream;
        private boolean m_bSupported;

        public IsFileTypeSupportedAudioFileWriterAction(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
            this.m_fileType = type;
            this.m_audioInputStream = audioInputStream;
            this.m_bSupported = false;
        }

        @Override
        public boolean handleAudioFileWriter(AudioFileWriter audioFileWriter) {
            boolean bl = false;
            bl = this.m_audioInputStream == null ? audioFileWriter.isFileTypeSupported(this.m_fileType) : audioFileWriter.isFileTypeSupported(this.m_fileType, this.m_audioInputStream);
            this.m_bSupported |= bl;
            return bl;
        }

        public boolean isSupported() {
            return this.m_bSupported;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WriteAudioFileWriterAction
    implements AudioFileWriterAction {
        private AudioInputStream m_audioInputStream;
        private AudioFileFormat.Type m_fileType;
        private Object m_destination;
        private int m_nWritten;

        public WriteAudioFileWriterAction(AudioInputStream audioInputStream, AudioFileFormat.Type type, Object object) {
            this.m_audioInputStream = audioInputStream;
            this.m_fileType = type;
            this.m_destination = object;
            this.m_nWritten = -1;
        }

        @Override
        public boolean handleAudioFileWriter(AudioFileWriter audioFileWriter) throws IOException {
            int n = -1;
            if (TDebug.TraceAudioSystem) {
                TDebug.out(new StringBuffer().append(">AudioSystem.handleAudioFileWriter(").append(audioFileWriter.getClass().getName()).append(") checking for type ").append(this.m_fileType).toString());
            }
            if (!audioFileWriter.isFileTypeSupported(this.m_fileType)) {
                if (TDebug.TraceAudioSystem) {
                    TDebug.out("< is not capable of handling this file type");
                }
                return false;
            }
            try {
                if (this.m_destination instanceof OutputStream) {
                    n = audioFileWriter.write(this.m_audioInputStream, this.m_fileType, (OutputStream)this.m_destination);
                } else if (this.m_destination instanceof File) {
                    n = audioFileWriter.write(this.m_audioInputStream, this.m_fileType, (File)this.m_destination);
                }
                this.m_nWritten = n;
                if (TDebug.TraceAudioSystem) {
                    TDebug.out(new StringBuffer().append("< wrote ").append(n).append(" bytes").toString());
                }
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (TDebug.TraceAudioSystem || TDebug.TraceAllExceptions) {
                    TDebug.out(illegalArgumentException);
                }
                if (TDebug.TraceAudioSystem) {
                    TDebug.out("< does not support this file type.");
                }
                return false;
            }
        }

        public int getWritten() {
            return this.m_nWritten;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MixerProviderAction {
        public boolean handleMixerProvider(MixerProvider var1);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MixerAction {
        public boolean handleMixer(Mixer var1);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface FormatConversionProviderAction {
        public boolean handleFormatConversionProvider(FormatConversionProvider var1);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AudioFileReaderAction {
        public boolean handleAudioFileReader(AudioFileReader var1) throws IOException;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AudioFileWriterAction {
        public boolean handleAudioFileWriter(AudioFileWriter var1) throws IOException;
    }
}

