/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.SourceLocator;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerException
extends Exception {
    private SourceLocator locator;
    private Throwable containedException;
    private boolean causeKnown;

    public TransformerException(String string) {
        super(string);
        this.Block$();
    }

    public TransformerException(Throwable throwable) {
        this.Block$();
        this.initCause(throwable);
    }

    public TransformerException(String string, Throwable throwable) {
        super(string);
        this.Block$();
        this.initCause(throwable);
    }

    public TransformerException(String string, SourceLocator sourceLocator) {
        super(string);
        this.Block$();
        this.setLocator(sourceLocator);
    }

    public TransformerException(String string, SourceLocator sourceLocator, Throwable throwable) {
        super(string);
        this.Block$();
        this.setLocator(sourceLocator);
        this.initCause(throwable);
    }

    @Override
    public Throwable getCause() {
        return this.containedException;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public String getLocationAsString() {
        if (this.locator == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.locator.getPublicId() != null) {
            stringBuffer.append("public='");
            stringBuffer.append(this.locator.getPublicId());
            stringBuffer.append("' ");
        }
        if (this.locator.getSystemId() != null) {
            stringBuffer.append("uri='");
            stringBuffer.append(this.locator.getSystemId());
            stringBuffer.append("' ");
        }
        if (this.locator.getLineNumber() != -1) {
            stringBuffer.append("line=");
            stringBuffer.append(this.locator.getLineNumber());
            stringBuffer.append(" ");
        }
        if (this.locator.getColumnNumber() != -1) {
            stringBuffer.append("column=");
            stringBuffer.append(this.locator.getColumnNumber());
        }
        return stringBuffer.toString();
    }

    public SourceLocator getLocator() {
        return this.locator;
    }

    public String getMessageAndLocation() {
        if (this.locator == null) {
            return this.getMessage();
        }
        return new StringBuffer().append(this.getMessage()).append(": ").append(this.getLocationAsString()).toString();
    }

    @Override
    public synchronized Throwable initCause(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException();
        }
        if (this.containedException != null) {
            throw new IllegalStateException();
        }
        this.containedException = throwable;
        this.causeKnown = true;
        return throwable;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(printStream));
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.containedException != null) {
            this.containedException.printStackTrace(printWriter);
        }
        super.printStackTrace(printWriter);
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator;
    }

    private /* synthetic */ void Block$() {
        this.locator = null;
        this.containedException = null;
    }
}

