/*
 * Decompiled with CFR 0.152.
 */
package kaffe.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import kaffe.applet.AppletTag;
import kaffe.applet.AudioPlayer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletViewer
extends Frame
implements ActionListener,
WindowListener {
    public static boolean debug;
    private static boolean showMenuBar;
    private static boolean showStatusBar;
    private Label statusBar;
    private Applet app;
    private AppletTag tag;
    private AppletContext context;
    private static Vector applets;
    private static final String TagMenu = "Tag";
    private static final String QuitMenu = "Quit";
    private static final String StopMenu = "Stop";
    private static final String StartMenu = "Start";

    public AppletViewer(URL uRL, AppletTag appletTag) throws IOException {
        super(appletTag.toString());
        this.Block$();
        this.setLayout(new BorderLayout());
        this.setMenus();
        this.statusBar.setFont(new Font("SansSerif", 1, 12));
        if (showStatusBar) {
            this.add("South", this.statusBar);
        }
        this.addWindowListener(this);
        this.tag = appletTag;
        DefaultAppletContext defaultAppletContext = new DefaultAppletContext(applets, this.statusBar);
        this.context = defaultAppletContext;
        DefaultAppletStub defaultAppletStub = new DefaultAppletStub(uRL, appletTag, this.context);
        this.app = AppletViewer.createApplet(this.tag, defaultAppletStub);
        if (this.app == null) {
            this.context.showStatus("Cannot start applet");
            return;
        }
        defaultAppletStub.add(this.app);
        this.add("Center", defaultAppletStub);
        this.addNotify();
        Dimension dimension = appletTag.getAppletSize();
        defaultAppletStub.appletResize(dimension.width, dimension.height);
        this.app.init();
        this.app.validate();
        this.app.start();
        this.pack();
        this.setVisible(true);
        if (debug) {
            System.out.println(new StringBuffer().append("my size ").append(this.getSize()).toString());
            System.out.println(new StringBuffer().append("stub size ").append(defaultAppletStub.getSize()).toString());
            System.out.println(new StringBuffer().append("label size ").append(this.statusBar.getSize()).toString());
        }
        this.context.showStatus("Applet started");
    }

    public static final Applet createApplet(AppletTag appletTag, AppletStub appletStub) {
        Applet applet = null;
        try {
            String string = appletTag.getCodeTag();
            if (string == null) {
                System.out.println("didn't find code tag");
                System.exit(-1);
            }
            AppletClassLoader appletClassLoader = new AppletClassLoader(appletTag.getCodebaseURL(), appletTag.getArchiveTag());
            Class clazz = appletClassLoader.loadClass(string);
            applet = (Applet)clazz.newInstance();
            String string2 = appletTag.getName();
            if (string2 != null) {
                applet.setName(string2);
            }
            applet.setStub(appletStub);
            AppletContext appletContext = appletStub.getAppletContext();
            if (appletContext instanceof DefaultAppletContext) {
                ((DefaultAppletContext)appletContext).addApplet(applet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return applet;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (QuitMenu.equals(string)) {
            if (this.app != null) {
                this.app.stop();
                this.app.destroy();
            }
            this.dispose();
            return;
        }
        if (StopMenu.equals(string)) {
            if (this.app != null) {
                this.app.stop();
            }
            this.context.showStatus("Applet stopped");
            return;
        }
        if (StartMenu.equals(string)) {
            if (this.app != null) {
                this.app.start();
            }
            this.context.showStatus("Applet started");
            return;
        }
        if (TagMenu.equals(string)) {
            System.out.println("printing tags: ");
            System.out.println(this.tag);
            System.out.println(this.tag.getParameters());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = -1;
        int n2 = -1;
        String string = null;
        showMenuBar = true;
        showStatusBar = true;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].startsWith("-d")) {
                debug = true;
            } else if (stringArray[n3].equals("-nomenu")) {
                showMenuBar = false;
            } else if (stringArray[n3].equals("-nostatus")) {
                showStatusBar = false;
            } else if (stringArray[n3].startsWith("-w")) {
                n = Integer.parseInt(stringArray[++n3]);
            } else if (stringArray[n3].startsWith("-h")) {
                n2 = Integer.parseInt(stringArray[++n3]);
            } else {
                string = stringArray[n3];
                break;
            }
            ++n3;
        }
        if (string == null) {
            System.out.println("Usage: AppletViewer [-debug] <url|file>");
            System.exit(0);
        }
        URLConnection uRLConnection = AppletViewer.openAppletURLConnection(string);
        URL uRL = uRLConnection.getURL();
        AppletTag[] appletTagArray = AppletTag.parseForApplets(uRLConnection.getInputStream());
        if (appletTagArray.length == 0) {
            System.err.println("Warning: no applets were found. Make sure the input contains an <applet> tag");
            System.exit(0);
        }
        int n4 = 0;
        while (n4 < appletTagArray.length) {
            AppletTag appletTag = appletTagArray[n4];
            appletTag.computeCodeBaseURL(uRL);
            if (debug) {
                System.out.println(new StringBuffer().append("AV: effective codebase= ").append(appletTag.getCodebaseURL()).toString());
            }
            if (n != -1) {
                appletTag.setAppletWidth(n);
            }
            if (n2 != -1) {
                appletTag.setAppletHeight(n2);
            }
            new AppletViewer(uRL, appletTag);
            ++n4;
        }
    }

    public static URLConnection openAppletURLConnection(String string) throws IOException {
        URL uRL;
        try {
            if (!string.startsWith("http:") && !string.startsWith("file:")) {
                throw new MalformedURLException();
            }
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = string.startsWith(File.separator) ? new File(string).getCanonicalPath() : new File(new StringBuffer().append(System.getProperty("user.dir")).append(File.separator).append(string).toString()).getCanonicalPath();
            uRL = new URL("file", "", string2);
        }
        if (debug) {
            System.out.println(new StringBuffer().append("AV: reading from URL: ").append(uRL).toString());
        }
        return uRL.openConnection();
    }

    void setMenus() {
        if (!showMenuBar) {
            return;
        }
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Applet");
        menu.add("Restart (dummy)");
        menu.add("Reload (dummy)");
        menu.add(StopMenu);
        menu.add("Save... (dummy)");
        menu.add(StartMenu);
        menu.add("Clone... (dummy)");
        menu.addSeparator();
        menu.add(TagMenu);
        menu.add("Info... (dummy)");
        menu.add("Edit (dummy)");
        menu.add("Character Encoding (dummy)");
        menu.addSeparator();
        menu.add("Print... (dummy)");
        menu.addSeparator();
        menu.add("Properties... (dummy)");
        menu.addSeparator();
        menu.add("Close (dummy)");
        menu.add(QuitMenu);
        menu.addActionListener(this);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.app != null) {
            this.app.stop();
            this.app.destroy();
        }
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    static {
        showMenuBar = true;
        showStatusBar = true;
        applets = new Vector();
    }

    private /* synthetic */ void Block$() {
        this.statusBar = new Label();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AppletClassLoader
    extends URLClassLoader {
        AppletClassLoader(URL uRL, String string) throws IOException {
            super(new URL[0]);
            if (string.equals("")) {
                this.addURL(uRL);
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                this.addURL(new URL(uRL, stringTokenizer.nextToken()));
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultAppletContext
    implements AppletContext {
        private Vector apps;
        private Label statusBar;

        public DefaultAppletContext(Label label) {
            this(new Vector(), label);
        }

        public DefaultAppletContext(Vector vector, Label label) {
            this.Block$();
            this.statusBar = label;
            this.apps = vector;
        }

        public void addApplet(Applet applet) {
            this.apps.addElement(applet);
        }

        @Override
        public Applet getApplet(String string) {
            int n = 0;
            while (n < this.apps.size()) {
                Applet applet = (Applet)this.apps.elementAt(n);
                if (applet.getName().equals(string)) {
                    return applet;
                }
                ++n;
            }
            return null;
        }

        @Override
        public Enumeration getApplets() {
            return this.apps.elements();
        }

        @Override
        public AudioClip getAudioClip(URL uRL) {
            return new AudioPlayer(uRL);
        }

        @Override
        public Image getImage(URL uRL) {
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }

        @Override
        public void showDocument(URL uRL) {
            this.showDocument(uRL, "_self");
        }

        @Override
        public void showDocument(URL uRL, String string) {
            System.err.println(new StringBuffer().append("Not implemented in AppletViewer:\nshowDocument(").append(uRL).append(", ").append(string).append(")").toString());
        }

        @Override
        public void showStatus(String string) {
            this.statusBar.setText(new StringBuffer().append(" ").append(string).append(" ").toString());
        }

        private /* synthetic */ void Block$() {
            this.apps = new Vector();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultAppletStub
    extends Panel
    implements AppletStub {
        private AppletContext context;
        private URL codebase;
        private URL documentBase;
        private Hashtable paramDict;
        private Dimension preferredSize;

        public DefaultAppletStub(URL uRL, AppletTag appletTag, AppletContext appletContext) {
            this.paramDict = appletTag.getParameters();
            this.context = appletContext;
            this.codebase = appletTag.getCodebaseURL();
            this.documentBase = uRL;
            this.setLayout(null);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        @Override
        public AppletContext getAppletContext() {
            return this.context;
        }

        @Override
        public URL getCodeBase() {
            return this.codebase;
        }

        @Override
        public URL getDocumentBase() {
            return this.documentBase;
        }

        @Override
        public String getParameter(String string) {
            if (this.paramDict == null) {
                return null;
            }
            String string2 = string.toLowerCase();
            String string3 = (String)this.paramDict.get(string2);
            if (debug) {
                System.out.println(new StringBuffer().append("AV: getP: ").append(string2).append(" ").append(string3).toString());
            }
            return string3;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void appletResize(int n, int n2) {
            this.preferredSize = new Dimension(n, n2);
            if (debug) {
                System.out.println(new StringBuffer().append("AV: resizing app to ").append(this.preferredSize).toString());
            }
            this.setSize(n, n2);
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Component component = this.getComponent(0);
            if (component != null) {
                Dimension dimension = this.preferredSize;
                if (dimension == null) {
                    if (debug) {
                        System.out.println("AV: no pref size, using current size");
                    }
                    dimension = this.getSize();
                }
                if (debug) {
                    System.out.println(new StringBuffer().append("AV: setting child to ").append(dimension).toString());
                    System.out.println(new StringBuffer().append("AV: my insets ").append(this.getInsets()).toString());
                }
                component.setBounds(0, 0, dimension.width, dimension.height);
            }
        }
    }
}

