/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import kaffe.net.www.protocol.BasicURLConnection;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileURLConnection
extends BasicURLConnection {
    private InputStream file;
    private FilePermission permission;

    public FileURLConnection(URL uRL) {
        super(uRL);
    }

    @Override
    public void connect() throws IOException {
        String string = this.url.getFile();
        this.setContentTypeFromName();
        if (File.separatorChar == '\\' && string.indexOf(47) >= 0) {
            string = string.replace('/', File.separatorChar);
        }
        File file = new File(string);
        this.permission = new FilePermission(file.getPath(), "read");
        if (file.isDirectory()) {
            int n = 0;
            int n2 = 0;
            String[] stringArray = file.list();
            byte[][] byArray = new byte[stringArray.length][];
            int n3 = 0;
            while (n3 < stringArray.length) {
                byArray[n3] = stringArray[n3].getBytes();
                n2 += byArray[n3].length + 1;
                ++n3;
            }
            byte[] byArray2 = new byte[n2];
            n3 = 0;
            while (n3 < stringArray.length) {
                System.arraycopy(byArray[n3], 0, byArray2, n, byArray[n3].length);
                byArray2[n += byArray[n3].length] = 10;
                ++n;
                ++n3;
            }
            this.setHeaderField("content-length", Integer.toString(n2));
            this.file = new ByteArrayInputStream(byArray2);
            return;
        }
        this.setHeaderField("content-length", Long.toString(file.length()));
        this.file = new BufferedInputStream(new FileInputStream(file));
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.permission;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.file;
    }
}

