/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaMidiOut {
    private AlsaSeq m_alsaSeq;
    private int m_nSourcePort;
    private int m_nQueue;
    private boolean m_bImmediately;
    private boolean m_bHandleMetaMessages;
    private AlsaSeqEvent m_event;

    public AlsaMidiOut(AlsaSeq alsaSeq, int n, int n2) {
        this(alsaSeq, n, n2, false);
    }

    public AlsaMidiOut(AlsaSeq alsaSeq, int n) {
        this(alsaSeq, n, -1, true);
    }

    private AlsaMidiOut(AlsaSeq alsaSeq, int n, int n2, boolean bl) {
        this.Block$();
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.<init>(AlsaSeq, int, int, boolean): begin");
        }
        this.m_alsaSeq = alsaSeq;
        this.m_nSourcePort = n;
        this.m_nQueue = n2;
        this.m_bImmediately = bl;
        this.m_bHandleMetaMessages = false;
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.<init>(AlsaSeq, int, int, boolean): end");
        }
    }

    private AlsaSeq getAlsaSeq() {
        return this.m_alsaSeq;
    }

    private int getSourcePort() {
        return this.m_nSourcePort;
    }

    private int getQueue() {
        return this.m_nQueue;
    }

    private boolean getImmediately() {
        return this.m_bImmediately;
    }

    public boolean getHandleMetaMessages() {
        return this.m_bHandleMetaMessages;
    }

    public void setHandleMetaMessages(boolean bl) {
        this.m_bHandleMetaMessages = bl;
    }

    public synchronized void enqueueMessage(MidiMessage midiMessage, long l) {
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.enqueueMessage(): begin");
        }
        if (midiMessage instanceof ShortMessage) {
            this.enqueueShortMessage((ShortMessage)midiMessage, l);
        } else if (midiMessage instanceof SysexMessage) {
            this.enqueueSysexMessage((SysexMessage)midiMessage, l);
        } else if (midiMessage instanceof MetaMessage && this.getHandleMetaMessages()) {
            this.enqueueMetaMessage((MetaMessage)midiMessage, l);
        }
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.enqueueMessage(): end");
        }
    }

    private void enqueueShortMessage(ShortMessage shortMessage, long l) {
        int n = shortMessage.getChannel();
        switch (shortMessage.getCommand()) {
            case 128: {
                this.sendNoteOffEvent(l, n, shortMessage.getData1(), shortMessage.getData2());
                return;
            }
            case 144: {
                this.sendNoteOnEvent(l, n, shortMessage.getData1(), shortMessage.getData2());
                return;
            }
            case 160: {
                this.sendKeyPressureEvent(l, n, shortMessage.getData1(), shortMessage.getData2());
                return;
            }
            case 176: {
                this.sendControlChangeEvent(l, n, shortMessage.getData1(), shortMessage.getData2());
                return;
            }
            case 192: {
                this.sendProgramChangeEvent(l, n, shortMessage.getData1());
                return;
            }
            case 208: {
                this.sendChannelPressureEvent(l, n, shortMessage.getData1());
                return;
            }
            case 224: {
                this.sendPitchBendEvent(l, n, AlsaMidiOut.get14bitValue(shortMessage.getData1(), shortMessage.getData2()));
                return;
            }
            case 240: {
                switch (shortMessage.getStatus()) {
                    case 241: {
                        this.sendMTCEvent(l, shortMessage.getData1());
                        return;
                    }
                    case 242: {
                        this.sendSongPositionPointerEvent(l, AlsaMidiOut.get14bitValue(shortMessage.getData1(), shortMessage.getData2()));
                        return;
                    }
                    case 243: {
                        this.sendSongSelectEvent(l, shortMessage.getData1());
                        return;
                    }
                    case 246: {
                        this.sendTuneRequestEvent(l);
                        return;
                    }
                    case 248: {
                        this.sendMidiClockEvent(l);
                        return;
                    }
                    case 250: {
                        this.sendStartEvent(l);
                        return;
                    }
                    case 251: {
                        this.sendContinueEvent(l);
                        return;
                    }
                    case 252: {
                        this.sendStopEvent(l);
                        return;
                    }
                    case 254: {
                        this.sendActiveSensingEvent(l);
                        return;
                    }
                    case 255: {
                        this.sendSystemResetEvent(l);
                        return;
                    }
                }
                TDebug.out(new StringBuffer().append("AlsaMidiOut.enqueueShortMessage(): UNKNOWN EVENT TYPE: ").append(shortMessage.getStatus()).toString());
                return;
            }
        }
        TDebug.out(new StringBuffer().append("AlsaMidiOut.enqueueShortMessage(): UNKNOWN EVENT TYPE: ").append(shortMessage.getStatus()).toString());
    }

    private static int get14bitValue(int n, int n2) {
        return n & 0x7F | (n2 & 0x7F) << 7;
    }

    private void sendNoteOffEvent(long l, int n, int n2, int n3) {
        this.sendNoteEvent(7, l, n, n2, n3);
    }

    private void sendNoteOnEvent(long l, int n, int n2, int n3) {
        this.sendNoteEvent(6, l, n, n2, n3);
    }

    private void sendNoteEvent(int n, long l, int n2, int n3, int n4) {
        this.setCommon(n, 0, l);
        this.m_event.setNote(n2, n3, n4, 0, 0);
        this.sendEvent();
    }

    private void sendKeyPressureEvent(long l, int n, int n2, int n3) {
        this.sendControlEvent(8, l, n, n2, n3);
    }

    private void sendControlChangeEvent(long l, int n, int n2, int n3) {
        this.sendControlEvent(10, l, n, n2, n3);
    }

    private void sendProgramChangeEvent(long l, int n, int n2) {
        this.sendControlEvent(11, l, n, 0, n2);
    }

    private void sendChannelPressureEvent(long l, int n, int n2) {
        this.sendControlEvent(12, l, n, 0, n2);
    }

    private void sendPitchBendEvent(long l, int n, int n2) {
        this.sendControlEvent(13, l, n, 0, n2);
    }

    private void sendControlEvent(int n, long l, int n2, int n3, int n4) {
        this.setCommon(n, 0, l);
        this.m_event.setControl(n2, n3, n4);
        this.sendEvent();
    }

    private void sendMTCEvent(long l, int n) {
        this.sendControlEvent(22, l, 0, 0, n);
    }

    private void sendSongPositionPointerEvent(long l, int n) {
        this.sendControlEvent(20, l, 0, 0, n);
    }

    private void sendSongSelectEvent(long l, int n) {
        this.sendControlEvent(21, l, 0, 0, n);
    }

    private void sendTuneRequestEvent(long l) {
        this.sendEvent(40, l);
    }

    private void sendMidiClockEvent(long l) {
        this.sendQueueControlEvent(36, l, 0, 0, 0L);
    }

    private void sendStartEvent(long l) {
        this.sendQueueControlEvent(30, l, 0, 0, 0L);
    }

    private void sendContinueEvent(long l) {
        this.sendQueueControlEvent(31, l, 0, 0, 0L);
    }

    private void sendStopEvent(long l) {
        this.sendQueueControlEvent(32, l, 0, 0, 0L);
    }

    private void sendActiveSensingEvent(long l) {
        this.sendEvent(42, l);
    }

    private void sendSystemResetEvent(long l) {
        this.sendEvent(41, l);
    }

    private void sendQueueControlEvent(int n, long l, int n2, int n3, long l2) {
        this.setCommon(n, 0, l);
        this.m_event.setQueueControl(n2, n3, l2);
        this.sendEvent();
    }

    private void sendEvent(int n, long l) {
        this.setCommon(n, 0, l);
        this.sendEvent();
    }

    private void enqueueSysexMessage(SysexMessage sysexMessage, long l) {
        byte[] byArray = sysexMessage.getMessage();
        int n = sysexMessage.getLength();
        if ((byArray[0] & 0xFF) == 240) {
            this.sendVarEvent(130, l, byArray, 0, n);
            return;
        }
        this.sendVarEvent(130, l, byArray, 1, n - 1);
    }

    private void enqueueMetaMessage(MetaMessage metaMessage, long l) {
        byte[] byArray = metaMessage.getData();
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)metaMessage.getType();
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.sendVarEvent(139, l, byArray2, 0, byArray2.length);
    }

    private void sendVarEvent(int n, long l, byte[] byArray, int n2, int n3) {
        this.setCommon(n, 4, l);
        this.m_event.setVar(byArray, 0, n3);
        this.sendEvent();
    }

    private void setCommon(int n, int n2, long l) {
        if (this.getImmediately()) {
            if (TDebug.TraceAlsaMidiOut) {
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): sending noteoff message (immediately)");
            }
            this.m_event.setCommon(n, 3 | n2, 0, 253, 0L, 0, this.getSourcePort(), 254, 253);
            return;
        }
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.enqueueShortMessage(): sending noteoff message (timed)");
        }
        this.m_event.setCommon(n, 0 | n2, 0, this.getQueue(), l, 0, this.getSourcePort(), 254, 253);
    }

    private void sendEvent() {
        this.getAlsaSeq().eventOutput(this.m_event);
        this.getAlsaSeq().drainOutput();
    }

    private /* synthetic */ void Block$() {
        this.m_event = new AlsaSeqEvent();
    }
}

