/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import java.util.Arrays;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.lowlevel.alsa.AlsaSeqPortSubscribe;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueInfo;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueStatus;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueTempo;
import org.tritonus.midi.device.alsa.AlsaMidiIn;
import org.tritonus.midi.device.alsa.AlsaMidiOut;
import org.tritonus.midi.device.alsa.AlsaReceiver;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.MidiUtils;
import org.tritonus.share.midi.TMidiDevice;
import org.tritonus.share.midi.TSequencer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaSequencer
extends TSequencer {
    private static final Sequencer.SyncMode[] MASTER_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static final Sequencer.SyncMode[] SLAVE_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC, Sequencer.SyncMode.MIDI_SYNC};
    private static final int CLOCK_EVENT_TAG = 255;
    private AlsaSeq m_playbackAlsaSeq;
    private AlsaSeq m_recordingAlsaSeq;
    private int m_nRecordingPort;
    private int m_nPlaybackPort;
    private int m_nQueue;
    private AlsaSeqQueueInfo m_queueInfo;
    private AlsaSeqQueueStatus m_queueStatus;
    private AlsaSeqQueueTempo m_queueTempo;
    private AlsaMidiIn m_playbackAlsaMidiIn;
    private AlsaMidiOut m_playbackAlsaMidiOut;
    private AlsaMidiIn m_recordingAlsaMidiIn;
    private Thread m_loaderThread;
    private Thread m_syncThread;
    private AlsaSeqEvent m_queueControlEvent;
    private AlsaSeqEvent m_clockEvent;
    private boolean m_bRecording;
    private Track m_track;
    private AlsaSeqEvent m_allNotesOffEvent;
    private Sequencer.SyncMode m_oldSlaveSyncMode;

    public AlsaSequencer(MidiDevice.Info info) {
        super(info, Arrays.asList(MASTER_SYNC_MODES), Arrays.asList(SLAVE_SYNC_MODES));
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.<init>(): begin");
        }
        this.setTempoInMPQ(500000.0f);
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.<init>(): end");
        }
    }

    private int getPlaybackClient() {
        int n = this.getPlaybackAlsaSeq().getClientId();
        return n;
    }

    private int getPlaybackPort() {
        return this.m_nPlaybackPort;
    }

    private int getRecordingClient() {
        int n = this.getRecordingAlsaSeq().getClientId();
        return n;
    }

    private int getRecordingPort() {
        return this.m_nRecordingPort;
    }

    private int getQueue() {
        return this.m_nQueue;
    }

    private AlsaSeqQueueStatus getQueueStatus() {
        return this.m_queueStatus;
    }

    private AlsaSeqQueueTempo getQueueTempo() {
        return this.m_queueTempo;
    }

    private AlsaSeq getPlaybackAlsaSeq() {
        return this.m_playbackAlsaSeq;
    }

    private AlsaSeq getRecordingAlsaSeq() {
        return this.m_recordingAlsaSeq;
    }

    private void updateQueueStatus() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.updateQueueStatus(): begin");
        }
        this.getPlaybackAlsaSeq().getQueueStatus(this.getQueue(), this.getQueueStatus());
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.updateQueueStatus(): end");
        }
    }

    @Override
    protected void openImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.openImpl(): begin");
        }
        this.m_recordingAlsaSeq = new AlsaSeq("Tritonus ALSA Sequencer (recording/synchronization)");
        this.m_nRecordingPort = this.getRecordingAlsaSeq().createPort("recording/synchronization port", 99, 0, 0x100000, 0, 0, 0);
        this.m_playbackAlsaSeq = new AlsaSeq("Tritonus ALSA Sequencer (playback)");
        this.m_nPlaybackPort = this.getPlaybackAlsaSeq().createPort("playback port", 99, 0, 0x100000, 0, 0, 0);
        this.m_nQueue = this.getPlaybackAlsaSeq().allocQueue();
        this.m_queueInfo = new AlsaSeqQueueInfo();
        this.m_queueStatus = new AlsaSeqQueueStatus();
        this.m_queueTempo = new AlsaSeqQueueTempo();
        this.getPlaybackAlsaSeq().getQueueInfo(this.getQueue(), this.m_queueInfo);
        this.m_queueInfo.setLocked(false);
        this.getPlaybackAlsaSeq().setQueueInfo(this.getQueue(), this.m_queueInfo);
        this.m_playbackAlsaMidiOut = new AlsaMidiOut(this.getPlaybackAlsaSeq(), this.getPlaybackPort(), this.getQueue());
        this.m_playbackAlsaMidiOut.setHandleMetaMessages(true);
        this.getRecordingAlsaSeq().setQueueUsage(this.getQueue(), true);
        PlaybackAlsaMidiInListener playbackAlsaMidiInListener = new PlaybackAlsaMidiInListener();
        this.m_playbackAlsaMidiIn = new AlsaMidiIn(this.getPlaybackAlsaSeq(), this.getPlaybackPort(), this.getPlaybackClient(), this.getPlaybackPort(), playbackAlsaMidiInListener);
        this.m_playbackAlsaMidiIn.start();
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.openImpl(): end");
        }
        this.m_queueControlEvent = new AlsaSeqEvent();
        this.m_clockEvent = new AlsaSeqEvent();
        this.m_clockEvent.setCommon(36, 0, 255, this.getQueue(), 0L, 0, this.getRecordingPort(), 254, 253);
        this.m_allNotesOffEvent = new AlsaSeqEvent();
        this.m_oldSlaveSyncMode = this.getSlaveSyncMode();
        this.m_loaderThread = new LoaderThread();
        this.m_loaderThread.start();
    }

    @Override
    protected void closeImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.closeImpl(): begin");
        }
        this.m_playbackAlsaMidiIn.interrupt();
        this.m_playbackAlsaMidiIn = null;
        this.getQueueStatus().free();
        this.m_queueStatus = null;
        this.getQueueTempo().free();
        this.m_queueTempo = null;
        this.getRecordingAlsaSeq().close();
        this.m_recordingAlsaSeq = null;
        this.getPlaybackAlsaSeq().close();
        this.m_playbackAlsaSeq = null;
        this.m_queueControlEvent.free();
        this.m_queueControlEvent = null;
        this.m_clockEvent.free();
        this.m_clockEvent = null;
        this.m_allNotesOffEvent.free();
        this.m_allNotesOffEvent = null;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.closeImpl(): end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.startImpl(): begin");
        }
        if (this.getTickPosition() == 0L) {
            this.startQueue();
        } else {
            this.continueQueue();
        }
        Thread thread = this.m_loaderThread;
        synchronized (thread) {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.startImpl(): notifying loader thread");
            }
            this.m_loaderThread.notify();
        }
        if (!this.getSlaveSyncMode().equals(Sequencer.SyncMode.NO_SYNC)) {
            this.sendStartEvent();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.startImpl(): end");
        }
    }

    @Override
    protected void stopImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.stopImpl(): begin");
        }
        this.stopQueue();
        this.sendAllNotesOff();
        this.stopRecording();
        if (!this.getSlaveSyncMode().equals(Sequencer.SyncMode.NO_SYNC)) {
            this.sendStopEvent();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.stopImpl(): end");
        }
    }

    @Override
    public boolean isRunning() {
        boolean bl;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.isRunning(): begin");
        }
        this.updateQueueStatus();
        int n = this.getQueueStatus().getStatus();
        if (TDebug.TraceSequencer) {
            TDebug.out(new StringBuffer().append("AlsaSequencer.isRunning(): queue status: ").append(n).toString());
        }
        boolean bl2 = bl = n != 0;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.isRunning(): end");
        }
        return bl;
    }

    @Override
    public void startRecording() {
        this.m_bRecording = true;
        this.start();
    }

    @Override
    public void stopRecording() {
        this.m_bRecording = false;
    }

    @Override
    public boolean isRecording() {
        return this.m_bRecording;
    }

    @Override
    public void recordEnable(Track track, int n) {
        this.m_track = track;
    }

    @Override
    public void recordDisable(Track track) {
    }

    @Override
    protected void setTempoImpl(float f) {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTempoImpl(): begin");
        }
        if (this.isOpen()) {
            if (TDebug.TraceSequencer) {
                TDebug.out(new StringBuffer().append("AlsaSequencer.setTempoImpl(): setting tempo to ").append((int)f).toString());
            }
            this.getQueueTempo().setTempo((int)f);
            this.getQueueTempo().setPpq(this.getResolution());
            this.getPlaybackAlsaSeq().setQueueTempo(this.getQueue(), this.getQueueTempo());
        } else if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTempoImpl(): ignoring because sequencer is not opened");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTempoImpl(): end");
        }
    }

    @Override
    public long getTickPosition() {
        long l;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.getTickPosition(): begin");
        }
        if (this.isOpen()) {
            this.updateQueueStatus();
            l = this.getQueueStatus().getTickTime();
        } else {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.getTickPosition(): sequencer not open, returning 0");
            }
            l = 0L;
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.getTickPosition(): end");
        }
        return l;
    }

    @Override
    public void setTickPosition(long l) {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTickPosition(): begin");
        }
        if (this.isOpen()) {
            int n = this.getRecordingPort();
            int n2 = this.getQueue();
            long l2 = l;
            this.sendQueueControlEvent(33, 3, 0, 253, 0L, n, 0, 0, n2, 0, l2);
        } else if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTickPosition(): ignored because sequencer is not open");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTickPosition(): end");
        }
    }

    @Override
    public long getMicrosecondPosition() {
        long l;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.getMicrosecondPosition(): begin");
        }
        if (this.isOpen()) {
            this.updateQueueStatus();
            long l2 = this.getQueueStatus().getRealTime();
            l = l2 / 1000L;
        } else {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.getMicrosecondPosition(): sequencer not open, returning 0");
            }
            l = 0L;
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.getMicrosecondPosition(): end");
        }
        return l;
    }

    @Override
    public void setMicrosecondPosition(long l) {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setMicrosecondPosition(): begin");
        }
        if (this.isOpen()) {
            long l2 = l * 1000L;
            int n = this.getRecordingPort();
            int n2 = this.getQueue();
            long l3 = l2;
            this.sendQueueControlEvent(34, 3, 0, 253, 0L, n, 0, 0, n2, 0, l3);
        } else if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setMicrosecondPosition(): ignoring because sequencer is not open");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setMicrosecondPosition(): end");
        }
    }

    @Override
    protected void setMasterSyncModeImpl(Sequencer.SyncMode syncMode) {
    }

    @Override
    protected void setSlaveSyncModeImpl(Sequencer.SyncMode syncMode) {
        if (this.isRunning()) {
            if (this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.NO_SYNC) && (syncMode.equals(Sequencer.SyncMode.MIDI_SYNC) || syncMode.equals(Sequencer.SyncMode.MIDI_TIME_CODE))) {
                this.sendStartEvent();
                return;
            }
            if ((this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.MIDI_SYNC) || this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.MIDI_TIME_CODE)) && syncMode.equals(Sequencer.SyncMode.NO_SYNC)) {
                this.sendStopEvent();
            }
        }
    }

    @Override
    protected void setTrackEnabledImpl(int n, boolean bl) {
    }

    private synchronized void enqueueMessage(MidiMessage midiMessage, long l) {
        this.m_playbackAlsaMidiOut.enqueueMessage(midiMessage, l);
    }

    public void sendMessageTick(MidiMessage midiMessage, long l) {
        this.enqueueMessage(midiMessage, l);
    }

    private void startQueue() {
        this.controlQueue(30);
    }

    private void continueQueue() {
        this.controlQueue(31);
    }

    private void stopQueue() {
        this.controlQueue(32);
    }

    private void controlQueue(int n) {
        int n2 = this.getPlaybackPort();
        int n3 = this.getQueue();
        this.sendQueueControlEvent(n, 3, 0, 253, 0L, n2, 0, 0, n3, 0, 0L);
    }

    private void sendStartEvent() {
        this.sendRealtimeEvent(30);
    }

    private void sendStopEvent() {
        this.sendRealtimeEvent(32);
    }

    private void sendRealtimeEvent(int n) {
        this.sendQueueControlEvent(n, 3, 0, 253, 0L, this.getPlaybackPort(), 254, 253, 0, 0, 0L);
    }

    private void sendQueueControlEvent(int n, int n2, int n3, int n4, long l, int n5, int n6, int n7, int n8, int n9, long l2) {
        this.m_queueControlEvent.setCommon(n, n2, n3, n4, l, 0, n5, n6, n7);
        this.m_queueControlEvent.setQueueControl(n8, n9, l2);
        this.getPlaybackAlsaSeq().eventOutputDirect(this.m_queueControlEvent);
    }

    private void sendAllNotesOffEvent(int n) {
        int n2 = this.getPlaybackPort();
        this.m_allNotesOffEvent.setCommon(10, 3, 0, 253, 0L, 0, n2, 254, 253);
        this.m_allNotesOffEvent.setControl(n, 120, 0);
        this.getPlaybackAlsaSeq().eventOutputDirect(this.m_allNotesOffEvent);
    }

    private void sendAllNotesOff() {
        int n = 0;
        while (n < 16) {
            this.sendAllNotesOffEvent(n);
            ++n;
        }
    }

    private void receiveTimestamped(MidiMessage midiMessage, long l) {
        if (this.isRecording()) {
            Track track = this.m_track;
            MidiEvent midiEvent = new MidiEvent(midiMessage, l);
            track.add(midiEvent);
        }
    }

    @Override
    protected void receive(MidiMessage midiMessage, long l) {
        l = this.getTickPosition();
        this.receiveTimestamped(midiMessage, l);
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        return new AlsaSequencerReceiver();
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return new AlsaSequencerTransmitter();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlaybackAlsaMidiInListener
    implements AlsaMidiIn.AlsaMidiInListener {
        @Override
        public void dequeueEvent(MidiMessage midiMessage, long l) {
            MetaMessage metaMessage;
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.PlaybackAlsaMidiInListener.dequeueEvent(): begin");
            }
            if (TDebug.TraceSequencer) {
                TDebug.out(new StringBuffer().append("AlsaSequencer.PlaybackAlsaMidiInListener.dequeueEvent(): message: ").append(midiMessage).toString());
            }
            if (midiMessage instanceof MetaMessage && (metaMessage = (MetaMessage)midiMessage).getType() == 81) {
                byte[] byArray = metaMessage.getData();
                int n = MidiUtils.getUnsignedInteger(byArray[0]) * 65536 + MidiUtils.getUnsignedInteger(byArray[1]) * 256 + MidiUtils.getUnsignedInteger(byArray[2]);
                AlsaSequencer.this.setTempoInMPQ(n);
            }
            AlsaSequencer.this.sendImpl(midiMessage, -1L);
            AlsaSequencer.this.notifyListeners(midiMessage);
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.PlaybackAlsaMidiInListener.dequeueEvent(): end");
            }
        }

        private PlaybackAlsaMidiInListener() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecordingAlsaMidiInListener
    implements AlsaMidiIn.AlsaMidiInListener {
        @Override
        public void dequeueEvent(MidiMessage midiMessage, long l) {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.RecordingAlsaMidiInListener.dequeueEvent(): begin");
            }
            if (TDebug.TraceSequencer) {
                TDebug.out(new StringBuffer().append("AlsaSequencer.RecordingAlsaMidiInListener.dequeueEvent(): message: ").append(midiMessage).toString());
            }
            AlsaSequencer.this.receiveTimestamped(midiMessage, l);
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.RecordingAlsaMidiInListener.dequeueEvent(): end");
            }
        }

        private RecordingAlsaMidiInListener() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlsaSequencerReceiver
    extends TMidiDevice.TReceiver
    implements AlsaReceiver {
        public AlsaSequencerReceiver() {
            super(AlsaSequencer.this);
        }

        @Override
        public boolean subscribeTo(int n, int n2) {
            try {
                AlsaSeqPortSubscribe alsaSeqPortSubscribe = new AlsaSeqPortSubscribe();
                alsaSeqPortSubscribe.setSender(n, n2);
                alsaSeqPortSubscribe.setDest(AlsaSequencer.this.getRecordingClient(), AlsaSequencer.this.getRecordingPort());
                alsaSeqPortSubscribe.setQueue(AlsaSequencer.this.getQueue());
                alsaSeqPortSubscribe.setExclusive(false);
                alsaSeqPortSubscribe.setTimeUpdate(true);
                alsaSeqPortSubscribe.setTimeReal(false);
                AlsaSequencer.this.getRecordingAlsaSeq().subscribePort(alsaSeqPortSubscribe);
                alsaSeqPortSubscribe.free();
                return true;
            }
            catch (RuntimeException runtimeException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(runtimeException);
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlsaSequencerTransmitter
    extends TMidiDevice.TTransmitter {
        private boolean m_bReceiverSubscribed = false;

        public AlsaSequencerTransmitter() {
            super(AlsaSequencer.this);
        }

        @Override
        public void setReceiver(Receiver receiver) {
            super.setReceiver(receiver);
            if (receiver instanceof AlsaReceiver) {
                this.m_bReceiverSubscribed = ((AlsaReceiver)receiver).subscribeTo(AlsaSequencer.this.getPlaybackClient(), AlsaSequencer.this.getPlaybackPort());
                this.m_bReceiverSubscribed = ((AlsaReceiver)receiver).subscribeTo(AlsaSequencer.this.getRecordingClient(), AlsaSequencer.this.getRecordingPort());
            }
        }

        @Override
        public void send(MidiMessage midiMessage, long l) {
            if (!this.m_bReceiverSubscribed) {
                super.send(midiMessage, l);
            }
        }

        @Override
        public void close() {
            super.close();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoaderThread
    extends Thread {
        private long m_lLoadingPosition;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.run(): begin");
            }
            while (AlsaSequencer.this.isOpen()) {
                do {
                    LoaderThread loaderThread = this;
                    synchronized (loaderThread) {
                        block9: {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                if (!TDebug.TraceAllExceptions) break block9;
                                TDebug.out(interruptedException);
                            }
                        }
                    }
                } while (!AlsaSequencer.this.isRunning());
                this.loadSequenceToNative();
            }
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.run(): end");
            }
        }

        private void loadSequenceToNative() {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.loadSequenceToNative(): begin");
            }
            Sequence sequence = AlsaSequencer.this.getSequence();
            Track[] trackArray = sequence.getTracks();
            int[] nArray = new int[trackArray.length];
            int n = 0;
            while (n < trackArray.length) {
                nArray[n] = 0;
                ++n;
            }
            this.m_lLoadingPosition = 0L;
            while (AlsaSequencer.this.isRunning()) {
                long l;
                Object object;
                n = 0;
                long l2 = Long.MAX_VALUE;
                int n2 = -1;
                int n3 = 0;
                while (n3 < trackArray.length) {
                    if (nArray[n3] < trackArray[n3].size()) {
                        n = 1;
                        object = trackArray[n3].get(nArray[n3]);
                        l = ((MidiEvent)object).getTick();
                        if (l < l2) {
                            l2 = l;
                            n2 = n3;
                        }
                    }
                    ++n3;
                }
                if (n == 0) {
                    MetaMessage metaMessage;
                    block13: {
                        metaMessage = new MetaMessage();
                        try {
                            metaMessage.setMessage(47, new byte[0], 0);
                        }
                        catch (InvalidMidiDataException invalidMidiDataException) {
                            if (!TDebug.TraceAllExceptions) break block13;
                            TDebug.out(invalidMidiDataException);
                        }
                    }
                    if (TDebug.TraceSequencer) {
                        TDebug.out(new StringBuffer().append("AlsaSequencer.loadSequenceToNative(): sending End of Track message with tick ").append(this.m_lLoadingPosition + 1L).toString());
                    }
                    AlsaSequencer.this.enqueueMessage(metaMessage, this.m_lLoadingPosition + 1L);
                    break;
                }
                MidiEvent midiEvent = trackArray[n2].get(nArray[n2]);
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
                object = midiEvent.getMessage();
                l = midiEvent.getTick();
                this.m_lLoadingPosition = Math.max(this.m_lLoadingPosition, l);
                if (object instanceof MetaMessage && ((MetaMessage)object).getType() == 47) {
                    if (!TDebug.TraceSequencer) continue;
                    TDebug.out(new StringBuffer().append("AlsaSequencer.loadSequenceToNative(): ignoring End of Track message with tick ").append(l).toString());
                    continue;
                }
                if (TDebug.TraceSequencer) {
                    TDebug.out(new StringBuffer().append("AlsaSequencer.loadSequenceToNative(): enqueueing event with tick ").append(l).toString());
                }
                AlsaSequencer.this.enqueueMessage((MidiMessage)object, l);
            }
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.loadSequenceToNative(): end");
            }
        }

        private LoaderThread() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MasterSynchronizer
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.MasterSynchronizer.run(): begin");
            }
            while (AlsaSequencer.this.isOpen()) {
                do {
                    MasterSynchronizer masterSynchronizer = this;
                    synchronized (masterSynchronizer) {
                        block12: {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                if (!TDebug.TraceAllExceptions) break block12;
                                TDebug.out(interruptedException);
                            }
                        }
                    }
                } while (!AlsaSequencer.this.isRunning());
                double d = AlsaSequencer.this.getTickPosition();
                double d2 = AlsaSequencer.this.getSequence().getTickLength();
                double d3 = (double)AlsaSequencer.this.getSequence().getResolution() / 24.0;
                if (TDebug.TraceSequencer) {
                    TDebug.out(new StringBuffer().append("MasterSynchronizer.run(): tick step: ").append(d3).toString());
                }
                double d4 = d;
                while (d4 < d2 && AlsaSequencer.this.isRunning()) {
                    long l = Math.round(d4);
                    if (TDebug.TraceSequencer) {
                        TDebug.out(new StringBuffer().append("MasterSynchronizer.run(): sending clock event with tick ").append(l).toString());
                    }
                    AlsaSequencer.this.m_clockEvent.setTimestamp(l);
                    AlsaSequencer.this.getRecordingAlsaSeq().eventOutput(AlsaSequencer.this.m_clockEvent);
                    AlsaSequencer.this.getRecordingAlsaSeq().drainOutput();
                    d4 += d3;
                }
            }
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.MasterSynchronizer.run(): end");
            }
        }

        private MasterSynchronizer() {
        }
    }
}

