/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.VoiceStatus;
import org.tritonus.midi.device.alsa.AlsaMidiChannel;
import org.tritonus.midi.device.alsa.AlsaMidiDevice;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiDevice;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaSynthesizer
extends AlsaMidiDevice
implements Synthesizer {
    private static final MidiChannel[] EMPTY_MIDICHANNEL_ARRAY = new MidiChannel[0];
    private static final VoiceStatus[] EMPTY_VOICESTATUS_ARRAY = new VoiceStatus[0];
    private List m_channels;
    private int m_nVoices;

    public AlsaSynthesizer(int n, int n2, int n3) {
        super(new TMidiDevice.Info(new StringBuffer().append("ALSA Synthesizer (").append(n).append(":").append(n2).append(")").toString(), GlobalInfo.getVendor(), "Synthesizer based on the ALSA sequencer", GlobalInfo.getVersion()), n, n2, false, true);
        this.m_nVoices = n3;
        this.m_channels = new ArrayList();
    }

    @Override
    protected void openImpl() {
        Receiver receiver;
        block3: {
            super.openImpl();
            this.m_channels.clear();
            receiver = null;
            try {
                receiver = this.getReceiver();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                if (!TDebug.TraceAllExceptions) break block3;
                TDebug.out(midiUnavailableException);
            }
        }
        int n = 0;
        while (n < 16) {
            AlsaMidiChannel alsaMidiChannel = new AlsaMidiChannel(receiver, n);
            this.m_channels.add(alsaMidiChannel);
            ++n;
        }
    }

    @Override
    protected void closeImpl() {
        super.closeImpl();
    }

    @Override
    public int getMaxPolyphony() {
        return this.m_nVoices;
    }

    @Override
    public long getLatency() {
        return -1L;
    }

    @Override
    public MidiChannel[] getChannels() {
        return (MidiChannel[])this.m_channels.toArray(EMPTY_MIDICHANNEL_ARRAY);
    }

    @Override
    public VoiceStatus[] getVoiceStatus() {
        return EMPTY_VOICESTATUS_ARRAY;
    }

    @Override
    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    @Override
    public boolean loadInstrument(Instrument instrument) {
        return false;
    }

    @Override
    public void unloadInstrument(Instrument instrument) {
    }

    @Override
    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        return false;
    }

    @Override
    public Soundbank getDefaultSoundbank() {
        return null;
    }

    @Override
    public Instrument[] getAvailableInstruments() {
        return null;
    }

    @Override
    public Instrument[] getLoadedInstruments() {
        return null;
    }

    @Override
    public boolean loadAllInstruments(Soundbank soundbank) {
        return false;
    }

    @Override
    public void unloadAllInstruments(Soundbank soundbank) {
    }

    @Override
    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        return false;
    }

    @Override
    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
    }
}

