/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.FloatSampleBuffer;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleRateConversionProvider
extends TSimpleFormatConversionProvider {
    public static AudioFormat.Encoding PCM_SIGNED = AudioFormat.Encoding.PCM_SIGNED;
    public static AudioFormat.Encoding PCM_UNSIGNED = AudioFormat.Encoding.PCM_UNSIGNED;
    private static final boolean DEBUG_STREAM = false;
    private static final boolean DEBUG_STREAM_PROBLEMS = false;
    private static final int ALL = -1;
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(PCM_SIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(PCM_UNSIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(PCM_UNSIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(PCM_SIGNED, ALL, 16, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(PCM_SIGNED, ALL, 16, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(PCM_SIGNED, ALL, 24, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(PCM_SIGNED, ALL, 24, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(PCM_SIGNED, ALL, 32, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(PCM_SIGNED, ALL, 32, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true)};
    private static final float[] commonSampleRates = new float[]{8000.0f, 11025.0f, 12000.0f, 16000.0f, 22050.0f, 24000.0f, 32000.0f, 44100.0f, 48000.0f, 64000.0f, 88200.0f, 96000.0f};

    public SampleRateConversionProvider() {
        super(Arrays.asList(OUTPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (AudioFormats.matches(audioFormat2, audioFormat)) {
            return audioInputStream;
        }
        if ((audioFormat = this.replaceNotSpecified(audioFormat2, audioFormat)).getSampleRate() != -1.0f && audioFormat2.getSampleRate() != -1.0f && audioFormat.getChannels() != -1 && audioFormat2.getChannels() != -1 && audioFormat.getSampleSizeInBits() != -1 && audioFormat2.getSampleSizeInBits() != -1 && this.isConversionSupported(audioFormat2, audioFormat)) {
            return new SampleRateConverterStream(audioInputStream, audioFormat);
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    private static AudioFormat replaceSampleRate(AudioFormat audioFormat, float f) {
        if (audioFormat.getSampleRate() == f) {
            return audioFormat;
        }
        return new AudioFormat(audioFormat.getEncoding(), f, audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), f, audioFormat.isBigEndian());
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">SampleRateConversionProvider.getTargetFormats(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("checking out possible target formats");
            TDebug.out(new StringBuffer().append("from: ").append(audioFormat).toString());
            TDebug.out(new StringBuffer().append("to  : ").append(encoding).toString());
        }
        float f = audioFormat.getSampleRate();
        if (this.isConversionSupported(encoding, audioFormat = SampleRateConversionProvider.replaceSampleRate(audioFormat, -1.0f))) {
            ArraySet arraySet = new ArraySet();
            Iterator iterator = this.getCollectionTargetFormats().iterator();
            while (iterator.hasNext()) {
                AudioFormat audioFormat2 = (AudioFormat)iterator.next();
                if (!this.isConversionSupported(audioFormat2 = this.replaceNotSpecified(audioFormat, audioFormat2), audioFormat)) continue;
                arraySet.add(audioFormat2);
            }
            if (arraySet.size() > 0 && f != -1.0f) {
                int n = arraySet.size();
                int n2 = 0;
                while (n2 < n) {
                    AudioFormat audioFormat3 = (AudioFormat)arraySet.get(n2);
                    int n3 = 0;
                    while (n3 < commonSampleRates.length) {
                        if (!TSimpleFormatConversionProvider.doMatch(f, commonSampleRates[n3])) {
                            arraySet.add(SampleRateConversionProvider.replaceSampleRate(audioFormat3, commonSampleRates[n3]));
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out(new StringBuffer().append("<found ").append(arraySet.size()).append(" matching formats.").toString());
            }
            return (AudioFormat[])arraySet.toArray(TFormatConversionProvider.EMPTY_FORMAT_ARRAY);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<returning empty array.");
        }
        return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
    }

    @Override
    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        boolean bl;
        boolean bl2 = bl = (audioFormat.getSampleRate() == -1.0f || audioFormat.getSampleRate() == -1.0f || !TSimpleFormatConversionProvider.doMatch(audioFormat.getSampleRate(), audioFormat2.getSampleRate()) && TSimpleFormatConversionProvider.doMatch(audioFormat.getChannels(), audioFormat2.getChannels())) && AudioUtils.containsFormat(audioFormat2, this.getCollectionSourceFormats().iterator()) && AudioUtils.containsFormat(audioFormat, this.getCollectionTargetFormats().iterator());
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">SampleRateConverter: isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("checking if conversion possible");
            TDebug.out(new StringBuffer().append("from: ").append(audioFormat2).toString());
            TDebug.out(new StringBuffer().append("to  : ").append(audioFormat).toString());
            TDebug.out(new StringBuffer().append("< result : ").append(bl).toString());
        }
        return bl;
    }

    private static long convertLength(AudioFormat audioFormat, AudioFormat audioFormat2, long l) {
        if (l == -1L) {
            return l;
        }
        return Math.round(audioFormat2.getSampleRate() / audioFormat.getSampleRate() * (float)l);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SampleRateConverterStream
    extends AudioInputStream {
        private FloatSampleBuffer thisBuffer;
        private FloatSampleBuffer writeBuffer;
        private byte[] byteBuffer;
        private AudioInputStream sourceStream;
        private float sourceSampleRate;
        private float targetSampleRate;
        private double dPos;
        public static final int SAMPLE_AND_HOLD = 1;
        public static final int LINEAR_INTERPOLATION = 2;
        public static final int RESAMPLE = 3;
        private int sourceBufferTime;
        private int conversionAlgorithm;
        private FloatSampleBuffer historyBuffer;
        private int minimumSamplesInHistory;
        private boolean thisBufferValid;
        private long testInFramesRead;
        private long testOutFramesReturned;

        public SampleRateConverterStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
            super(audioInputStream, new SRCAudioFormat(audioFormat), SampleRateConversionProvider.convertLength(audioInputStream.getFormat(), audioFormat, audioInputStream.getFrameLength()));
            this.Block$();
            if (TDebug.TraceAudioConverter) {
                TDebug.out("SampleRateConverterStream: <init>");
            }
            this.sourceStream = audioInputStream;
            this.sourceSampleRate = audioInputStream.getFormat().getSampleRate();
            this.targetSampleRate = audioFormat.getSampleRate();
            this.dPos = 0.0;
            this.sourceBufferTime = 100;
            this.resizeBuffers();
            this.flush();
        }

        private synchronized void resizeBuffers() {
            int n = (int)AudioUtils.millis2Frames((long)this.sourceBufferTime, this.sourceSampleRate);
            if (n < this.minimumSamplesInHistory) {
                n = this.minimumSamplesInHistory;
            }
            if ((double)n < this.outSamples2inSamples(1.0)) {
                n = this.roundUp(this.outSamples2inSamples(1.0));
            }
            if (this.historyBuffer == null) {
                this.historyBuffer = new FloatSampleBuffer(this.sourceStream.getFormat().getChannels(), n, this.sourceSampleRate);
                this.historyBuffer.makeSilence();
            }
            this.historyBuffer.changeSampleCount(n, true);
            if (this.thisBuffer == null) {
                this.thisBuffer = new FloatSampleBuffer(this.sourceStream.getFormat().getChannels(), n, this.sourceSampleRate);
            }
            this.thisBuffer.changeSampleCount(n, true);
        }

        private synchronized void readFromByteSourceStream() throws IOException {
            int n;
            int n2 = this.thisBuffer.getByteArrayBufferSize(this.getFormat());
            if (this.byteBuffer == null || this.byteBuffer.length < n2) {
                this.byteBuffer = new byte[n2];
            }
            int n3 = 0;
            do {
                if ((n = this.sourceStream.read(this.byteBuffer, n3, n2 - n3)) <= 0) continue;
                n3 += n;
            } while (n3 < n2 && n > 0);
            if (n3 == 0) {
                this.close();
                return;
            }
            this.thisBuffer.initFromByteArray(this.byteBuffer, 0, n3, this.sourceStream.getFormat());
        }

        private synchronized void readFromFloatSourceStream() throws IOException {
        }

        private synchronized void readFromSourceStream() throws IOException {
            if (this.isClosed()) {
                return;
            }
            int n = this.thisBuffer.getSampleCount();
            FloatSampleBuffer floatSampleBuffer = this.historyBuffer;
            this.historyBuffer = this.thisBuffer;
            this.thisBuffer = floatSampleBuffer;
            if (this.sourceStream.getFrameLength() != -1L && (long)this.thisBuffer.getSampleCount() + this.testInFramesRead > this.sourceStream.getFrameLength()) {
                if (this.sourceStream.getFrameLength() - this.testInFramesRead <= 0L) {
                    this.close();
                    return;
                }
                this.thisBuffer.changeSampleCount((int)(this.sourceStream.getFrameLength() - this.testInFramesRead), false);
            }
            this.readFromByteSourceStream();
            if (TDebug.TraceAudioConverter) {
                this.testInFramesRead += (long)this.thisBuffer.getSampleCount();
            }
            double d = this.outSamples2inSamples(1.0);
            if (!this.thisBufferValid) {
                this.thisBufferValid = true;
                this.dPos = 0.0;
                return;
            }
            double d2 = this.dPos;
            this.dPos -= (double)n;
            if ((this.dPos > d || this.dPos < -d) && this.roundDown(this.dPos) != 0) {
                this.dPos = 0.0;
            }
        }

        private int roundDown(double d) {
            return (int)Math.floor(d);
        }

        private int roundUp(double d) {
            return (int)Math.ceil(d);
        }

        private void convertSampleAndHold(float[] fArray, double d, int n, double d2, float[] fArray2, int n2, int n3, float[] fArray3, int n4) {
            int n5 = 0;
            while (n5 < n3) {
                int n6 = this.roundDown(d + d2 * (double)n5);
                if (n6 < 0) {
                    fArray2[n5 + n2] = fArray3[n6 + n4];
                } else if (n6 < n) {
                    fArray2[n5 + n2] = fArray[n6];
                }
                ++n5;
            }
        }

        private void convertLinearInterpolation(float[] fArray, double d, int n, double d2, float[] fArray2, int n2, int n3, float[] fArray3, int n4) {
            int n5 = 0;
            while (n5 < n3) {
                try {
                    double d3 = d + d2 * (double)n5 - 1.0;
                    int n6 = (int)Math.floor(d3);
                    double d4 = 1.0 - (d3 - (double)n6);
                    float f = 0.0f;
                    int n7 = 0;
                    while (n7 < 2) {
                        if (n6 < n) {
                            if (n6 < 0) {
                                int n8 = n6 + n4;
                                if (n8 >= 0) {
                                    f = (float)((double)f + (double)fArray3[n8] * d4);
                                }
                            } else {
                                f = (float)((double)f + (double)fArray[n6] * d4);
                            }
                        }
                        d4 = 1.0 - d4;
                        ++n6;
                        ++n7;
                    }
                    fArray2[n5 + n2] = f;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ++n5;
            }
        }

        private double inSamples2outSamples(double d) {
            return d * (double)this.targetSampleRate / (double)this.sourceSampleRate;
        }

        private double outSamples2inSamples(double d) {
            return d * (double)this.sourceSampleRate / (double)this.targetSampleRate;
        }

        public synchronized int read(FloatSampleBuffer floatSampleBuffer) throws IOException {
            int n;
            if (this.isClosed()) {
                return -1;
            }
            if (floatSampleBuffer.getChannelCount() != this.thisBuffer.getChannelCount()) {
                throw new IllegalArgumentException("passed buffer has different channel count");
            }
            if (floatSampleBuffer.getSampleCount() == 0) {
                return 0;
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out(new StringBuffer().append(">SamplerateConverterStream.read(").append(floatSampleBuffer.getSampleCount()).append("frames)").toString());
            }
            double d = this.outSamples2inSamples(1.0);
            int n2 = 0;
            do {
                int n3;
                int n4 = this.thisBuffer.getSampleCount();
                if (this.roundDown(this.dPos) >= n4 || !this.thisBufferValid) {
                    this.readFromSourceStream();
                    if (this.isClosed()) break;
                    n4 = this.thisBuffer.getSampleCount();
                }
                if (this.roundDown(this.outSamples2inSamples(n = floatSampleBuffer.getSampleCount() - n2) + this.dPos) >= n4) {
                    n3 = this.roundUp(this.inSamples2outSamples((double)n4 - this.dPos));
                    while (this.roundDown(this.outSamples2inSamples(n3) + this.dPos) >= n4) {
                        --n3;
                    }
                    n = n3 + 1;
                }
                n3 = 0;
                while (n3 < floatSampleBuffer.getChannelCount()) {
                    float[] fArray = this.thisBuffer.getChannel(n3);
                    float[] fArray2 = floatSampleBuffer.getChannel(n3);
                    float[] fArray3 = this.historyBuffer.getChannel(n3);
                    switch (this.conversionAlgorithm) {
                        case 1: {
                            this.convertSampleAndHold(fArray, this.dPos, n4, d, fArray2, n2, n, fArray3, this.historyBuffer.getSampleCount());
                            break;
                        }
                        case 2: {
                            this.convertLinearInterpolation(fArray, this.dPos, n4, d, fArray2, n2, n, fArray3, this.historyBuffer.getSampleCount());
                        }
                    }
                    ++n3;
                }
                this.dPos += this.outSamples2inSamples(n);
            } while (!this.isClosed() && (n2 += n) < floatSampleBuffer.getSampleCount());
            if (n2 < floatSampleBuffer.getSampleCount()) {
                floatSampleBuffer.changeSampleCount(n2, true);
            }
            if (TDebug.TraceAudioConverter) {
                this.testOutFramesReturned += (long)floatSampleBuffer.getSampleCount();
                TDebug.out(new StringBuffer().append("< return ").append(floatSampleBuffer.getSampleCount()).append("frames. Total=").append(this.testOutFramesReturned).append(" frames. Read total ").append(this.testInFramesRead).append(" frames from source stream").toString());
            }
            return floatSampleBuffer.getSampleCount();
        }

        protected double sourceFrames2targetFrames(double d) {
            return (double)(this.targetSampleRate / this.sourceSampleRate) * d;
        }

        protected double targetFrames2sourceFrames(double d) {
            return (double)(this.sourceSampleRate / this.targetSampleRate) * d;
        }

        protected long sourceBytes2targetBytes(long l) {
            long l2 = l / (long)this.getSourceFrameSize();
            long l3 = (long)this.sourceFrames2targetFrames(l2);
            return l3 * (long)this.getFrameSize();
        }

        protected long targetBytes2sourceBytes(long l) {
            long l2 = l / (long)this.getFrameSize();
            long l3 = (long)this.targetFrames2sourceFrames(l2);
            return l3 * (long)this.getSourceFrameSize();
        }

        public int getFrameSize() {
            return this.getFormat().getFrameSize();
        }

        public int getSourceFrameSize() {
            return this.sourceStream.getFormat().getFrameSize();
        }

        @Override
        public int read() throws IOException {
            if (this.getFormat().getFrameSize() != 1) {
                throw new IOException("frame size must be 1 to read a single byte");
            }
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n <= 0) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.isClosed()) {
                return -1;
            }
            int n3 = n2 / this.getFrameSize();
            if (this.writeBuffer == null) {
                this.writeBuffer = new FloatSampleBuffer(this.getFormat().getChannels(), n3, this.getFormat().getSampleRate());
            } else {
                this.writeBuffer.changeSampleCount(n3, false);
            }
            int n4 = this.read(this.writeBuffer);
            if (n4 == -1) {
                return -1;
            }
            int n5 = this.writeBuffer.convertToByteArray(byArray, n, this.getFormat());
            return n5;
        }

        @Override
        public synchronized long skip(long l) throws IOException {
            long l2 = this.targetBytes2sourceBytes(l);
            long l3 = this.sourceStream.skip(l2);
            this.flush();
            return this.sourceBytes2targetBytes(l3);
        }

        @Override
        public int available() throws IOException {
            return (int)this.sourceBytes2targetBytes(this.sourceStream.available());
        }

        @Override
        public void mark(int n) {
            this.sourceStream.mark((int)this.targetBytes2sourceBytes(n));
        }

        @Override
        public synchronized void reset() throws IOException {
            this.sourceStream.reset();
            this.flush();
        }

        @Override
        public boolean markSupported() {
            return this.sourceStream.markSupported();
        }

        @Override
        public void close() throws IOException {
            if (this.isClosed()) {
                return;
            }
            this.sourceStream.close();
            this.thisBuffer = null;
            this.historyBuffer = null;
            this.byteBuffer = null;
        }

        public boolean isClosed() {
            return this.thisBuffer == null;
        }

        public synchronized void flush() {
            if (!this.isClosed()) {
                this.thisBufferValid = false;
                this.historyBuffer.makeSilence();
            }
        }

        public synchronized void setTargetSampleRate(float f) {
            if (f > 0.0f) {
                this.targetSampleRate = f;
                this.resizeBuffers();
            }
        }

        public synchronized void setConversionAlgorithm(int n) {
            if ((n == 1 || n == 2) && n != this.conversionAlgorithm) {
                this.conversionAlgorithm = n;
                this.resizeBuffers();
            }
        }

        public synchronized float getTargetSampleRate() {
            return this.targetSampleRate;
        }

        public synchronized int getConversionAlgorithm() {
            return this.conversionAlgorithm;
        }

        private /* synthetic */ void Block$() {
            this.thisBuffer = null;
            this.writeBuffer = null;
            this.conversionAlgorithm = 2;
            this.historyBuffer = null;
            this.minimumSamplesInHistory = 1;
            this.thisBufferValid = false;
            this.testInFramesRead = 0L;
            this.testOutFramesReturned = 0L;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SRCAudioFormat
    extends AudioFormat {
        private float sampleRate;

        public SRCAudioFormat(AudioFormat audioFormat) {
            super(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8, audioFormat.getSampleRate(), audioFormat.isBigEndian());
            this.sampleRate = audioFormat.getSampleRate();
        }

        public void setSampleRate(float f) {
            if (f > 0.0f) {
                this.sampleRate = f;
            }
        }

        @Override
        public float getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public float getFrameRate() {
            return this.sampleRate;
        }
    }
}

