/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UlawFormatConversionProvider
extends TEncodingFormatConversionProvider {
    private static final int ALL = -1;
    public static AudioFormat.Encoding ENC_PCM_SIGNED = Encodings.getEncoding("PCM_SIGNED");
    public static AudioFormat.Encoding ENC_PCM_UNSIGNED = Encodings.getEncoding("PCM_UNSIGNED");
    public static AudioFormat.Encoding ENC_ULAW = Encodings.getEncoding("ULAW");
    public static AudioFormat.Encoding ENC_ALAW = Encodings.getEncoding("ALAW");
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(ENC_PCM_SIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(ENC_PCM_SIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(ENC_PCM_UNSIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(ENC_PCM_UNSIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(ENC_PCM_SIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(ENC_PCM_SIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(ENC_PCM_UNSIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(ENC_PCM_UNSIGNED, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(ENC_PCM_SIGNED, ALL, 16, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(ENC_PCM_SIGNED, ALL, 16, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(ENC_PCM_SIGNED, ALL, 16, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(ENC_PCM_SIGNED, ALL, 16, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(ENC_ALAW, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(ENC_ALAW, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true), new AudioFormat(ENC_ULAW, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, false), new AudioFormat(ENC_ULAW, ALL, 8, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED, ALL, true)};
    private static final int UNSIGNED8 = 1;
    private static final int SIGNED8 = 2;
    private static final int BIG_ENDIAN16 = 3;
    private static final int LITTLE_ENDIAN16 = 4;
    private static final int ALAW = 5;

    public UlawFormatConversionProvider() {
        super(Arrays.asList(OUTPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (AudioFormats.matches(audioFormat2, audioFormat)) {
            return audioInputStream;
        }
        if (TSimpleFormatConversionProvider.doMatch(audioFormat.getFrameRate(), audioFormat2.getFrameRate()) && TSimpleFormatConversionProvider.doMatch(audioFormat.getChannels(), audioFormat2.getChannels())) {
            if (TSimpleFormatConversionProvider.doMatch(audioFormat.getSampleSizeInBits(), 8) && audioFormat.getEncoding().equals(ENC_ULAW)) {
                return new ToUlawStream(audioInputStream);
            }
            if (TSimpleFormatConversionProvider.doMatch(audioFormat2.getSampleSizeInBits(), 8) && audioFormat2.getEncoding().equals(ENC_ULAW)) {
                return new FromUlawStream(audioInputStream, audioFormat);
            }
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    private boolean isSupportedFormat(AudioFormat audioFormat) {
        return this.getConvertType(audioFormat) != 0;
    }

    private int getConvertType(AudioFormat audioFormat) {
        int n = 0;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        boolean bl = audioFormat.isBigEndian();
        int n2 = audioFormat.getSampleSizeInBits();
        if (encoding.equals(ENC_PCM_SIGNED)) {
            if (n2 == 16) {
                n = bl ? 3 : 4;
            } else if (n2 == 8) {
                n = 2;
            }
        } else if (encoding.equals(ENC_PCM_UNSIGNED)) {
            if (n2 == 8) {
                n = 1;
            }
        } else if (encoding.equals(ENC_ALAW)) {
            n = 5;
        }
        return n;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToUlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public ToUlawStream(AudioInputStream audioInputStream) {
            super(audioInputStream, new AudioFormat(ENC_ULAW, audioInputStream.getFormat().getSampleRate(), 8, audioInputStream.getFormat().getChannels(), audioInputStream.getFormat().getChannels(), audioInputStream.getFormat().getFrameRate(), audioInputStream.getFormat().isBigEndian()));
            this.convertType = UlawFormatConversionProvider.this.getConvertType(audioInputStream.getFormat());
            this.enableConvertInPlace();
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
        }

        @Override
        protected int convert(byte[] byArray, byte[] byArray2, int n, int n2) {
            int n3 = n2 * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82ulaw(byArray, 0, byArray2, n, n3, false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82ulaw(byArray, 0, byArray2, n, n3, true);
                    break;
                }
                case 3: {
                    TConversionTool.pcm162ulaw(byArray, 0, byArray2, n, n3, true);
                    break;
                }
                case 4: {
                    TConversionTool.pcm162ulaw(byArray, 0, byArray2, n, n3, false);
                    break;
                }
                case 5: {
                    TConversionTool.alaw2ulaw(byArray, 0, byArray2, n, n3);
                }
            }
            return n2;
        }

        @Override
        protected void convertInPlace(byte[] byArray, int n, int n2) {
            int n3 = n2 * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82ulaw(byArray, n, n3, false);
                    return;
                }
                case 2: {
                    TConversionTool.pcm82ulaw(byArray, n, n3, true);
                    return;
                }
                case 5: {
                    TConversionTool.alaw2ulaw(byArray, n, n3);
                    return;
                }
            }
            throw new RuntimeException("ToUlawStream: Call to convertInPlace, but it cannot convert in place.");
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FromUlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public FromUlawStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
            super(audioInputStream, new AudioFormat(audioFormat.getEncoding(), audioInputStream.getFormat().getSampleRate(), audioFormat.getSampleSizeInBits(), audioInputStream.getFormat().getChannels(), audioFormat.getSampleSizeInBits() * audioInputStream.getFormat().getChannels() / 8, audioInputStream.getFormat().getFrameRate(), audioFormat.isBigEndian()));
            this.convertType = UlawFormatConversionProvider.this.getConvertType(this.getFormat());
            this.enableConvertInPlace();
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
        }

        @Override
        protected int convert(byte[] byArray, byte[] byArray2, int n, int n2) {
            int n3 = n2 * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.ulaw2pcm8(byArray, 0, byArray2, n, n3, false);
                    break;
                }
                case 2: {
                    TConversionTool.ulaw2pcm8(byArray, 0, byArray2, n, n3, true);
                    break;
                }
                case 3: {
                    TConversionTool.ulaw2pcm16(byArray, 0, byArray2, n, n3, true);
                    break;
                }
                case 4: {
                    TConversionTool.ulaw2pcm16(byArray, 0, byArray2, n, n3, false);
                    break;
                }
                case 5: {
                    TConversionTool.ulaw2alaw(byArray, 0, byArray2, n, n3);
                }
            }
            return n2;
        }

        @Override
        protected void convertInPlace(byte[] byArray, int n, int n2) {
            int n3 = n2 * this.format.getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.ulaw2pcm8(byArray, n, n3, false);
                    return;
                }
                case 2: {
                    TConversionTool.ulaw2pcm8(byArray, n, n3, true);
                    return;
                }
                case 5: {
                    TConversionTool.ulaw2alaw(byArray, n, n3);
                    return;
                }
            }
            throw new RuntimeException("FromUlawStream: Call to convertInPlace, but it cannot convert in place.");
        }
    }
}

