/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AiffAudioFileReader
extends TAudioFileReader {
    private static final int READ_LIMIT = 1000;

    public AiffAudioFileReader() {
        super(1000);
    }

    private void skipChunk(DataInputStream dataInputStream, int n, int n2) throws IOException {
        if ((n -= n2) > 0) {
            dataInputStream.skip(n + n % 2);
        }
    }

    private AudioFormat readCommChunk(DataInputStream dataInputStream, int n) throws IOException, UnsupportedAudioFileException {
        short s = dataInputStream.readShort();
        if (s <= 0) {
            throw new UnsupportedAudioFileException("not an AIFF file: number of channels must be positive");
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out(new StringBuffer().append("Found ").append(s).append(" channels.").toString());
        }
        dataInputStream.readInt();
        int n2 = dataInputStream.readShort();
        float f = (float)TAudioFileReader.readIeeeExtended(dataInputStream);
        if ((double)f <= 0.0) {
            throw new UnsupportedAudioFileException("not an AIFF file: sample rate must be positive");
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out(new StringBuffer().append("Found framerate ").append(f).toString());
        }
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        int n3 = 18;
        if (n > n3) {
            int n4 = dataInputStream.readInt();
            n3 += 4;
            if (n4 != 1313820229) {
                if (n4 == 1970037111) {
                    encoding = AudioFormat.Encoding.ULAW;
                    n2 = 8;
                } else {
                    throw new UnsupportedAudioFileException(new StringBuffer().append("Encoding 0x").append(Integer.toHexString(n4)).append(" of AIFF file not supported").toString());
                }
            }
        }
        this.skipChunk(dataInputStream, n, n3);
        AudioFormat audioFormat = new AudioFormat(encoding, f, n2, s, n2 * s / 8, f, true);
        return audioFormat;
    }

    private void readVerChunk(DataInputStream dataInputStream, int n) throws IOException, UnsupportedAudioFileException {
        if (n < 4) {
            throw new UnsupportedAudioFileException("Corrput AIFF file: FVER chunk too small.");
        }
        int n2 = dataInputStream.readInt();
        if (n2 != -1568648896) {
            throw new UnsupportedAudioFileException("Unsupported AIFF file: version not known.");
        }
        this.skipChunk(dataInputStream, n, 4);
    }

    @Override
    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        boolean bl;
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AiffAudioFileReader.getAudioFileFormat(InputStream, long): begin");
        }
        if ((n = dataInputStream.readInt()) != 1179603533) {
            throw new UnsupportedAudioFileException("not an AIFF file: header magic is not FORM");
        }
        int n2 = dataInputStream.readInt();
        n = dataInputStream.readInt();
        if (n == 1095321158) {
            bl = false;
        } else if (n == 1095321155) {
            bl = true;
        } else {
            throw new UnsupportedAudioFileException("unsupported IFF file: header magic neither AIFF nor AIFC");
        }
        boolean bl2 = bl ^ true;
        boolean bl3 = false;
        boolean bl4 = false;
        AudioFormat audioFormat = null;
        int n3 = 0;
        block5: while (!(bl2 && bl3 && bl4)) {
            n = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            switch (n) {
                case 1129270605: {
                    audioFormat = this.readCommChunk(dataInputStream, n4);
                    if (TDebug.TraceAudioFileReader) {
                        TDebug.out(new StringBuffer().append("Read COMM chunk with length ").append(n4).toString());
                    }
                    bl3 = true;
                    break;
                }
                case 1180058962: {
                    if (!bl2) {
                        this.readVerChunk(dataInputStream, n4);
                        if (TDebug.TraceAudioFileReader) {
                            TDebug.out(new StringBuffer().append("Read FVER chunk with length ").append(n4).toString());
                        }
                        bl2 = true;
                        break;
                    }
                    this.skipChunk(dataInputStream, n4, 0);
                    break;
                }
                case 1397968452: {
                    if (!bl3 || !bl2) {
                        throw new UnsupportedAudioFileException("cannot handle AIFF file: SSND not last chunk");
                    }
                    bl4 = true;
                    n3 = n4 - 8;
                    dataInputStream.skip(8L);
                    if (!TDebug.TraceAudioFileReader) continue block5;
                    TDebug.out(new StringBuffer().append("Found SSND chunk with length ").append(n4).toString());
                    break;
                }
                default: {
                    if (TDebug.TraceAudioFileReader) {
                        TDebug.out(new StringBuffer().append("Skipping unknown chunk: ").append(Integer.toHexString(n)).toString());
                    }
                    this.skipChunk(dataInputStream, n4, 0);
                }
            }
        }
        TAudioFileFormat tAudioFileFormat = new TAudioFileFormat(bl ? AudioFileFormat.Type.AIFC : AudioFileFormat.Type.AIFF, audioFormat, n3 / audioFormat.getFrameSize(), n2 + 8);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AiffAudioFileReader.getAudioFileFormat(InputStream, long): end");
        }
        return tAudioFileFormat;
    }
}

