/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.sampled.file.WaveTool;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaveAudioFileReader
extends TAudioFileReader {
    private static final int READ_LIMIT = 1000;

    public WaveAudioFileReader() {
        super(1000);
    }

    protected void advanceChunk(DataInputStream dataInputStream, long l, long l2) throws IOException {
        if (l > 0L) {
            dataInputStream.skip((l + 1L & 0xFFFFFFFFFFFFFFFEL) - l2);
        }
    }

    protected long findChunk(DataInputStream dataInputStream, int n) throws UnsupportedAudioFileException, IOException {
        int n2;
        long l = 0L;
        do {
            this.advanceChunk(dataInputStream, l, 0L);
            try {
                n2 = dataInputStream.readInt();
            }
            catch (IOException iOException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(iOException);
                }
                throw new UnsupportedAudioFileException("unsupported WAVE file: required chunk not found.");
            }
            l = TAudioFileReader.readLittleEndianInt(dataInputStream) & 0xFFFFFFFF;
        } while (n2 != n);
        return l;
    }

    protected AudioFormat readFormatChunk(DataInputStream dataInputStream, long l) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding;
        int n;
        String string = "";
        int n2 = 14;
        if (l < 14L) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: format chunk is too small");
        }
        short s = TAudioFileReader.readLittleEndianShort(dataInputStream);
        short s2 = TAudioFileReader.readLittleEndianShort(dataInputStream);
        if (s2 <= 0) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: number of channels must be positive");
        }
        int n3 = TAudioFileReader.readLittleEndianInt(dataInputStream);
        if (n3 <= 0) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: sample rate must be positive");
        }
        int n4 = TAudioFileReader.readLittleEndianInt(dataInputStream);
        short s3 = TAudioFileReader.readLittleEndianShort(dataInputStream);
        int n5 = 0;
        float f = n3;
        switch (s) {
            case 1: {
                if (l < 16L) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: format chunk is too small");
                }
                n = TAudioFileReader.readLittleEndianShort(dataInputStream);
                if (n <= 0) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: sample size must be positive");
                }
                AudioFormat.Encoding encoding2 = encoding = n <= 8 ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED;
                if (TDebug.TraceAudioFileReader) {
                    string = string.concat(new StringBuffer().append(", wBitsPerSample=").append(n).toString());
                }
                n2 += 2;
                break;
            }
            case 6: {
                n = 8;
                encoding = AudioFormat.Encoding.ALAW;
                break;
            }
            case 7: {
                n = 8;
                encoding = AudioFormat.Encoding.ULAW;
                break;
            }
            case 49: {
                if (l < 20L) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra GSM bytes are missing");
                }
                n = TAudioFileReader.readLittleEndianShort(dataInputStream);
                short s4 = TAudioFileReader.readLittleEndianShort(dataInputStream);
                if (s4 < 2) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra GSM bytes are corrupt");
                }
                int n6 = TAudioFileReader.readLittleEndianShort(dataInputStream) & 0xFFFF;
                if (TDebug.TraceAudioFileReader) {
                    string = string.concat(new StringBuffer().append(", wBitsPerSample=").append(n).append(", cbSize=").append(s4).append(", wSamplesPerBlock=").append(n6).toString());
                }
                n = -1;
                encoding = WaveTool.GSM0610;
                n5 = s3;
                f = (float)n3 / (float)n6;
                n2 += 6;
                break;
            }
            default: {
                throw new UnsupportedAudioFileException(new StringBuffer().append("unsupported WAVE file: unknown format code ").append(s).toString());
            }
        }
        if (n5 == 0) {
            n5 = n * s2 / 8;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("WaveAudioFileReader.readFormatChunk():");
            TDebug.out(new StringBuffer().append("  read values: wFormatTag=").append(s).append(", nChannels=").append(s2).append(", nSamplesPerSec=").append(n3).append(", nAvgBytesPerSec=").append(n4).append(", nBlockAlign==").append(s3).append(string).toString());
            TDebug.out(new StringBuffer().append("  constructed values: encoding=").append(encoding).append(", sampleRate=").append((float)n3).append(", sampleSizeInBits=").append(n).append(", channels=").append(s2).append(", frameSize=").append(n5).append(", frameRate=").append(f).toString());
        }
        this.advanceChunk(dataInputStream, l, n2);
        return new AudioFormat(encoding, n3, n, s2, n5, f, false);
    }

    @Override
    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != 1380533830) {
            throw new UnsupportedAudioFileException("not a WAVE file: wrong header magic");
        }
        long l2 = TAudioFileReader.readLittleEndianInt(dataInputStream) & 0xFFFFFFFF;
        n = dataInputStream.readInt();
        if (n != 1463899717) {
            throw new UnsupportedAudioFileException("not a WAVE file: wrong header magic");
        }
        long l3 = this.findChunk(dataInputStream, 1718449184);
        AudioFormat audioFormat = this.readFormatChunk(dataInputStream, l3);
        long l4 = this.findChunk(dataInputStream, 1684108385);
        long l5 = l4 / (long)audioFormat.getFrameSize();
        if (audioFormat.getEncoding().equals(WaveTool.GSM0610)) {
            l5 = l4;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out(new StringBuffer().append("WaveAudioFileReader.getAudioFileFormat(): total length: ").append(l2).append(", frame length = ").append(l5).toString());
        }
        return new TAudioFileFormat(AudioFileFormat.Type.WAVE, audioFormat, (int)l5, (int)(l2 + 8L));
    }
}

