/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import org.tritonus.lowlevel.esd.EsdSample;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsdClip
extends TDataLine
implements Clip {
    private static final Class[] CONTROL_CLASSES = new Class[0];
    private static final int BUFFER_FRAMES = 16384;
    private Mixer m_mixer;
    private EsdSample m_esdSample;

    public EsdClip(TMixer tMixer) {
        super(tMixer, null);
        this.m_mixer = tMixer;
        this.m_esdSample = new EsdSample();
    }

    @Override
    public void open(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
        int n3 = n2 * audioFormat.getFrameSize();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n3);
        try {
            AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, n2);
            this.open(audioInputStream);
            return;
        }
        catch (IOException iOException) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(iOException);
            }
            throw new LineUnavailableException();
        }
    }

    @Override
    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(Class.forName("javax.sound.sampled.Clip"), audioFormat, -1);
        this.setLineInfo(info);
        int n = audioFormat.getFrameSize();
        long l = audioInputStream.getFrameLength() * (long)n;
        int n2 = 0x1000 | EsdUtils.getEsdFormat(audioFormat);
        if (TDebug.TraceClip) {
            TDebug.out(new StringBuffer().append("format: ").append(n2).toString());
            TDebug.out(new StringBuffer().append("sample rate: ").append(audioFormat.getSampleRate()).toString());
        }
        this.m_esdSample.open(n2, (int)audioFormat.getSampleRate(), (int)l);
        if (TDebug.TraceClip) {
            TDebug.out(new StringBuffer().append("size in esd: ").append(audioInputStream.getFrameLength() * (long)n).toString());
        }
        int n3 = 16384 * n;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 != -1) {
            block6: {
                try {
                    n4 = audioInputStream.read(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    if (!TDebug.TraceClip && !TDebug.TraceAllExceptions) break block6;
                    TDebug.out(iOException);
                }
            }
            if (n4 < 0) continue;
            n5 += n4;
            if (TDebug.TraceClip) {
                TDebug.out(new StringBuffer().append("EsdClip.open(): total bytes: ").append(n5).toString());
                TDebug.out(new StringBuffer().append("EsdClip.open(): Trying to write: ").append(n4).toString());
            }
            int n6 = this.m_esdSample.write(byArray, 0, n4);
            if (!TDebug.TraceClip) continue;
            TDebug.out(new StringBuffer().append("EsdClip.open(): Written: ").append(n6).toString());
        }
        this.open();
    }

    @Override
    public int getFrameLength() {
        return -1;
    }

    @Override
    public long getMicrosecondLength() {
        return -1L;
    }

    @Override
    public void setFramePosition(int n) {
    }

    @Override
    public void setMicrosecondPosition(long l) {
    }

    @Override
    public int getFramePosition() {
        return -1;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public void setLoopPoints(int n, int n2) {
    }

    @Override
    public void loop(int n) {
        if (TDebug.TraceClip) {
            TDebug.out(new StringBuffer().append("EsdClip.loop(int): called; count = ").append(n).toString());
        }
        if (n == 0) {
            if (TDebug.TraceClip) {
                TDebug.out("EsdClip.loop(int): starting sample (once)");
            }
            this.m_esdSample.play();
            return;
        }
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.loop(int): starting sample (forever)");
        }
        this.m_esdSample.loop();
    }

    @Override
    public void flush() {
    }

    @Override
    public void drain() {
    }

    @Override
    public void close() {
        this.m_esdSample.free();
        this.m_esdSample.close();
    }

    @Override
    public void open() {
    }

    @Override
    public void start() {
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.start(): called");
        }
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.start(): calling 'loop(0)' [hack]");
        }
        this.loop(0);
    }

    @Override
    public void stop() {
        this.m_esdSample.kill();
    }

    @Override
    public int available() {
        return -1;
    }
}

