/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.lowlevel.esd.EsdStream;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.TVolumeUtils;
import org.tritonus.share.sampled.mixer.TBaseDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsdSourceDataLine
extends TBaseDataLine
implements SourceDataLine {
    private EsdStream m_esdStream;
    private boolean m_bSwapBytes;
    private byte[] m_abSwapBuffer;
    private int m_nBytesPerSample;
    private boolean m_bMuted;
    private float m_fGain;
    private float m_fPan;

    public EsdSourceDataLine(TMixer tMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        super(tMixer, new DataLine.Info(Class.forName("javax.sound.sampled.SourceDataLine"), audioFormat, n));
        this.addControl(new EsdSourceDataLineGainControl());
        this.addControl(new EsdSourceDataLinePanControl());
        this.addControl(new EsdSourceDataLineMuteControl());
    }

    @Override
    protected void openImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.openImpl(): called.");
        }
        this.checkOpen();
        AudioFormat audioFormat = this.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        boolean bl = audioFormat.isBigEndian();
        this.m_bSwapBytes = false;
        if (audioFormat.getSampleSizeInBits() == 16 && bl) {
            this.m_bSwapBytes = true;
            bl = false;
        } else if (audioFormat.getSampleSizeInBits() == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.m_bSwapBytes = true;
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (System.getProperty("os.arch").equals("ppc") && audioFormat.getSampleSizeInBits() == 16) {
            this.m_bSwapBytes ^= true;
        }
        if (this.m_bSwapBytes) {
            audioFormat = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), bl);
            this.m_nBytesPerSample = audioFormat.getFrameSize() / audioFormat.getChannels();
        }
        int n = 0x1000 | EsdUtils.getEsdFormat(audioFormat);
        this.m_esdStream = new EsdStream();
        this.m_esdStream.open(n, (int)audioFormat.getSampleRate());
    }

    @Override
    public int available() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] byArray, int n, int n2) {
        int n3;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.write(): called.");
        }
        if (this.m_bSwapBytes) {
            if (this.m_abSwapBuffer == null || this.m_abSwapBuffer.length < n + n2) {
                this.m_abSwapBuffer = new byte[n + n2];
            }
            TConversionTool.changeOrderOrSign(byArray, n, this.m_abSwapBuffer, n, n2, this.m_nBytesPerSample);
            byArray = this.m_abSwapBuffer;
        }
        if (n2 > 0 && !this.isActive()) {
            this.start();
        }
        for (int i = n2; i > 0 && this.isOpen(); i -= n3) {
            EsdSourceDataLine esdSourceDataLine = this;
            synchronized (esdSourceDataLine) {
                if (!this.isOpen()) {
                    return n2 - i;
                }
                n3 = this.m_esdStream.write(byArray, n, i);
                n += n3;
                continue;
            }
        }
        return n2;
    }

    @Override
    protected void closeImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.closeImpl(): called.");
        }
        this.m_esdStream.close();
    }

    @Override
    public void drain() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.drain(): called.");
        }
    }

    @Override
    public void flush() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.flush(): called.");
        }
    }

    private void setGain(float f) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out(new StringBuffer().append("EsdSourceDataLine.setGain(): gain: ").append(f).toString());
        }
        this.m_fGain = f;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    private void setPan(float f) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out(new StringBuffer().append("EsdSourceDataLine.setPan(): pan: ").append(f).toString());
        }
        this.m_fPan = f;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    private void setMuted(boolean bl) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out(new StringBuffer().append("EsdSourceDataLine.setMuted(): muted: ").append(bl).toString());
        }
        this.m_bMuted = bl;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    private void setGainImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setGainImpl(): called: ");
        }
        float f = this.m_fGain + this.m_fPan * 15.0f;
        float f2 = this.m_fGain - this.m_fPan * 15.0f;
        float f3 = (float)TVolumeUtils.log2lin(f);
        float f4 = (float)TVolumeUtils.log2lin(f2);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EsdSourceDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN;
        private final float MIN_GAIN;

        EsdSourceDataLineGainControl() {
            super(FloatControl.Type.MASTER_GAIN, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.Block$();
        }

        @Override
        public void setValue(float f) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out(new StringBuffer().append("EsdSourceDataLineGainControl.setValue(): gain: ").append(f).toString());
            }
            float f2 = this.getValue();
            super.setValue(f);
            if ((double)Math.abs(f2 - this.getValue()) > 1.0E-9) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLineGainControl.setValue(): really changing gain");
                }
                EsdSourceDataLine.this.setGain(this.getValue());
            }
        }

        private /* synthetic */ void Block$() {
            this.MAX_GAIN = 24.0f;
            this.MIN_GAIN = -96.0f;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EsdSourceDataLinePanControl
    extends FloatControl {
        EsdSourceDataLinePanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.01f, 0, 0.0f, "??", "left", "center", "right");
        }

        @Override
        public void setValue(float f) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out(new StringBuffer().append("EsdSourceDataLinePanControl.setValue(): pan: ").append(f).toString());
            }
            float f2 = this.getValue();
            super.setValue(f);
            if ((double)Math.abs(f2 - this.getValue()) > 1.0E-9) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLinePanControl.setValue(): really changing pan");
                }
                EsdSourceDataLine.this.setPan(this.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EsdSourceDataLineMuteControl
    extends BooleanControl {
        EsdSourceDataLineMuteControl() {
            super(BooleanControl.Type.MUTE, false, "muted", "unmuted");
        }

        @Override
        public void setValue(boolean bl) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out(new StringBuffer().append("EsdSourceDataLineMuteControl.setValue(): muted: ").append(bl).toString());
            }
            if (bl != this.getValue()) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLineMuteControl.setValue(): really changing mute status");
                }
                super.setValue(bl);
                EsdSourceDataLine.this.setMuted(this.getValue());
            }
        }
    }
}

