/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TNotifier
extends Thread {
    public static TNotifier notifier = null;
    private List m_entries = new ArrayList();

    public TNotifier() {
        super("Tritonus Notifier");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(EventObject eventObject, Collection collection) {
        List list = this.m_entries;
        synchronized (list) {
            this.m_entries.add(new NotifyEntry(eventObject, collection));
            this.m_entries.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            NotifyEntry notifyEntry = null;
            List list = this.m_entries;
            synchronized (list) {
                while (this.m_entries.size() == 0) {
                    try {
                        this.m_entries.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(interruptedException);
                    }
                }
                notifyEntry = (NotifyEntry)this.m_entries.remove(0);
            }
            notifyEntry.deliver();
        }
    }

    static {
        notifier = new TNotifier();
        notifier.setDaemon(true);
        notifier.start();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotifyEntry {
        private EventObject m_event;
        private List m_listeners;

        public NotifyEntry(EventObject eventObject, Collection collection) {
            this.m_event = eventObject;
            this.m_listeners = new ArrayList(collection);
        }

        public void deliver() {
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof LineListener)) continue;
                ((LineListener)object).update((LineEvent)this.m_event);
            }
        }
    }
}

