/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiUtils {
    public static int getUnsignedInteger(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    public static int get14bitValue(int n, int n2) {
        return n & 0x7F | (n2 & 0x7F) << 7;
    }

    public static int get14bitMSB(int n) {
        return n >> 7 & 0x7F;
    }

    public static int get14bitLSB(int n) {
        return n & 0x7F;
    }

    public static byte[] getVariableLengthQuantity(long l) {
        ByteArrayOutputStream byteArrayOutputStream;
        block2: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                MidiUtils.writeVariableLengthQuantity(l, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int writeVariableLengthQuantity(long l, OutputStream outputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = (int)(l >> 21 & 0x7FL);
        if (n2 != 0) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
            bl = true;
        }
        if ((n2 = (int)(l >> 14 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
            bl = true;
        }
        if ((n2 = (int)(l >> 7 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
        }
        n2 = (int)(l & 0x7FL);
        if (outputStream != null) {
            outputStream.write(n2);
        }
        return ++n;
    }
}

