/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.AiffAudioOutputStream;
import org.tritonus.sampled.file.AuAudioOutputStream;
import org.tritonus.sampled.file.WaveAudioOutputStream;
import org.tritonus.share.sampled.file.AudioOutputStream;
import org.tritonus.share.sampled.file.TAudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;
import org.tritonus.share.sampled.file.TNonSeekableDataOutputStream;
import org.tritonus.share.sampled.file.TSeekableDataOutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioSystemShadow {
    public static TDataOutputStream getDataOutputStream(File file) throws IOException {
        return new TSeekableDataOutputStream(file);
    }

    public static TDataOutputStream getDataOutputStream(OutputStream outputStream) throws IOException {
        return new TNonSeekableDataOutputStream(outputStream);
    }

    public static AudioOutputStream getAudioOutputStream(AudioFileFormat.Type type, AudioFormat audioFormat, long l, TDataOutputStream tDataOutputStream) {
        TAudioOutputStream tAudioOutputStream = null;
        if (type.equals(AudioFileFormat.Type.AIFF) || type.equals(AudioFileFormat.Type.AIFF)) {
            tAudioOutputStream = new AiffAudioOutputStream(audioFormat, type, l, tDataOutputStream);
        } else if (type.equals(AudioFileFormat.Type.AU)) {
            tAudioOutputStream = new AuAudioOutputStream(audioFormat, l, tDataOutputStream);
        } else if (type.equals(AudioFileFormat.Type.WAVE)) {
            tAudioOutputStream = new WaveAudioOutputStream(audioFormat, l, tDataOutputStream);
        }
        return tAudioOutputStream;
    }

    public static AudioOutputStream getAudioOutputStream(AudioFileFormat.Type type, AudioFormat audioFormat, long l, File file) throws IOException {
        TDataOutputStream tDataOutputStream = AudioSystemShadow.getDataOutputStream(file);
        AudioOutputStream audioOutputStream = AudioSystemShadow.getAudioOutputStream(type, audioFormat, l, tDataOutputStream);
        return audioOutputStream;
    }

    public static AudioOutputStream getAudioOutputStream(AudioFileFormat.Type type, AudioFormat audioFormat, long l, OutputStream outputStream) throws IOException {
        TDataOutputStream tDataOutputStream = AudioSystemShadow.getDataOutputStream(outputStream);
        AudioOutputStream audioOutputStream = AudioSystemShadow.getAudioOutputStream(type, audioFormat, l, tDataOutputStream);
        return audioOutputStream;
    }
}

