/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TFormatConversionProvider
extends FormatConversionProvider {
    protected static final AudioFormat.Encoding[] EMPTY_ENCODING_ARRAY = new AudioFormat.Encoding[0];
    protected static final AudioFormat[] EMPTY_FORMAT_ARRAY = new AudioFormat[0];

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat audioFormat2 = new AudioFormat(encoding, -1.0f, -1, -1, -1, -1.0f, audioFormat.isBigEndian());
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TFormatConversionProvider.getAudioInputStream(AudioFormat.Encoding, AudioInputStream):");
            TDebug.out(new StringBuffer().append("trying to convert to ").append(audioFormat2).toString());
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    @Override
    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">TFormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out(new StringBuffer().append("class: ").append(this.getClass().getName()).toString());
            TDebug.out("checking if conversion possible");
            TDebug.out(new StringBuffer().append("from: ").append(audioFormat2).toString());
            TDebug.out(new StringBuffer().append("to: ").append(audioFormat).toString());
        }
        AudioFormat[] audioFormatArray = this.getTargetFormats(audioFormat.getEncoding(), audioFormat2);
        int n = 0;
        while (n < audioFormatArray.length) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out(new StringBuffer().append("checking against possible target format: ").append(audioFormatArray[n]).toString());
            }
            if (audioFormatArray[n] != null && AudioFormats.matches(audioFormatArray[n], audioFormat)) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("<result=true");
                }
                return true;
            }
            ++n;
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<result=false");
        }
        return false;
    }

    public AudioFormat getMatchingFormat(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">TFormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out(new StringBuffer().append("class: ").append(this.getClass().getName()).toString());
            TDebug.out("checking if conversion possible");
            TDebug.out(new StringBuffer().append("from: ").append(audioFormat2).toString());
            TDebug.out(new StringBuffer().append("to: ").append(audioFormat).toString());
        }
        AudioFormat[] audioFormatArray = this.getTargetFormats(audioFormat.getEncoding(), audioFormat2);
        int n = 0;
        while (n < audioFormatArray.length) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out(new StringBuffer().append("checking against possible target format: ").append(audioFormatArray[n]).toString());
            }
            if (audioFormatArray[n] != null && AudioFormats.matches(audioFormatArray[n], audioFormat)) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("<result=true");
                }
                return audioFormatArray[n];
            }
            ++n;
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<result=false");
        }
        return null;
    }
}

