/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TSimpleFormatConversionProvider
extends TFormatConversionProvider {
    private Collection m_sourceEncodings = new ArraySet();
    private Collection m_targetEncodings = new ArraySet();
    private Collection m_sourceFormats;
    private Collection m_targetFormats;

    protected TSimpleFormatConversionProvider(Collection collection, Collection collection2) {
        this.m_sourceFormats = collection;
        this.m_targetFormats = collection2;
        TSimpleFormatConversionProvider.collectEncodings(this.m_sourceFormats, this.m_sourceEncodings);
        TSimpleFormatConversionProvider.collectEncodings(this.m_targetFormats, this.m_targetEncodings);
    }

    protected void disable() {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(new StringBuffer().append("TSimpleFormatConversionProvider.disable(): disabling ").append(this.getClass().getName()).toString());
        }
        this.m_sourceEncodings = new ArraySet();
        this.m_targetEncodings = new ArraySet();
        this.m_sourceFormats = new ArraySet();
        this.m_targetFormats = new ArraySet();
    }

    private static void collectEncodings(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat = (AudioFormat)iterator.next();
            collection2.add(audioFormat.getEncoding());
        }
    }

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return (AudioFormat.Encoding[])this.m_sourceEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return (AudioFormat.Encoding[])this.m_targetEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
    }

    @Override
    public boolean isSourceEncodingSupported(AudioFormat.Encoding encoding) {
        return this.m_sourceEncodings.contains(encoding);
    }

    @Override
    public boolean isTargetEncodingSupported(AudioFormat.Encoding encoding) {
        return this.m_targetEncodings.contains(encoding);
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (this.isAllowedSourceFormat(audioFormat)) {
            return this.getTargetEncodings();
        }
        return TFormatConversionProvider.EMPTY_ENCODING_ARRAY;
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (this.isConversionSupported(encoding, audioFormat)) {
            return (AudioFormat[])this.m_targetFormats.toArray(TFormatConversionProvider.EMPTY_FORMAT_ARRAY);
        }
        return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
    }

    protected boolean isAllowedSourceEncoding(AudioFormat.Encoding encoding) {
        return this.m_sourceEncodings.contains(encoding);
    }

    protected boolean isAllowedTargetEncoding(AudioFormat.Encoding encoding) {
        return this.m_targetEncodings.contains(encoding);
    }

    protected boolean isAllowedSourceFormat(AudioFormat audioFormat) {
        Iterator iterator = this.m_sourceFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllowedTargetFormat(AudioFormat audioFormat) {
        Iterator iterator = this.m_targetFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            return true;
        }
        return false;
    }

    protected Collection getCollectionSourceEncodings() {
        return this.m_sourceEncodings;
    }

    protected Collection getCollectionTargetEncodings() {
        return this.m_targetEncodings;
    }

    protected Collection getCollectionSourceFormats() {
        return this.m_sourceFormats;
    }

    protected Collection getCollectionTargetFormats() {
        return this.m_targetFormats;
    }

    protected static boolean doMatch(int n, int n2) {
        return n == -1 || n2 == -1 || n == n2;
    }

    protected static boolean doMatch(float f, float f2) {
        return f == -1.0f || f2 == -1.0f || (double)Math.abs(f - f2) < 1.0E-9;
    }

    protected AudioFormat replaceNotSpecified(AudioFormat audioFormat, AudioFormat audioFormat2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (audioFormat2.getSampleSizeInBits() == -1 && audioFormat.getSampleSizeInBits() != -1) {
            bl = true;
        }
        if (audioFormat2.getChannels() == -1 && audioFormat.getChannels() != -1) {
            bl2 = true;
        }
        if (audioFormat2.getSampleRate() == -1.0f && audioFormat.getSampleRate() != -1.0f) {
            bl3 = true;
        }
        if (audioFormat2.getFrameRate() == -1.0f && audioFormat.getFrameRate() != -1.0f) {
            bl4 = true;
        }
        if (bl || bl2 || bl3 || bl4 || audioFormat2.getFrameSize() == -1 && audioFormat.getFrameSize() != -1) {
            float f = bl3 ? audioFormat.getSampleRate() : audioFormat2.getSampleRate();
            float f2 = bl4 ? audioFormat.getFrameRate() : audioFormat2.getFrameRate();
            int n = bl ? audioFormat.getSampleSizeInBits() : audioFormat2.getSampleSizeInBits();
            int n2 = bl2 ? audioFormat.getChannels() : audioFormat2.getChannels();
            int n3 = this.getFrameSize(audioFormat2.getEncoding(), f, n, n2, f2, audioFormat2.isBigEndian(), audioFormat2.getFrameSize());
            audioFormat2 = new AudioFormat(audioFormat2.getEncoding(), f, n, n2, n3, f2, audioFormat2.isBigEndian());
        }
        return audioFormat2;
    }

    protected int getFrameSize(AudioFormat.Encoding encoding, float f, int n, int n2, float f2, boolean bl, int n3) {
        if (n == -1 || n2 == -1) {
            return -1;
        }
        return n * n2 / 8;
    }
}

