/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.ParserFactory;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserAdapter
implements XMLReader,
DocumentHandler {
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private NamespaceSupport nsSupport;
    private AttributeListAdapter attAdapter;
    private boolean parsing;
    private String[] nameParts;
    private Parser parser;
    private AttributesImpl atts;
    private boolean namespaces;
    private boolean prefixes;
    Locator locator;
    EntityResolver entityResolver;
    DTDHandler dtdHandler;
    ContentHandler contentHandler;
    ErrorHandler errorHandler;

    public ParserAdapter() throws SAXException {
        this.Block$();
        String string = System.getProperty("org.xml.sax.parser");
        try {
            this.setup(ParserFactory.makeParser());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException(new StringBuffer().append("Cannot find SAX1 driver class ").append(string).toString(), classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(new StringBuffer().append("SAX1 driver class ").append(string).append(" found but cannot be loaded").toString(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException(new StringBuffer().append("SAX1 driver class ").append(string).append(" loaded but cannot be instantiated").toString(), instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException(new StringBuffer().append("SAX1 driver class ").append(string).append(" does not implement org.xml.sax.Parser").toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new SAXException("System property org.xml.sax.parser not specified");
        }
    }

    public ParserAdapter(Parser parser) {
        this.Block$();
        this.setup(parser);
    }

    private void setup(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Parser argument must not be null");
        }
        this.parser = parser;
        this.atts = new AttributesImpl();
        this.nsSupport = new NamespaceSupport();
        this.attAdapter = new AttributeListAdapter();
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(NAMESPACES)) {
            this.checkNotParsing("feature", string);
            this.namespaces = bl;
            if (!this.namespaces && !this.prefixes) {
                this.prefixes = true;
                return;
            }
        } else if (string.equals(NAMESPACE_PREFIXES)) {
            this.checkNotParsing("feature", string);
            this.prefixes = bl;
            if (!this.prefixes && !this.namespaces) {
                this.namespaces = true;
                return;
            }
        } else {
            throw new SAXNotRecognizedException(new StringBuffer().append("Feature: ").append(string).toString());
        }
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(NAMESPACES)) {
            return this.namespaces;
        }
        if (string.equals(NAMESPACE_PREFIXES)) {
            return this.prefixes;
        }
        throw new SAXNotRecognizedException(new StringBuffer().append("Feature: ").append(string).toString());
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(new StringBuffer().append("Property: ").append(string).toString());
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(new StringBuffer().append("Property: ").append(string).toString());
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.parsing) {
            throw new SAXException("Parser is already in use");
        }
        this.setupParser();
        this.parsing = true;
        try {
            this.parser.parse(inputSource);
        }
        finally {
            Object var3_2 = null;
            this.parsing = false;
        }
        this.parsing = false;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    @Override
    public void startElement(String string, AttributeList attributeList) throws SAXException {
        Object object;
        String string2;
        String string3;
        Vector vector = null;
        if (!this.namespaces) {
            if (this.contentHandler != null) {
                this.attAdapter.setAttributeList(attributeList);
                this.contentHandler.startElement("", "", string.intern(), this.attAdapter);
            }
            return;
        }
        this.nsSupport.pushContext();
        int n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block21: {
                block23: {
                    int n3;
                    block22: {
                        string3 = attributeList.getName(n2);
                        if (!string3.startsWith("xmlns")) break block21;
                        n3 = string3.indexOf(58);
                        if (n3 != -1 || string3.length() != 5) break block22;
                        string2 = "";
                        break block23;
                    }
                    if (n3 != 5) break block21;
                    string2 = string3.substring(n3 + 1);
                }
                object = attributeList.getValue(n2);
                if (!this.nsSupport.declarePrefix(string2, (String)object)) {
                    this.reportError(new StringBuffer().append("Illegal Namespace prefix: ").append(string2).toString());
                } else if (this.contentHandler != null) {
                    this.contentHandler.startPrefixMapping(string2, (String)object);
                }
            }
            ++n2;
        }
        this.atts.clear();
        n2 = 0;
        while (n2 < n) {
            int n4;
            string3 = attributeList.getName(n2);
            string2 = attributeList.getType(n2);
            String string4 = attributeList.getValue(n2);
            if (string3.startsWith("xmlns") && (object = (n4 = string3.indexOf(58)) == -1 && string3.length() == 5 ? "" : (n4 != 5 ? null : string3.substring(n4 + 1))) != null) {
                if (this.prefixes) {
                    this.atts.addAttribute("", "", string3.intern(), string2, string4);
                }
            } else {
                try {
                    object = this.processName(string3, true, true);
                    this.atts.addAttribute(object[0], object[1], object[2], string2, string4);
                }
                catch (SAXException sAXException) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.addElement(sAXException);
                    this.atts.addAttribute("", string3, string3, string2, string4);
                }
            }
            ++n2;
        }
        if (vector != null && this.errorHandler != null) {
            n2 = 0;
            while (n2 < vector.size()) {
                this.errorHandler.error((SAXParseException)vector.elementAt(n2));
                ++n2;
            }
        }
        if (this.contentHandler != null) {
            String[] stringArray = this.processName(string, false, false);
            this.contentHandler.startElement(stringArray[0], stringArray[1], stringArray[2], this.atts);
        }
    }

    @Override
    public void endElement(String string) throws SAXException {
        if (!this.namespaces) {
            if (this.contentHandler != null) {
                this.contentHandler.endElement("", "", string.intern());
            }
            return;
        }
        String[] stringArray = this.processName(string, false, false);
        if (this.contentHandler != null) {
            this.contentHandler.endElement(stringArray[0], stringArray[1], stringArray[2]);
            Enumeration enumeration = this.nsSupport.getDeclaredPrefixes();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                this.contentHandler.endPrefixMapping(string2);
            }
        }
        this.nsSupport.popContext();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.characters(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(string, string2);
        }
    }

    private void setupParser() {
        this.nsSupport.reset();
        if (this.entityResolver != null) {
            this.parser.setEntityResolver(this.entityResolver);
        }
        if (this.dtdHandler != null) {
            this.parser.setDTDHandler(this.dtdHandler);
        }
        if (this.errorHandler != null) {
            this.parser.setErrorHandler(this.errorHandler);
        }
        this.parser.setDocumentHandler(this);
        this.locator = null;
    }

    private String[] processName(String string, boolean bl, boolean bl2) throws SAXException {
        String[] stringArray = this.nsSupport.processName(string, this.nameParts, bl);
        if (stringArray == null) {
            if (bl2) {
                throw this.makeException(new StringBuffer().append("Undeclared prefix: ").append(string).toString());
            }
            this.reportError(new StringBuffer().append("Undeclared prefix: ").append(string).toString());
            stringArray = new String[3];
            stringArray[1] = "";
            stringArray[0] = "";
            stringArray[2] = string.intern();
        }
        return stringArray;
    }

    void reportError(String string) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(this.makeException(string));
        }
    }

    private SAXParseException makeException(String string) {
        if (this.locator != null) {
            return new SAXParseException(string, this.locator);
        }
        return new SAXParseException(string, null, null, -1, -1);
    }

    private void checkNotParsing(String string, String string2) throws SAXNotSupportedException {
        if (this.parsing) {
            throw new SAXNotSupportedException(new StringBuffer().append("Cannot change ").append(string).append(' ').append(string2).append(" while parsing").toString());
        }
    }

    private /* synthetic */ void Block$() {
        this.parsing = false;
        this.nameParts = new String[3];
        this.parser = null;
        this.atts = null;
        this.namespaces = true;
        this.prefixes = false;
        this.entityResolver = null;
        this.dtdHandler = null;
        this.contentHandler = null;
        this.errorHandler = null;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AttributeListAdapter
    implements Attributes {
        private AttributeList qAtts;

        AttributeListAdapter() {
        }

        void setAttributeList(AttributeList attributeList) {
            this.qAtts = attributeList;
        }

        @Override
        public int getLength() {
            return this.qAtts.getLength();
        }

        @Override
        public String getURI(int n) {
            return "";
        }

        @Override
        public String getLocalName(int n) {
            return "";
        }

        @Override
        public String getQName(int n) {
            return this.qAtts.getName(n).intern();
        }

        @Override
        public String getType(int n) {
            return this.qAtts.getType(n).intern();
        }

        @Override
        public String getValue(int n) {
            return this.qAtts.getValue(n);
        }

        @Override
        public int getIndex(String string, String string2) {
            return -1;
        }

        @Override
        public int getIndex(String string) {
            int n = ParserAdapter.this.atts.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (this.qAtts.getName(n2).equals(string)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        @Override
        public String getType(String string, String string2) {
            return null;
        }

        @Override
        public String getType(String string) {
            return this.qAtts.getType(string).intern();
        }

        @Override
        public String getValue(String string, String string2) {
            return null;
        }

        @Override
        public String getValue(String string) {
            return this.qAtts.getValue(string);
        }
    }
}

