/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NewInstance;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLReaderFactory {
    private static final String property = "org.xml.sax.driver";

    private XMLReaderFactory() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        String string = null;
        ClassLoader classLoader = NewInstance.getClassLoader();
        try {
            string = System.getProperty(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            try {
                String string2 = "META-INF/services/org.xml.sax.driver";
                InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
                if (inputStream != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                    string = bufferedReader.readLine();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "gnu.xml.aelfred2.SAXDriver";
        }
        if (string != null) {
            return XMLReaderFactory.loadClass(classLoader, string);
        }
        try {
            return new ParserAdapter(ParserFactory.makeParser());
        }
        catch (Exception exception) {
            throw new SAXException("Can't create default XMLReader; is system property org.xml.sax.driver set?");
        }
    }

    public static XMLReader createXMLReader(String string) throws SAXException {
        return XMLReaderFactory.loadClass(NewInstance.getClassLoader(), string);
    }

    private static XMLReader loadClass(ClassLoader classLoader, String string) throws SAXException {
        try {
            return (XMLReader)NewInstance.newInstance(classLoader, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException(new StringBuffer().append("SAX2 driver class ").append(string).append(" not found").toString(), classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(new StringBuffer().append("SAX2 driver class ").append(string).append(" found but cannot be loaded").toString(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException(new StringBuffer().append("SAX2 driver class ").append(string).append(" loaded but cannot be instantiated (no empty public constructor?)").toString(), instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException(new StringBuffer().append("SAX2 driver class ").append(string).append(" does not implement XMLReader").toString(), classCastException);
        }
    }
}

