/* include/kaffe/jtypes.h.  Generated by configure.  */
/*
 * jtypes.h
 * Java types.
 *
 * Copyright (c) 1996, 1997
 *	Transvirtual Technologies, Inc.  All rights reserved.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file.
 */

#ifndef __jtypes_h
#define __jtypes_h

#define	SIZEOF_INT 4
#define	SIZEOF_LONG 4
#define	SIZEOF_LONG_LONG 8
#define	SIZEOF___INT64 0
#define	SIZEOF_VOIDP 4

typedef float		jfloat;
typedef double		jdouble;
typedef	void*		jref;
typedef unsigned short	jchar;
typedef char		jbyte;
typedef short 		jshort;

#if SIZEOF_INT == 4
typedef int		jint;
typedef unsigned int	jsize;
#define JINT_MIN        0x80000000
#elif SIZEOF_LONG == 4
typedef long		jint;
typedef unsigned long	jsize;
#define JINT_MIN        0x80000000L
#else
#error "sizeof(int) or sizeof(long) must be 4"
#endif

#if SIZEOF_LONG == 8
typedef long		jlong;
#define JLONG_MIN       0x8000000000000000L
#elif SIZEOF_LONG_LONG == 8
typedef long long	jlong;
#define JLONG_MIN       0x8000000000000000LL
#elif SIZEOF___INT64 == 8 /* Microsoft's Visual C++ 6.0 */
typedef __int64		jlong;
#define JLONG_MIN       0x8000000000000000i64
#else
#error "sizeof(long) or sizeof(long long) or sizeof(__int64) must be 8"
#endif

typedef	jchar		unicode;
typedef	jbyte		jbool;		/* Must deprecate */
typedef	jbyte		jboolean;
typedef	jref		jobject;
typedef	jref		jclass;
typedef	jref		jstring;
typedef	jref		jarray;
typedef	jref		jthrowable;

typedef	jref		jobjectArray;
typedef	jref		jbooleanArray;
typedef	jref		jbyteArray;
typedef	jref		jcharArray;
typedef	jref		jshortArray;
typedef	jref		jintArray;
typedef	jref		jlongArray;
typedef	jref		jfloatArray;
typedef	jref		jdoubleArray;

union jvalue {
	jboolean	z;
	jbyte		b;
	jchar		c;
	jshort		s;
	jint		i;
	jlong		j;
	jfloat		f;
	jdouble		d;
	jref		l;
};
typedef union jvalue jvalue;

/* An integer type big enough for a pointer or a 32-bit int/float. */
#if SIZEOF_VOIDP <= SIZEOF_INT
typedef jint		jword;
#elif SIZEOF_VOIDP <= SIZEOF_LONG
typedef jlong		jword;
#else
#error "both sizeof(int) and sizeof(long) < sizeof(void*)"
#endif

#endif
