/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.PooledConstant;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public class ClassConstant
extends PooledConstant {
    private AsciiConstant name;

    public String getName() {
        return this.name.getValue();
    }

    Object getLiteral() {
        throw new InconsistencyException("attempt to read literal in a class constant");
    }

    public final int hashCode() {
        return (this.name.hashCode() & 0xFFFFFFF0) + 1;
    }

    public final boolean equals(Object object) {
        return object instanceof ClassConstant && ((ClassConstant)object).name.equals(this.name);
    }

    final void resolveConstants(PooledConstant pooledConstant) {
        this.setIndex(pooledConstant.getIndex());
        this.name.setIndex(((ClassConstant)pooledConstant).name.getIndex());
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(this.name);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(7);
        dataOutput.writeShort(this.name.getIndex());
    }

    public ClassConstant(String string) {
        this(new AsciiConstant(string));
    }

    public ClassConstant(AsciiConstant asciiConstant) {
        this.name = asciiConstant;
    }
}

