/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CodeFragment;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.CpoolValue2;
import gnu.bytecode.Field;
import gnu.bytecode.IfState;
import gnu.bytecode.Label;
import gnu.bytecode.LineNumbersAttr;
import gnu.bytecode.LocalVarsAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.TryState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class CodeAttr
extends Attribute
implements AttrContainer {
    Attribute attributes;
    LineNumbersAttr lines;
    public LocalVarsAttr locals;
    Type[] stack_types;
    int SP;
    private int max_stack;
    private int max_locals;
    int PC;
    int readPC;
    byte[] code;
    short[] exception_table;
    int exception_table_length;
    Label labels;
    CodeFragment fragments;
    IfState if_stack;
    TryState try_stack;
    boolean unreachable_here;
    CodeFragment fragmentStack = null;

    public CodeAttr(Method meth) {
        super("Code");
        this.addToFrontOf(meth);
        meth.code = this;
    }

    public void addHandler(int start_pc, int end_pc, int handler_pc, int catch_type) {
        int index = 4 * this.exception_table_length;
        if (this.exception_table == null) {
            this.exception_table = new short[20];
        } else if (this.exception_table.length <= index) {
            short[] new_table = new short[2 * this.exception_table.length];
            System.arraycopy(this.exception_table, 0, new_table, 0, index);
            this.exception_table = new_table;
        }
        this.exception_table[index++] = (short)start_pc;
        this.exception_table[index++] = (short)end_pc;
        this.exception_table[index++] = (short)handler_pc;
        this.exception_table[index++] = (short)catch_type;
        ++this.exception_table_length;
    }

    public void addHandler(int start_pc, int end_pc, int handler_pc, ClassType catch_type, ConstantPool constants) {
        int catch_type_index = catch_type == null ? 0 : constants.addClass((ObjectType)catch_type).index;
        this.addHandler(start_pc, end_pc, handler_pc, catch_type_index);
    }

    public Variable addLocal(Type type) {
        return this.locals.current_scope.addVariable(this, type, null);
    }

    public Variable addLocal(Type type, String name) {
        return this.locals.current_scope.addVariable(this, type, name);
    }

    private int adjustTypedOp(char sig) {
        switch (sig) {
            case 'I': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'F': {
                return 2;
            }
            case 'D': {
                return 3;
            }
            default: {
                return 4;
            }
            case 'B': 
            case 'Z': {
                return 5;
            }
            case 'C': {
                return 6;
            }
            case 'S': 
        }
        return 7;
    }

    private int adjustTypedOp(Type type) {
        return this.adjustTypedOp(type.getSignature().charAt(0));
    }

    public void assignConstants(ClassType cl) {
        super.assignConstants(cl);
        if (this.locals != null && this.locals.container == null && !this.locals.isEmpty()) {
            this.locals.addToFrontOf(this);
        }
        Attribute.assignConstants(this, cl);
    }

    public void beginFragment(boolean isHandler) {
        CodeFragment frag = new CodeFragment(this);
        frag.next = this.fragmentStack;
        this.fragmentStack = frag;
        frag.length = this.PC;
        frag.unreachable_save = this.unreachable_here;
        this.unreachable_here = false;
        if (isHandler) {
            frag.handlerIndex = this.exception_table_length - 1;
        }
    }

    public void disAssemble(ClassTypeWriter dst, int offset, int length) {
        boolean wide = false;
        int i = offset;
        while (i < length) {
            int oldpc = i++;
            int op = this.code[oldpc] & 0xFF;
            String str = Integer.toString(oldpc);
            int printConstant = 0;
            int j = str.length();
            while (++j <= 3) {
                dst.print(' ');
            }
            dst.print(str);
            dst.print(": ");
            if (op < 120) {
                if (op < 87) {
                    if (op < 3) {
                        this.print("nop;aconst_null;iconst_m1;", op, dst);
                    } else if (op < 9) {
                        dst.print("iconst_");
                        dst.print(op - 3);
                    } else if (op < 16) {
                        char typ;
                        if (op < 11) {
                            typ = 'l';
                            op -= 9;
                        } else if (op < 14) {
                            typ = 'f';
                            op -= 11;
                        } else {
                            typ = 'd';
                            op -= 14;
                        }
                        dst.print(typ);
                        dst.print("const_");
                        dst.print(op);
                    } else if (op < 21) {
                        if (op < 18) {
                            short constant;
                            this.print("bipush ;sipush ;", op - 16, dst);
                            if (op == 16) {
                                constant = this.code[i++];
                            } else {
                                constant = (short)this.readUnsignedShort(i);
                                i += 2;
                            }
                            dst.print(constant);
                        } else {
                            printConstant = op == 18 ? 1 : 2;
                            this.print("ldc;ldc_w;ldc2_w;", op - 18, dst);
                        }
                    } else {
                        int index;
                        String load_or_store;
                        if (op < 54) {
                            load_or_store = "load";
                        } else {
                            load_or_store = "store";
                            op -= 33;
                        }
                        if (op < 26) {
                            index = -1;
                            op -= 21;
                        } else if (op < 46) {
                            index = (op -= 26) % 4;
                            op >>= 2;
                        } else {
                            index = -2;
                            op -= 46;
                        }
                        dst.print("ilfdabcs".charAt(op));
                        if (index == -2) {
                            dst.write(97);
                        }
                        dst.print(load_or_store);
                        if (index >= 0) {
                            dst.write(95);
                            dst.print(index);
                        } else if (index == -1) {
                            if (wide) {
                                index = this.readUnsignedShort(i);
                                i += 2;
                            } else {
                                index = this.code[i] & 0xFF;
                                ++i;
                            }
                            wide = false;
                            dst.print(' ');
                            dst.print(index);
                        }
                    }
                } else if (op < 96) {
                    this.print("pop;pop2;dup;dup_x1;dup_x2;dup2;dup2_x1;dup2_x2;swap;", op - 87, dst);
                } else {
                    dst.print("ilfda".charAt((op - 96) % 4));
                    this.print("add;sub;mul;div;rem;neg;", op - 96 >> 2, dst);
                }
            } else if (op < 170) {
                if (op < 132) {
                    dst.print((op & 1) == 0 ? (char)'i' : 'l');
                    this.print("shl;shr;ushr;and;or;xor;", op - 120 >> 1, dst);
                } else if (op == 132) {
                    short constant;
                    int var_index;
                    dst.print("iinc");
                    if (!wide) {
                        var_index = 0xFF & this.code[i++];
                        constant = this.code[i++];
                    } else {
                        var_index = this.readUnsignedShort(i);
                        constant = (short)this.readUnsignedShort(i += 2);
                        i += 2;
                        wide = false;
                    }
                    dst.print(' ');
                    dst.print(var_index);
                    dst.print(' ');
                    dst.print(constant);
                } else if (op < 148) {
                    dst.print("ilfdi".charAt((op - 133) / 3));
                    dst.print('2');
                    dst.print("lfdifdildilfbcs".charAt(op - 133));
                } else if (op < 153) {
                    this.print("lcmp;fcmpl;fcmpg;dcmpl;dcmpg;", op - 148, dst);
                } else if (op < 169) {
                    if (op < 159) {
                        dst.print("if");
                        this.print("eq;ne;lt;ge;gt;le;", op - 153, dst);
                    } else if (op < 167) {
                        if (op < 165) {
                            dst.print("if_icmp");
                        } else {
                            dst.print("if_acmp");
                            op -= 6;
                        }
                        this.print("eq;ne;lt;ge;gt;le;", op - 159, dst);
                    } else {
                        this.print("goto;jsr;", op - 167, dst);
                    }
                    short delta = (short)this.readUnsignedShort(i);
                    i += 2;
                    dst.print(' ');
                    dst.print(oldpc + delta);
                } else {
                    int index;
                    dst.print("ret ");
                    if (wide) {
                        index = this.readUnsignedShort(i);
                        index += 2;
                    } else {
                        index = this.code[i] & 0xFF;
                        ++i;
                    }
                    wide = false;
                    dst.print(index);
                }
            } else if (op < 172) {
                i = i + 3 & 0xFFFFFFFC;
                int code_offset = this.readInt(i);
                i += 4;
                if (op == 170) {
                    dst.print("tableswitch");
                    int low = this.readInt(i);
                    int high = this.readInt(i += 4);
                    i += 4;
                    dst.print(" low: ");
                    dst.print(low);
                    dst.print(" high: ");
                    dst.print(high);
                    dst.print(" default: ");
                    dst.print(oldpc + code_offset);
                    while (low <= high) {
                        code_offset = this.readInt(i);
                        i += 4;
                        dst.println();
                        dst.print("  ");
                        dst.print(low);
                        dst.print(": ");
                        dst.print(oldpc + code_offset);
                        ++low;
                    }
                } else {
                    dst.print("lookupswitch");
                    int npairs = this.readInt(i);
                    i += 4;
                    dst.print(" npairs: ");
                    dst.print(npairs);
                    dst.print(" default: ");
                    dst.print(oldpc + code_offset);
                    while (--npairs >= 0) {
                        int match = this.readInt(i);
                        code_offset = this.readInt(i += 4);
                        i += 4;
                        dst.println();
                        dst.print("  ");
                        dst.print(match);
                        dst.print(": ");
                        dst.print(oldpc + code_offset);
                    }
                }
            } else if (op < 178) {
                if (op < 177) {
                    dst.print("ilfda".charAt(op - 172));
                }
                dst.print("return");
            } else if (op < 182) {
                this.print("getstatic;putstatic;getfield;putfield;", op - 178, dst);
                printConstant = 2;
            } else if (op < 185) {
                dst.print("invoke");
                this.print("virtual;special;static;", op - 182, dst);
                printConstant = 2;
            } else if (op == 185) {
                dst.print("invokeinterface (");
                int index = this.readUnsignedShort(i);
                int args = 0xFF & this.code[i += 2];
                i += 2;
                dst.print(String.valueOf(args) + " args)");
                dst.printConstantOperand(index);
            } else if (op < 196) {
                this.print("186;new;newarray;anewarray;arraylength;athrow;checkcast;instanceof;monitorenter;monitorexit;", op - 186, dst);
                if (op == 187 || op == 189 || op == 192 || op == 193) {
                    printConstant = 2;
                } else if (op == 188) {
                    byte type = this.code[i++];
                    dst.print(' ');
                    if (type >= 4 && type <= 11) {
                        this.print("boolean;char;float;double;byte;short;int;long;", type - 4, dst);
                    } else {
                        dst.print(type);
                    }
                }
            } else if (op == 196) {
                dst.print("wide");
                wide = true;
            } else if (op == 197) {
                dst.print("multianewarray");
                int index = this.readUnsignedShort(i);
                i += 2;
                dst.printConstantOperand(index);
                int dims = 0xFF & this.code[i++];
                dst.print(' ');
                dst.print(dims);
            } else if (op < 200) {
                this.print("ifnull;ifnonnull;", op - 198, dst);
                short delta = (short)this.readUnsignedShort(i);
                i += 2;
                dst.print(' ');
                dst.print(oldpc + delta);
            } else if (op < 202) {
                this.print("goto_w;jsr_w;", op - 200, dst);
                int delta = this.readInt(i);
                i += 4;
                dst.print(' ');
                dst.print(oldpc + delta);
            } else {
                dst.print(op);
            }
            if (printConstant > 0) {
                int index;
                if (printConstant == 1) {
                    index = 0xFF & this.code[i++];
                } else {
                    index = this.readUnsignedShort(i);
                    i += 2;
                }
                dst.printConstantOperand(index);
            }
            dst.println();
        }
    }

    public final void emitAdd() {
        this.emitBinop(96);
    }

    public final void emitAdd(char sig) {
        this.emitBinop(96, sig);
    }

    public final void emitAdd(PrimType type) {
        this.emitBinop(96, type);
    }

    public final void emitAnd() {
        this.emitBinop(126);
    }

    public final void emitArrayLength() {
        if (!(this.popType() instanceof ArrayType)) {
            throw new Error("non-array type in emitArrayLength");
        }
        this.reserve(1);
        this.put1(190);
        this.pushType(Type.int_type);
    }

    public void emitArrayLoad(Type element_type) {
        this.popType();
        this.popType();
        this.emitTypedOp(46, element_type);
        this.pushType(element_type);
    }

    public void emitArrayStore(Type element_type) {
        this.popType();
        this.popType();
        this.popType();
        this.emitTypedOp(79, element_type);
    }

    private void emitBinop(int base_code) {
        Type type2 = this.popType().promote();
        Type type1_raw = this.popType();
        Type type1 = type1_raw.promote();
        if (type1 != type2 || !(type1 instanceof PrimType)) {
            throw new Error("non-matching or bad types in binary operation");
        }
        this.emitTypedOp(base_code, type1);
        this.pushType(type1_raw);
    }

    private void emitBinop(int base_code, char sig) {
        this.popType();
        this.popType();
        this.emitTypedOp(base_code, sig);
        this.pushType(Type.signatureToPrimitive(sig));
    }

    private void emitBinop(int base_code, Type type) {
        this.popType();
        this.popType();
        this.emitTypedOp(base_code, type);
        this.pushType(type);
    }

    public void emitCatchEnd() {
        if (this.reachableHere()) {
            if (this.try_stack.saved_result != null) {
                this.emitStore(this.try_stack.saved_result);
            }
            if (this.try_stack.finally_subr != null) {
                this.emitGoto(this.try_stack.finally_subr, 168);
            }
            this.emitGoto(this.try_stack.end_label);
        }
        this.try_stack.try_type = null;
    }

    public void emitCatchStart(Variable var) {
        ClassType type;
        this.emitTryEnd();
        this.SP = 0;
        if (this.try_stack.try_type != null) {
            this.emitCatchEnd();
        }
        this.try_stack.try_type = type = var == null ? null : (ClassType)var.getType();
        this.readPC = this.PC;
        this.addHandler(this.try_stack.start_pc, this.try_stack.end_pc, this.PC, type, this.getConstants());
        if (var != null) {
            this.pushType(type);
            this.emitStore(var);
        } else {
            this.pushType(Type.throwable_type);
        }
    }

    public void emitCheckcast(Type type) {
        this.emitCheckcast(type, 192);
        this.pushType(type);
    }

    private void emitCheckcast(Type type, int opcode) {
        this.reserve(3);
        this.popType();
        this.put1(opcode);
        if (type instanceof ArrayType) {
            ArrayType atype = (ArrayType)type;
            CpoolUtf8 name = this.getConstants().addUtf8(atype.signature);
            this.putIndex2(this.getConstants().addClass(name));
        } else if (type instanceof ClassType) {
            this.putIndex2(this.getConstants().addClass((ClassType)type));
        } else {
            throw new Error("unimplemented type " + type + " in emitCheckcast/emitInstanceof");
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void emitConvert(Type from, Type to) {
        block36: {
            to_sig = to.getSignature();
            from_sig = from.getSignature();
            op = -1;
            if (to_sig.length() != 1 && from_sig.length() != 1) ** GOTO lbl76
            to_sig0 = to_sig.charAt(0);
            from_sig0 = from_sig.charAt(0);
            if (from_sig0 == to_sig0) {
                return;
            }
            if (from.size < 4) {
                from_sig0 = 73;
            }
            if (to.size < 4) {
                this.emitConvert(from, Type.int_type);
                from_sig0 = 73;
            }
            if (from_sig0 == to_sig0) {
                return;
            }
            switch (from_sig0) {
                case 73: {
                    switch (to_sig0) {
                        case 66: {
                            op = 145;
                            ** break;
                        }
                        case 67: {
                            op = 146;
                            ** break;
                        }
                        case 83: {
                            op = 147;
                            ** break;
                        }
                        case 74: {
                            op = 133;
                            ** break;
                        }
                        case 70: {
                            op = 134;
                            ** break;
                        }
                        case 68: {
                            op = 135;
                            ** break;
                        }
                        default: {
                            if (op >= 0) break block36;
                        }
                    }
                }
                case 74: {
                    switch (to_sig0) {
                        case 73: {
                            op = 136;
                            ** break;
                        }
                        case 70: {
                            op = 137;
                            ** break;
                        }
                        case 68: {
                            op = 138;
                            ** break;
                        }
                        default: {
                            if (op >= 0) break block36;
                        }
                    }
                }
                case 70: {
                    switch (to_sig0) {
                        case 73: {
                            op = 139;
                            ** break;
                        }
                        case 74: {
                            op = 140;
                            ** break;
                        }
                        case 68: {
                            op = 141;
                            ** break;
                        }
                        default: {
                            if (op >= 0) break block36;
                        }
                    }
                }
                case 68: {
                    switch (to_sig0) {
                        case 73: {
                            op = 142;
                            ** break;
                        }
                        case 74: {
                            op = 143;
                            ** break;
                        }
                        case 70: {
                            op = 144;
                            ** break;
                        }
                    }
                }
            }
lbl76:
            // 18 sources

            if (op >= 0) break block36;
            throw new Error("unsupported CodeAttr.emitConvert");
        }
        this.reserve(1);
        this.popType();
        this.put1(op);
        this.pushType(to);
    }

    public final void emitDiv() {
        this.emitBinop(108);
    }

    public void emitDup(int size) {
        this.emitDup(size, 0);
    }

    public void emitDup(int size, int offset) {
        int kind;
        if (size == 0) {
            return;
        }
        this.reserve(1);
        Type copied1 = this.popType();
        Type copied2 = null;
        if (size == 1) {
            if (copied1.size > 4) {
                throw new Error("using dup for 2-word type");
            }
        } else {
            if (size != 2) {
                throw new Error("invalid size to emitDup");
            }
            if (copied1.size <= 4) {
                copied2 = this.popType();
                if (copied2.size > 4) {
                    throw new Error("dup will cause invalid types on stack");
                }
            }
        }
        Type skipped1 = null;
        Type skipped2 = null;
        if (offset == 0) {
            kind = size == 1 ? 89 : 92;
        } else if (offset == 1) {
            kind = size == 1 ? 90 : 93;
            skipped1 = this.popType();
            if (skipped1.size > 4) {
                throw new Error("dup will cause invalid types on stack");
            }
        } else if (offset == 2) {
            kind = size == 1 ? 91 : 94;
            skipped1 = this.popType();
            if (skipped1.size <= 4) {
                skipped2 = this.popType();
                if (skipped2.size > 4) {
                    throw new Error("dup will cause invalid types on stack");
                }
            }
        } else {
            throw new Error("emitDup:  invalid offset");
        }
        this.put1(kind);
        if (copied2 != null) {
            this.pushType(copied2);
        }
        this.pushType(copied1);
        if (skipped2 != null) {
            this.pushType(skipped2);
        }
        if (skipped1 != null) {
            this.pushType(skipped1);
        }
        if (copied2 != null) {
            this.pushType(copied2);
        }
        this.pushType(copied1);
    }

    public void emitDup(Type type) {
        this.emitDup(type.size > 4 ? 2 : 1, 0);
    }

    public final void emitElse() {
        Label end_label;
        Label else_label = this.if_stack.end_label;
        this.if_stack.end_label = end_label = new Label(this);
        if (this.reachableHere()) {
            int growth;
            this.if_stack.stack_growth = growth = this.SP - this.if_stack.start_stack_size;
            if (growth >= 0) {
                this.if_stack.then_stacked_types = new Type[growth];
                System.arraycopy(this.stack_types, this.if_stack.start_stack_size, this.if_stack.then_stacked_types, 0, growth);
            } else {
                this.if_stack.then_stacked_types = new Type[0];
            }
            this.emitGoto(end_label);
        }
        while (this.SP > this.if_stack.start_stack_size) {
            this.popType();
        }
        this.SP = this.if_stack.start_stack_size;
        if (else_label != null) {
            else_label.define(this);
        }
        this.if_stack.doing_else = true;
    }

    public final void emitFi() {
        boolean make_unreachable = false;
        if (!this.if_stack.doing_else) {
            if (this.reachableHere() && this.SP != this.if_stack.start_stack_size) {
                throw new Error("at PC " + this.PC + " then clause grows stack with no else clause");
            }
        } else if (this.if_stack.then_stacked_types != null) {
            int then_clause_stack_size = this.if_stack.start_stack_size + this.if_stack.stack_growth;
            if (!this.reachableHere()) {
                if (this.if_stack.stack_growth > 0) {
                    System.arraycopy(this.if_stack.then_stacked_types, 0, this.stack_types, this.if_stack.start_stack_size, this.if_stack.stack_growth);
                }
                this.SP = then_clause_stack_size;
            } else if (this.SP != then_clause_stack_size) {
                throw new Error("at PC " + this.PC + ": SP at end of 'then' was " + then_clause_stack_size + " while SP at end of 'else' was " + this.SP);
            }
        } else if (this.unreachable_here) {
            make_unreachable = true;
        }
        if (this.if_stack.end_label != null) {
            this.if_stack.end_label.define(this);
        }
        if (make_unreachable) {
            this.setUnreachable();
        }
        this.if_stack = this.if_stack.previous;
    }

    private final void emitFieldop(Field field, int opcode) {
        this.reserve(3);
        this.put1(opcode);
        this.putIndex2(this.getConstants().addFieldRef(field));
    }

    public void emitFinallyEnd() {
        this.emitRet(this.try_stack.finally_ret_addr);
        this.setUnreachable();
        this.popScope();
        this.try_stack.finally_subr = null;
    }

    public void emitFinallyStart() {
        this.emitTryEnd();
        if (this.try_stack.try_type != null) {
            this.emitCatchEnd();
        }
        this.readPC = this.PC;
        this.SP = 0;
        this.try_stack.end_pc = this.PC;
        this.pushScope();
        ClassType except_type = Type.pointer_type;
        Variable except = this.addLocal(except_type);
        this.emitCatchStart(null);
        this.emitStore(except);
        this.emitGoto(this.try_stack.finally_subr, 168);
        this.emitLoad(except);
        this.emitThrow();
        this.try_stack.finally_subr.define(this);
        ClassType ret_addr_type = Type.pointer_type;
        this.try_stack.finally_ret_addr = this.addLocal(ret_addr_type);
        this.pushType(ret_addr_type);
        this.emitStore(this.try_stack.finally_ret_addr);
    }

    public final void emitGetField(Field field) {
        this.popType();
        this.pushType(field.type);
        this.emitFieldop(field, 180);
    }

    public final void emitGetStatic(Field field) {
        this.pushType(field.type);
        this.emitFieldop(field, 178);
    }

    public final void emitGoto(Label label) {
        this.emitGoto(label, 167);
        this.setUnreachable();
    }

    public final void emitGoto(Label label, int opcode) {
        this.reserve(5);
        if (label.defined()) {
            this.readPC = this.PC;
            int delta = label.position - this.PC;
            if (delta < Short.MIN_VALUE) {
                this.put1(opcode - 167);
                this.put4(delta);
            } else {
                this.put1(opcode);
                this.put2(delta);
            }
        } else {
            this.emitTransfer(label, opcode);
        }
    }

    public final void emitGotoIfCompare1(Label label, int opcode) {
        this.popType();
        this.reserve(3);
        this.emitTransfer(label, opcode);
    }

    public final void emitGotoIfCompare2(Label label, int logop) {
        boolean cmpg;
        if (logop < 155 || logop > 158) {
            throw new Error("emitGotoIfCompare2: logop must be one of iflt, ifgt, ifle, ifge");
        }
        Type type2 = this.popType().promote();
        Type type1 = this.popType().promote();
        this.reserve(4);
        char sig1 = type1.getSignature().charAt(0);
        char sig2 = type2.getSignature().charAt(0);
        boolean bl = cmpg = logop == 155 || logop == 158;
        if (sig1 == 'I' && sig2 == 'I') {
            logop += 6;
        } else if (sig1 == 'J' && sig2 == 'J') {
            this.put1(148);
        } else if (sig1 == 'F' && sig2 == 'F') {
            this.put1(cmpg ? 149 : 150);
        } else if (sig1 == 'D' && sig2 == 'D') {
            this.put1(cmpg ? 151 : 152);
        } else {
            throw new Error("non-matching types to emitGotoIfCompare2");
        }
        this.emitTransfer(label, logop);
    }

    public final void emitGotoIfEq(Label label) {
        this.emitGotoIfEq(label, false);
    }

    public final void emitGotoIfEq(Label label, boolean invert) {
        int opcode;
        Type type2 = this.popType().promote();
        Type type1 = this.popType().promote();
        this.reserve(4);
        char sig1 = type1.getSignature().charAt(0);
        char sig2 = type2.getSignature().charAt(0);
        if (sig1 == 'I' && sig2 == 'I') {
            opcode = 159;
        } else if (sig1 == 'J' && sig2 == 'J') {
            this.put1(148);
            opcode = 153;
        } else if (sig1 == 'F' && sig2 == 'F') {
            this.put1(149);
            opcode = 153;
        } else if (sig1 == 'D' && sig2 == 'D') {
            this.put1(151);
            opcode = 153;
        } else if (!(sig1 != 'L' && sig1 != '[' || sig2 != 'L' && sig2 != '[')) {
            opcode = 165;
        } else {
            throw new Error("non-matching types to emitGotoIfEq");
        }
        if (invert) {
            ++opcode;
        }
        this.emitTransfer(label, opcode);
    }

    public final void emitGotoIfGe(Label label) {
        this.emitGotoIfCompare2(label, 156);
    }

    public final void emitGotoIfGt(Label label) {
        this.emitGotoIfCompare2(label, 157);
    }

    public final void emitGotoIfIntEqZero(Label label) {
        this.emitGotoIfCompare1(label, 153);
    }

    public final void emitGotoIfIntGeZero(Label label) {
        this.emitGotoIfCompare1(label, 156);
    }

    public final void emitGotoIfIntGtZero(Label label) {
        this.emitGotoIfCompare1(label, 157);
    }

    public final void emitGotoIfIntLeZero(Label label) {
        this.emitGotoIfCompare1(label, 158);
    }

    public final void emitGotoIfIntLtZero(Label label) {
        this.emitGotoIfCompare1(label, 155);
    }

    public final void emitGotoIfIntNeZero(Label label) {
        this.emitGotoIfCompare1(label, 154);
    }

    public final void emitGotoIfLe(Label label) {
        this.emitGotoIfCompare2(label, 158);
    }

    public final void emitGotoIfLt(Label label) {
        this.emitGotoIfCompare2(label, 155);
    }

    public final void emitGotoIfNE(Label label) {
        this.emitGotoIfEq(label, true);
    }

    public final void emitIOr() {
        this.emitBinop(128);
    }

    public final void emitIfCompare1(int opcode) {
        IfState new_if = new IfState(this);
        if (this.popType().promote() != Type.int_type) {
            throw new Error("non-int type to emitIfCompare1");
        }
        this.reserve(3);
        this.emitTransfer(new_if.end_label, opcode);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfEq() {
        IfState new_if = new IfState(this);
        this.emitGotoIfNE(new_if.end_label);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfGe() {
        IfState new_if = new IfState(this);
        this.emitGotoIfLt(new_if.end_label);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfGt() {
        IfState new_if = new IfState(this);
        this.emitGotoIfLe(new_if.end_label);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfIntCompare(int opcode) {
        IfState new_if = new IfState(this);
        this.popType();
        this.popType();
        this.reserve(3);
        this.emitTransfer(new_if.end_label, opcode);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfIntLEqZero() {
        this.emitIfCompare1(157);
    }

    public final void emitIfIntLt() {
        this.emitIfIntCompare(162);
    }

    public final void emitIfIntNotZero() {
        this.emitIfCompare1(153);
    }

    public final void emitIfLe() {
        IfState new_if = new IfState(this);
        this.emitGotoIfGt(new_if.end_label);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfLt() {
        IfState new_if = new IfState(this);
        this.emitGotoIfGe(new_if.end_label);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfNEq() {
        IfState new_if = new IfState(this);
        this.emitGotoIfEq(new_if.end_label);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfNotNull() {
        this.emitIfRefCompare1(198);
    }

    public final void emitIfNull() {
        this.emitIfRefCompare1(199);
    }

    public final void emitIfRefCompare1(int opcode) {
        IfState new_if = new IfState(this);
        if (!(this.popType() instanceof ObjectType)) {
            throw new Error("non-ref type to emitIfRefCompare1");
        }
        this.reserve(3);
        this.emitTransfer(new_if.end_label, opcode);
        new_if.start_stack_size = this.SP;
    }

    public final void emitIfThen() {
        new IfState(this, null);
    }

    public void emitInc(Variable var, short inc) {
        boolean wide;
        if (var.dead()) {
            throw new Error("attempting to increment dead variable");
        }
        int offset = var.offset;
        if (offset < 0 || !var.isSimple()) {
            throw new Error("attempting to increment unassigned variable" + var.getName() + " simple:" + var.isSimple() + ", offset: " + offset);
        }
        Type type = var.getType().promote();
        this.reserve(6);
        if (type != Type.int_type) {
            throw new Error("attempting to increment non-int variable");
        }
        boolean bl = wide = offset > 255 || inc > 255 || inc < -256;
        if (wide) {
            this.put1(196);
            this.put1(132);
            this.put2(offset);
            this.put2(inc);
        } else {
            this.put1(132);
            this.put1(offset);
            this.put1(inc);
        }
    }

    public void emitInstanceof(Type type) {
        this.emitCheckcast(type, 193);
        this.pushType(Type.boolean_type);
    }

    public void emitInvoke(Method method) {
        int opcode = (method.access_flags & 8) != 0 ? 184 : (this.getMethod().classfile.isInterface() ? 185 : 182);
        this.emitInvokeMethod(method, opcode);
    }

    public void emitInvokeInterface(Method method) {
        this.emitInvokeMethod(method, 185);
    }

    public void emitInvokeMethod(Method method, int opcode) {
        this.reserve(opcode == 185 ? 5 : 3);
        int arg_count = method.arg_types.length;
        boolean is_invokestatic = opcode == 184;
        if (is_invokestatic != ((method.access_flags & 8) != 0)) {
            throw new Error("emitInvokeXxx static flag mis-match method.flags=" + method.access_flags);
        }
        if (!is_invokestatic) {
            ++arg_count;
        }
        this.put1(opcode);
        this.putIndex2(this.getConstants().addMethodRef(method));
        if (opcode == 185) {
            this.put1(this.words(method.arg_types) + 1);
            this.put1(0);
        }
        while (--arg_count >= 0) {
            this.popType();
        }
        if (method.return_type.size != 0) {
            this.pushType(method.return_type);
        }
    }

    public void emitInvokeSpecial(Method method) {
        this.emitInvokeMethod(method, 183);
    }

    public void emitInvokeStatic(Method method) {
        this.emitInvokeMethod(method, 184);
    }

    public void emitInvokeVirtual(Method method) {
        this.emitInvokeMethod(method, 182);
    }

    public final void emitLoad(Variable var) {
        if (var.dead()) {
            throw new Error("attempting to push dead variable");
        }
        int offset = var.offset;
        if (offset < 0 || !var.isSimple()) {
            throw new Error("attempting to load from unassigned variable " + var + " simple:" + var.isSimple() + ", offset: " + offset);
        }
        Type type = var.getType().promote();
        this.reserve(4);
        int kind = this.adjustTypedOp(type);
        if (offset <= 3) {
            this.put1(26 + 4 * kind + offset);
        } else {
            this.emitMaybeWide(21 + kind, offset);
        }
        this.pushType(var.getType());
    }

    void emitMaybeWide(int opcode, int index) {
        if (index >= 256) {
            this.put1(196);
            this.put1(opcode);
            this.put2(index);
        } else {
            this.put1(opcode);
            this.put1(index);
        }
    }

    public final void emitMonitorEnter() {
        this.popType();
        this.reserve(1);
        this.put1(194);
    }

    public final void emitMonitorExit() {
        this.popType();
        this.reserve(1);
        this.put1(195);
    }

    public final void emitMul() {
        this.emitBinop(104);
    }

    public void emitNew(ClassType type) {
        this.reserve(3);
        this.put1(187);
        this.putIndex2(this.getConstants().addClass(type));
        this.pushType(type);
    }

    void emitNewArray(int type_code) {
        this.reserve(2);
        this.put1(188);
        this.put1(type_code);
    }

    public void emitNewArray(Type element_type) {
        this.emitNewArray(element_type, 1);
    }

    public void emitNewArray(Type element_type, int dims) {
        if (this.popType().promote() != Type.int_type) {
            throw new Error("non-int dim. spec. in emitNewArray");
        }
        if (element_type instanceof PrimType) {
            int code;
            switch (element_type.getSignature().charAt(0)) {
                case 'B': {
                    code = 8;
                    break;
                }
                case 'S': {
                    code = 9;
                    break;
                }
                case 'I': {
                    code = 10;
                    break;
                }
                case 'J': {
                    code = 11;
                    break;
                }
                case 'F': {
                    code = 6;
                    break;
                }
                case 'D': {
                    code = 7;
                    break;
                }
                case 'Z': {
                    code = 4;
                    break;
                }
                case 'C': {
                    code = 5;
                    break;
                }
                default: {
                    throw new Error("bad PrimType in emitNewArray");
                }
            }
            this.emitNewArray(code);
        } else if (element_type instanceof ObjectType) {
            this.reserve(3);
            this.put1(189);
            this.putIndex2(this.getConstants().addClass((ObjectType)element_type));
        } else if (element_type instanceof ArrayType) {
            this.reserve(4);
            this.put1(197);
            this.putIndex2(this.getConstants().addClass(new ArrayType(element_type)));
            if (dims < 1 || dims > 255) {
                throw new Error("dims out of range in emitNewArray");
            }
            this.put1(dims);
            while (--dims > 0) {
                if (this.popType().promote() == Type.int_type) continue;
                throw new Error("non-int dim. spec. in emitNewArray");
            }
        } else {
            throw new Error("unimplemented type in emitNewArray");
        }
        this.pushType(new ArrayType(element_type));
    }

    public final void emitNot(Type type) {
        this.emitPushConstant(1, type);
        this.emitAdd();
        this.emitPushConstant(1, type);
        this.emitAnd();
    }

    public void emitPop(int nvalues) {
        while (nvalues > 0) {
            this.reserve(1);
            Type type = this.popType();
            if (type.size > 4) {
                this.put1(88);
            } else if (nvalues > 1) {
                Type type2 = this.popType();
                if (type2.size > 4) {
                    this.put1(87);
                    this.reserve(1);
                }
                this.put1(88);
                --nvalues;
            } else {
                this.put1(87);
            }
            --nvalues;
        }
    }

    public void emitPrimop(int opcode, int arg_count, Type retType) {
        this.reserve(1);
        while (--arg_count >= 0) {
            this.popType();
        }
        this.put1(opcode);
        this.pushType(retType);
    }

    public final void emitPushConstant(int val, Type type) {
        switch (type.getSignature().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                this.emitPushInt(val);
                break;
            }
            case 'J': {
                this.emitPushLong(val);
                break;
            }
            case 'F': {
                this.emitPushFloat(val);
                break;
            }
            case 'D': {
                this.emitPushDouble(val);
                break;
            }
            default: {
                throw new Error("bad type to emitPushConstant");
            }
        }
    }

    public final void emitPushConstant(CpoolEntry cnst) {
        this.reserve(3);
        int index = cnst.index;
        if (cnst instanceof CpoolValue2) {
            this.put1(20);
            this.put2(index);
        } else if (index < 256) {
            this.put1(18);
            this.put1(index);
        } else {
            this.put1(19);
            this.put2(index);
        }
    }

    public void emitPushDouble(double x) {
        int xi = (int)x;
        if ((double)xi == x && xi >= -128 && xi < 128) {
            if (xi == 0 || xi == 1) {
                this.reserve(1);
                this.put1(14 + xi);
                if (xi == 0 && Double.doubleToLongBits(x) != 0L) {
                    this.reserve(1);
                    this.put1(119);
                }
            } else {
                this.emitPushInt(xi);
                this.reserve(1);
                this.popType();
                this.put1(135);
            }
        } else {
            this.emitPushConstant(this.getConstants().addDouble(x));
        }
        this.pushType(Type.double_type);
    }

    public void emitPushFloat(float x) {
        int xi = (int)x;
        if ((float)xi == x && xi >= -128 && xi < 128) {
            if (xi >= 0 && xi <= 2) {
                this.reserve(1);
                this.put1(11 + xi);
                if (xi == 0 && Float.floatToIntBits(x) != 0) {
                    this.reserve(1);
                    this.put1(118);
                }
            } else {
                this.emitPushInt(xi);
                this.reserve(1);
                this.popType();
                this.put1(134);
            }
        } else {
            this.emitPushConstant(this.getConstants().addFloat(x));
        }
        this.pushType(Type.float_type);
    }

    public final void emitPushInt(int i) {
        this.reserve(3);
        if (i >= -1 && i <= 5) {
            this.put1(i + 3);
        } else if (i >= -128 && i < 128) {
            this.put1(16);
            this.put1(i);
        } else if (i >= Short.MIN_VALUE && i < 32768) {
            this.put1(17);
            this.put2(i);
        } else {
            this.emitPushConstant(this.getConstants().addInt(i));
        }
        this.pushType(Type.int_type);
    }

    public void emitPushLong(long i) {
        if (i == 0L || i == 1L) {
            this.reserve(1);
            this.put1(9 + (int)i);
        } else if ((long)((int)i) == i) {
            this.emitPushInt((int)i);
            this.reserve(1);
            this.popType();
            this.put1(133);
        } else {
            this.emitPushConstant(this.getConstants().addLong(i));
        }
        this.pushType(Type.long_type);
    }

    public void emitPushNull() {
        this.reserve(1);
        this.put1(1);
        this.pushType(Type.pointer_type);
    }

    public final void emitPushString(String str) {
        this.emitPushConstant(this.getConstants().addString(str));
        this.pushType(Type.string_type);
    }

    public final void emitPushThis() {
        this.reserve(1);
        this.put1(42);
        this.pushType(this.getMethod().getDeclaringClass());
    }

    public final void emitPutField(Field field) {
        this.popType();
        this.popType();
        this.emitFieldop(field, 181);
    }

    public final void emitPutStatic(Field field) {
        this.popType();
        this.emitFieldop(field, 179);
    }

    public final void emitRem() {
        this.emitBinop(112);
    }

    public void emitRet(Variable var) {
        int offset = var.offset;
        if (offset < 256) {
            this.reserve(2);
            this.put1(169);
            this.put1(offset);
        } else {
            this.reserve(4);
            this.put1(196);
            this.put1(169);
            this.put2(offset);
        }
    }

    public final void emitReturn() {
        if (this.getMethod().getReturnType().size == 0) {
            this.reserve(1);
            this.put1(177);
        } else {
            this.emitTypedOp(172, this.popType().promote());
        }
        this.setUnreachable();
    }

    public final void emitShl() {
        this.emitBinop(120);
    }

    public final void emitShr() {
        this.emitBinop(122);
    }

    public void emitStore(Variable var) {
        if (var.dead()) {
            throw new Error("attempting to push dead variable");
        }
        int offset = var.offset;
        if (offset < 0 || !var.isSimple()) {
            throw new Error("attempting to store in unassigned variable " + var.getName() + " simple:" + var.isSimple() + ", offset: " + offset);
        }
        Type type = var.getType().promote();
        this.reserve(4);
        this.popType();
        int kind = this.adjustTypedOp(type);
        if (offset <= 3) {
            this.put1(59 + 4 * kind + offset);
        } else {
            this.emitMaybeWide(54 + kind, offset);
        }
    }

    public final void emitSub() {
        this.emitBinop(100);
    }

    public final void emitSub(char sig) {
        this.emitBinop(100, sig);
    }

    public final void emitSub(PrimType type) {
        this.emitBinop(100, type);
    }

    public void emitSwap() {
        this.reserve(1);
        Type type1 = this.popType();
        Type type2 = this.popType();
        if (type1.size > 4 || type2.size > 4) {
            throw new Error("emitSwap:  not allowed for long or double");
        }
        this.pushType(type1);
        this.put1(95);
        this.pushType(type2);
    }

    public void emitTailCall(boolean pop_args, Scope scope) {
        if (pop_args) {
            Method meth = this.getMethod();
            int arg_slots = (meth.access_flags & 8) != 0 ? 0 : 1;
            int i = meth.arg_types.length;
            while (--i >= 0) {
                arg_slots += meth.arg_types[i].size > 4 ? 2 : 1;
            }
            int i2 = meth.arg_types.length;
            while (--i2 >= 0) {
                this.emitStore(this.locals.used[arg_slots -= meth.arg_types[i2].size > 4 ? 2 : 1]);
            }
        }
        this.reserve(5);
        int start_pc = scope.start_pc;
        int delta = start_pc - this.PC;
        if (delta < Short.MIN_VALUE) {
            this.put1(200);
            this.put4(delta);
        } else {
            this.put1(167);
            this.put2(delta);
        }
        this.setUnreachable();
    }

    public final void emitThrow() {
        this.popType();
        this.reserve(1);
        this.put1(191);
        this.setUnreachable();
    }

    final void emitTransfer(Label label, int opcode) {
        this.put1(opcode);
        label.emit(this);
    }

    public void emitTryCatchEnd() {
        if (this.try_stack.finally_subr != null) {
            this.emitFinallyEnd();
        }
        this.try_stack.end_label.define(this);
        Variable[] vars = this.try_stack.savedStack;
        if (vars != null) {
            int i = vars.length;
            while (--i >= 0) {
                Variable v = vars[i];
                if (v == null) continue;
                this.emitLoad(v);
            }
        }
        if (this.try_stack.saved_result != null) {
            this.emitLoad(this.try_stack.saved_result);
        }
        if (this.try_stack.saved_result != null || vars != null) {
            this.popScope();
        }
        this.try_stack = this.try_stack.previous;
    }

    public void emitTryEnd() {
        if (this.try_stack.end_label == null) {
            if (this.try_stack.saved_result != null) {
                this.emitStore(this.try_stack.saved_result);
            }
            this.try_stack.end_label = new Label(this);
            if (this.reachableHere()) {
                if (this.try_stack.finally_subr != null) {
                    this.emitGoto(this.try_stack.finally_subr, 168);
                }
                this.emitGoto(this.try_stack.end_label);
            }
            this.readPC = this.PC;
            this.try_stack.end_pc = this.PC;
        }
    }

    public void emitTryStart(boolean has_finally, Type result_type) {
        TryState try_state = new TryState(this);
        if (result_type != null && result_type.size == 0) {
            result_type = null;
        }
        if (result_type != null || this.SP > 0) {
            this.pushScope();
            if (result_type != null) {
                try_state.saved_result = this.addLocal(result_type);
            }
        }
        if (this.SP > 0) {
            try_state.savedStack = new Variable[this.SP];
            int i = 0;
            while (this.SP > 0) {
                Variable var = this.addLocal(this.topType());
                this.emitStore(var);
                try_state.savedStack[i++] = var;
            }
        }
        if (has_finally) {
            try_state.finally_subr = new Label(this);
        }
    }

    private void emitTypedOp(int op, char sig) {
        this.reserve(1);
        this.put1(op + this.adjustTypedOp(sig));
    }

    private void emitTypedOp(int op, Type type) {
        this.reserve(1);
        this.put1(op + this.adjustTypedOp(type));
    }

    public final void emitUshr() {
        this.emitBinop(124);
    }

    public final void emitXOr() {
        this.emitBinop(130);
    }

    public void endFragment() {
        CodeFragment frag = this.fragmentStack;
        this.fragmentStack = frag.next;
        frag.next = this.fragments;
        this.fragments = frag;
        int startPC = frag.length;
        frag.length = this.PC - startPC;
        frag.insns = new byte[frag.length];
        System.arraycopy(this.code, startPC, frag.insns, 0, frag.length);
        this.PC = startPC;
        this.unreachable_here = frag.unreachable_save;
    }

    public void enterScope(Scope scope) {
        scope.setStartPC(this.PC);
        this.locals.enterScope(scope);
    }

    public void finalize_labels() {
        while (this.labels != null && this.labels.fixups != null) {
            this.labels.emit_spring(this);
        }
        Label label = this.labels;
        while (label != null) {
            if (label.fixups != null || label.wide_fixups != null) {
                throw new Error("undefined label");
            }
            label = label.next;
        }
    }

    public Variable getArg(int index) {
        return this.locals.parameter_scope.find_var(index);
    }

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public byte[] getCode() {
        return this.code;
    }

    public int getCodeLength() {
        this.readPC = this.PC;
        return this.PC;
    }

    public final ConstantPool getConstants() {
        return this.getMethod().classfile.constants;
    }

    public final int getLength() {
        return 12 + this.getCodeLength() + 8 * this.exception_table_length + Attribute.getLengthAll(this);
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public final Method getMethod() {
        return (Method)this.getContainer();
    }

    public final int getPC() {
        return this.PC;
    }

    public final boolean isInTry() {
        return this.try_stack != null;
    }

    public Variable lookup(String name) {
        Scope scope = this.locals.current_scope;
        while (scope != null) {
            Variable var = scope.lookup(name);
            if (var != null) {
                return var;
            }
            scope = scope.parent;
        }
        return null;
    }

    public Scope popScope() {
        Scope scope = this.locals.current_scope;
        this.locals.current_scope = scope.parent;
        scope.end_pc = this.PC;
        this.readPC = this.PC;
        Variable var = scope.vars;
        while (var != null) {
            if (var.isSimple() && !var.dead()) {
                var.freeLocal(this);
            }
            var = var.next;
        }
        return scope;
    }

    public final Type popType() {
        if (this.SP <= 0) {
            throw new Error("popType called with empty stack " + this.getMethod());
        }
        Type type = this.stack_types[--this.SP];
        if (type.size == 8 && !this.popType().isVoid()) {
            throw new Error("missing void type on stack");
        }
        return type;
    }

    public void print(ClassTypeWriter dst) {
        dst.print("Attribute \"");
        dst.print(this.getName());
        dst.print("\", length:");
        dst.print(this.getLength());
        dst.print(", max_stack:");
        dst.print(this.max_stack);
        dst.print(", max_locals:");
        dst.print(this.max_locals);
        dst.print(", code_length:");
        int length = this.getCodeLength();
        dst.println(length);
        this.disAssemble(dst, 0, length);
        if (this.exception_table_length > 0) {
            dst.print("Exceptions (count: ");
            dst.print(this.exception_table_length);
            dst.println("):");
            int count = this.exception_table_length;
            int i = 0;
            while (--count >= 0) {
                dst.print("  start: ");
                dst.print(this.exception_table[i] & 0xFFFF);
                dst.print(", end: ");
                dst.print(this.exception_table[i + 1] & 0xFFFF);
                dst.print(", handler: ");
                dst.print(this.exception_table[i + 2] & 0xFFFF);
                dst.print(", type: ");
                int catch_type_index = this.exception_table[i + 3] & 0xFFFF;
                if (catch_type_index == 0) {
                    dst.print("0 /* finally */");
                } else {
                    dst.printOptionalIndex(catch_type_index);
                    dst.printConstantTersely(catch_type_index, 7);
                }
                dst.println();
                i += 4;
            }
        }
        dst.printAttributes(this);
    }

    private void print(String str, int i, PrintWriter dst) {
        int last = 0;
        int pos = -1;
        while (i >= 0) {
            last = ++pos;
            pos = str.indexOf(59, last);
            --i;
        }
        dst.write(str, last, pos - last);
    }

    public Scope pushScope() {
        Scope scope = new Scope();
        scope.start_pc = this.PC;
        this.readPC = this.PC;
        if (this.locals == null) {
            this.locals = new LocalVarsAttr(this.getMethod());
        }
        this.locals.enterScope(scope);
        if (this.locals.parameter_scope == null) {
            this.locals.parameter_scope = scope;
        }
        return scope;
    }

    public final void pushType(Type type) {
        if (type.size == 0) {
            throw new Error("pushing void type onto stack");
        }
        if (this.stack_types == null) {
            this.stack_types = new Type[20];
        } else if (this.SP + 1 >= this.stack_types.length) {
            Type[] new_array = new Type[2 * this.stack_types.length];
            System.arraycopy(this.stack_types, 0, new_array, 0, this.SP);
            this.stack_types = new_array;
        }
        if (type.size == 8) {
            this.stack_types[this.SP++] = Type.void_type;
        }
        this.stack_types[this.SP++] = type;
        if (this.SP > this.max_stack) {
            this.max_stack = this.SP;
        }
    }

    public final void put1(int i) {
        this.code[this.PC++] = (byte)i;
        this.unreachable_here = false;
    }

    public final void put2(int i) {
        this.code[this.PC++] = (byte)(i >> 8);
        this.code[this.PC++] = (byte)i;
        this.unreachable_here = false;
    }

    public final void put4(int i) {
        this.code[this.PC++] = (byte)(i >> 24);
        this.code[this.PC++] = (byte)(i >> 16);
        this.code[this.PC++] = (byte)(i >> 8);
        this.code[this.PC++] = (byte)i;
        this.unreachable_here = false;
    }

    public final void putIndex2(CpoolEntry cnst) {
        this.put2(cnst.index);
    }

    public final void putLineNumber(int linenumber) {
        if (this.lines == null) {
            this.lines = new LineNumbersAttr(this);
        }
        this.readPC = this.PC;
        this.lines.put(linenumber, this.PC);
    }

    public boolean reachableHere() {
        return this.unreachable_here ^ true;
    }

    private int readInt(int offset) {
        return this.readUnsignedShort(offset) << 16 | this.readUnsignedShort(offset + 2);
    }

    private int readUnsignedShort(int offset) {
        return (0xFF & this.code[offset]) << 8 | 0xFF & this.code[offset + 1];
    }

    void reorder_fixups() {
        Label prev = null;
        Label oldest = null;
        Label oldest_prev = null;
        int oldest_fixup = this.PC + 100;
        Label cur = this.labels;
        while (cur != null) {
            if (cur.fixups != null && cur.fixups[0] < oldest_fixup) {
                oldest = cur;
                oldest_prev = prev;
                oldest_fixup = cur.fixups[0];
            }
            prev = cur;
            cur = cur.next;
        }
        if (oldest != this.labels && oldest != null) {
            oldest_prev.next = oldest.next;
            oldest.next = this.labels;
            this.labels = oldest;
        }
    }

    public final void reserve(int bytes) {
        if (this.code == null) {
            this.code = new byte[100 + bytes];
        } else if (this.PC + bytes > this.code.length) {
            byte[] new_code = new byte[2 * this.code.length + bytes];
            System.arraycopy(this.code, 0, new_code, 0, this.PC);
            this.code = new_code;
        }
        while (this.labels != null && this.labels.fixups != null) {
            int threshold;
            int oldest_fixup = this.labels.fixups[0];
            int n = threshold = this.unreachable_here ? 30000 : 32000;
            if (this.PC + bytes - oldest_fixup <= threshold) break;
            this.labels.emit_spring(this);
        }
    }

    public void restoreStackTypeState(Type[] save) {
        if (save == null) {
            this.SP = 0;
        } else {
            this.SP = save.length;
            System.arraycopy(save, 0, this.stack_types, 0, this.SP);
        }
    }

    public Type[] saveStackTypeState(boolean clear) {
        if (this.SP == 0) {
            return null;
        }
        Type[] typeState = new Type[this.SP];
        System.arraycopy(this.stack_types, 0, typeState, 0, this.SP);
        if (clear) {
            this.SP = 0;
        }
        return typeState;
    }

    public final void setAttributes(Attribute attributes) {
        this.attributes = attributes;
    }

    public void setCode(byte[] code) {
        this.code = code;
        this.readPC = this.PC = code.length;
    }

    public void setCodeLength(int len) {
        this.PC = len;
        this.readPC = len;
    }

    public void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public void setMaxStack(int n) {
        this.max_stack = n;
    }

    public final void setReachable(boolean val) {
        this.unreachable_here = val ^ true;
    }

    public final void setUnreachable() {
        this.unreachable_here = true;
    }

    public final Type topType() {
        return this.stack_types[this.SP - 1];
    }

    private int words(Type[] types) {
        int res = 0;
        int i = types.length;
        while (--i >= 0) {
            if (types[i].size > 4) {
                res += 2;
                continue;
            }
            ++res;
        }
        return res;
    }

    public void write(DataOutputStream dstr) throws IOException {
        dstr.writeShort(this.max_stack);
        dstr.writeShort(this.max_locals);
        dstr.writeInt(this.PC);
        dstr.write(this.code, 0, this.PC);
        dstr.writeShort(this.exception_table_length);
        int count = this.exception_table_length;
        int i = 0;
        while (--count >= 0) {
            dstr.writeShort(this.exception_table[i]);
            dstr.writeShort(this.exception_table[i + 1]);
            dstr.writeShort(this.exception_table[i + 2]);
            dstr.writeShort(this.exception_table[i + 3]);
            i += 4;
        }
        Attribute.writeAll(this, dstr);
    }
}

