#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}.tgz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=tgz
elif [ -e ${PKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
else
  echo Cannot find original package.
  exit 1
fi

export src_orig_pkg_name=${PKG}-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export configurelogfile=${topdir}/${FULLPKG}-CONFIGURE.LOG
export makelogfile=${topdir}/${FULLPKG}-MAKE.LOG
export checklogfile=${topdir}/${FULLPKG}-CHECK.LOG
export installlogfile=${topdir}/${FULLPKG}-INSTALL.LOG
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr/X11R6
exec_prefix=${prefix}
sysconfdir=${prefix}/etc
bindir=${prefix}/bin
sbindir=${prefix}/sbin
libexecdir=${sbindir}
libdir=${prefix}/lib
includedir=${prefix}/include
datadir=${prefix}/share
infodir=${datadir}/info
mandir=${datadir}/man
sharedstatedir=${prefix}/com
localstatedir=/var
cygdatadir=/usr/share
docdir=${cygdatadir}/doc/${PKG}-${VER}
MY_CFLAGS="-O2"
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  mkdirs && \
  rm ${srcdir}/XmHTML-1.1.7
  )
}
conf() {
  (cd ${objdir} && \
  lndir ../ && \
  rm -rf .build .inst .sinst CYGWIN-PATCHES && \
)
}
build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" make World 2>&1 | tee ${makelogfile} )
}
check() {
  (cd ${objdir} && \
  make test 2>&1 | tee ${checklogfile} )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  for f in ${prefix}/share/info/dir ${prefix}/info/dir ; do
    if [ -f ${instdir}${f} ] ; then \
      rm -f ${instdir}${f} ; \
    fi ;\
  done &&\
  for d in ${docdir} ${cygdatadir}/doc/Cygwin ; do
    if [ ! -d ${instdir}${d} ] ; then
      mkdir -p ${instdir}${d} ;\
    fi ;\
  done &&\
  templist=""; \
  for f in ${srcdir}/ANNOUNCE ${srcdir}/CHANGES ${srcdir}/INSTALL \
           ${srcdir}/KNOWNBUG ${srcdir}/LICENSE ${srcdir}/README \
           ${srcdir}/TODO ${srcdir}/COPYING ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${docdir} ;
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${cygdatadir}/doc/Cygwin/${PKG}-${VER}.README ; \
  else \
    if [ -f ${srcdir}/CYGWIN-PATCHES/README ]; then \
      /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/README \
        ${instdir}${cygdatadir}/doc/Cygwin/${PKG}-${VER}.README ; \
    fi ;\
  fi ;\
  if [ -f ${srcdir}/CYGWIN-PATCHES/postinstall.sh ] ; then \
    if [ ! -d ${instdir}${cygsysconfdir}/postinstall ] ; then
      mkdir -p ${instdir}${sysconfdir}/postinstall
    fi
    /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh      \
       ${instdir}${sysconfdir}/postinstall/${PKG}.sh
  fi                                                                  && \
  mkdir -p ${instdir}${libdir} ${instdir}${includedir}                   \
           ${instdir}${bindir} ${instdir}${docdir}/examples           && \
  cp -r ${srcdir}/docs ${instdir}${docdir}                            && \
  cp -r ${srcdir}/html ${instdir}${docdir}                            && \
  cp -r ${srcdir}/examples/test-pages ${instdir}${docdir}/examples    && \
  cp -r ${srcdir}/include/XmHTML ${instdir}${includedir}              && \
  rm ${instdir}${includedir}/XmHTML/HTML.h.new                        && \
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/xmhtml                \
                          ${instdir}${docdir}/examples                && \
  /usr/bin/install -m 755 ${objdir}/lib/cygXmHTML-0.dll                  \
                          ${instdir}${bindir}                         && \
  /usr/bin/install -m 644 ${objdir}/lib/*.a                              \
                          ${instdir}${libdir}                         && \
  /usr/bin/install -m 755 ${objdir}/examples/example_2.exe               \
                          ${instdir}${bindir}/xmhtml.exe              && \
  /usr/bin/install -m 755 ${objdir}/examples/form-test.pl                \
                          ${instdir}${docdir}/examples                && \
  /usr/bin/install -m 644 ${objdir}/examples/HTMLDemos.ad                \
                          ${instdir}${docdir}/examples
  )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.exe" -or -name "*.dll" | xargs strip > /dev/null 2>&1
  true )
}
list() {
  (cd ${instdir} && \
  find . -name "*" ! -type d | sed 's/\.\/\(.*\)/\1/'
  true )
}
listdep() {
  (cd ${instdir} && \
   find . -name '*.exe' -o -name '*.dll' | xargs cygcheck | \
     sed -e '/\.exe/d' -e 's,\\,/,g' | sort -bu | xargs -n1 cygpath -u | \
     xargs cygcheck -f | uniq
   true )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * )
}
mkpatch() {
  (cd ${srcdir} && \
  find . -name "autom4te.cache" | xargs rm -rf > /dev/null
  tar xv${opt_decomp}f ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  rm ./${PKG}-${VER}-orig/XmHTML-1.1.7 && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
spkg() {
  (cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir}       && \
  rm ${configurelogfile} > /dev/null 2>&1
  rm ${makelogfile}      > /dev/null 2>&1
  rm ${checklogfile}     > /dev/null 2>&1
  rm ${installlogfile}   > /dev/null 2>&1 
}
case $1 in
  prep)	          prep ; STATUS=$? ;;
  mkdirs)       mkdirs ; STATUS=$? ;;
  conf)	          conf ; STATUS=$? ;;
  build)         build ; STATUS=$? ;;
  check)         check ; STATUS=$? ;;
  clean)         clean ; STATUS=$? ;;
  install)     install ; STATUS=$? ;;
  list)	          list ; STATUS=$? ;;
  listdep)     listdep ; STATUS=$? ;;
  strip)         strip ; STATUS=$? ;;
  package)         pkg ; STATUS=$? ;;
  pkg)	           pkg ; STATUS=$? ;;
  mkpatch)     mkpatch ; STATUS=$? ;;
  src-package) 	  spkg ; STATUS=$? ;;
  spkg)	          spkg ; STATUS=$? ;;
  finish)       finish ; STATUS=$? ;;
  all) prep && mkpatch && conf && build && install && \
      strip && pkg && spkg && finish ; \
      STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
