'\" e
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XDrArc.man,v 1.4 2003/04/28 22:17:54 herrb Exp $
.\" $XdotOrg: xc/doc/man/X11/XDrArc.man,v 1.1.4.2.2.2 2004/09/15 16:31:16 ago Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
'\" e
.TH XDrawArc 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XDrawArc, XDrawArcs, XArc \- draw arcs and arc structure
.SH SYNTAX
.HP
int XDrawArc\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC \fIgc\fP\^,
int \fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^, int \fIangle1\fP\^, int \fIangle2\fP\^); 
.HP
int XDrawArcs\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC \fIgc\fP\^,
XArc *\fIarcs\fP\^, int \fInarcs\fP\^); 
.SH ARGUMENTS
.IP \fIangle1\fP 1i
Specifies the start of the arc relative to the three-o'clock position
from the center, in units of degrees * 64.
.IP \fIangle2\fP 1i
Specifies the path and extent of the arc relative to the start of the
arc, in units of degrees * 64.
.IP \fIarcs\fP 1i
Specifies an array of arcs.
.IP \fId\fP 1i
Specifies the drawable. 
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fInarcs\fP 1i
Specifies the number of arcs in the array.
.ds Wh , which are the major and minor axes of the arc
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height\*(Wh.
.ds Xy , which are relative to the origin of the drawable
and specify the upper-left corner of the bounding rectangle
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates\*(Xy.
.SH DESCRIPTION
.EQ
delim %%
.EN
.ZN XDrawArc
draws a single circular or elliptical arc, and 
.ZN XDrawArcs
draws multiple circular or elliptical arcs.
Each arc is specified by a rectangle and two angles.  
The center of the circle or ellipse is the center of the
rectangle, and the major and minor axes are specified by the width and height.
Positive angles indicate counterclockwise motion, 
and negative angles indicate clockwise motion.  
If the magnitude of angle2 is greater than 360 degrees, 
.ZN XDrawArc
or 
.ZN XDrawArcs
truncates it to 360 degrees.
.LP
For an arc specified as %[ ~x, ~y, ~width , ~height, ~angle1, ~angle2 ]%, 
the origin of the major and minor axes is at 
% [ x +^ {width over 2} , ~y +^ {height over 2}  ]%, 
and the infinitely thin path describing the entire circle or ellipse 
intersects the horizontal axis at % [ x, ~y +^ {height over 2}  ]% and 
% [ x +^ width , ~y +^ { height over 2 }] %
and intersects the vertical axis at % [ x +^ { width over 2 } , ~y ]% and 
% [ x +^ { width over 2 }, ~y +^ height ]%.
These coordinates can be fractional
and so are not truncated to discrete coordinates.
The path should be defined by the ideal mathematical path.  
For a wide line with line-width lw, 
the bounding outlines for filling are given        
by the two infinitely thin paths consisting of all points whose perpendicular
distance from the path of the circle/ellipse is equal to lw/2
(which may be a fractional value).
The cap-style and join-style are applied the same as for a line
corresponding to the tangent of the circle/ellipse at the endpoint.
.LP
For an arc specified as % [ ~x, ~y, ~width, ~height, ~angle1, ~angle2  ]%,
the angles must be specified
in the effectively skewed coordinate system of the ellipse (for a
circle, the angles and coordinate systems are identical).  The
relationship between these angles and angles expressed in the normal
coordinate system of the screen (as measured with a protractor) is as
follows:
.LP
.Ds
% roman "skewed-angle" ~ = ~ atan left ( tan ( roman "normal-angle" )
 * width over height right ) +^ adjust%
.De
.LP
The skewed-angle and normal-angle are expressed in radians (rather
than in degrees scaled by 64) in the range % [ 0 , ~2 pi  ]% and where atan
returns a value in the range % [ - pi over 2 , ~pi over 2  ] %
and adjust is:
.LP
.Ds
.TA 1i 2i
.ta 1i 2i
%0%	for normal-angle in the range % [ 0 , ~pi over 2  ]%
%pi%	for normal-angle in the range % [ pi over 2 , ~{3 pi} over 2  ]%
%2 pi%	for normal-angle in the range % [ {3 pi} over 2 , ~2 pi  ]%
.De
.LP
For any given arc, 
.ZN XDrawArc
and
.ZN XDrawArcs
do not draw a pixel more than once.  
If two arcs join correctly and if the line-width is greater than zero 
and the arcs intersect, 
.ZN XDrawArc
and
.ZN XDrawArcs
do not draw a pixel more than once.
Otherwise, 
the intersecting pixels of intersecting arcs are drawn multiple times.
Specifying an arc with one endpoint and a clockwise extent draws the same pixels
as specifying the other endpoint and an equivalent counterclockwise extent,
except as it affects joins.
.LP
If the last point in one arc coincides with the first point in the following 
arc, the two arcs will join correctly.  
If the first point in the first arc coincides with the last point in the last 
arc, the two arcs will join correctly.
By specifying one axis to be zero, a horizontal or vertical line can be
drawn.
Angles are computed based solely on the coordinate system and ignore the
aspect ratio.
.LP
Both functions use these GC components: 
function, plane-mask, line-width, line-style, cap-style, join-style, 
fill-style, subwindow-mode, clip-x-origin, clip-y-origin, and clip-mask.
They also use these GC mode-dependent components: 
foreground, background, tile, stipple, tile-stipple-x-origin, 
tile-stipple-y-origin, dash-offset, and dash-list.
.LP
.ZN XDrawArc
and
.ZN XDrawArcs
can generate
.ZN BadDrawable ,
.ZN BadGC ,
and
.ZN BadMatch 
errors.
.SH STRUCTURES
The
.ZN XArc
structure contains:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	short x, y;
	unsigned short width, height;
	short angle1, angle2;             /\(** Degrees * 64 */
} XArc;
.De
.LP
All x and y members are signed integers.
The width and height members are 16-bit unsigned integers.
You should be careful not to generate coordinates and sizes
out of the 16-bit ranges, because the protocol only has 16-bit fields
for these values.
.SH DIAGNOSTICS
.TP 1i
.ZN BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.ZN BadGC
A value for a GContext argument does not name a defined GContext.
.TP 1i
.ZN BadMatch
An
.ZN InputOnly
window is used as a Drawable.
.TP 1i
.ZN BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.SH "SEE ALSO"
XDrawLine(3X11),
XDrawPoint(3X11),
XDrawRectangle(3X11)
.br
\fI\*(xL\fP
