//@copyright_begin
// ================================================================
// Copyright Notice
// Copyright (C) 1998-2004 by Joe Linoff
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JOE LINOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Comments and suggestions are always welcome.
// Please report bugs to http://ccdoc.sourceforge.net/ccdoc
// ================================================================
//@copyright_end

// ================================================================
// This variable allows the header version
// to be queried at runtime.
// ================================================================
namespace {
  char ccdoc_rcsid[] = "$Id: main.cc,v 1.7 2004/09/30 04:52:35 jlinoff Exp $";
}

// ================================================================
// Includes
// ================================================================
#include "switches.h"
#include "database.h"
#include "statement.h"
#include "phase1.h"
#include "phase2.h"
#include "phase3.h"

// ================================================================
// Report status.
// ================================================================
namespace
{
  int status(int st,bool v=false) {
    if( v ) {
      if( ccdoc::s_log.warnings_enabled() )
        ccdoc::s_log << ccdoc::s_log.warnings() << " warnings  ";
      ccdoc::s_log << ccdoc::s_log.errors() << " errors\n";
    }
    ccdoc::s_log.flush();
    return st;
  }
}
// ================================================================
// MAIN
// ================================================================
int main(int argc,char** argv) {
  try {
    // Load the switches.
    ccdoc::switches sw(argc,argv);
    if( ! sw.ok() )
      return status(1,sw.verbose());

    // Load the database information.
    // If the database does not exist,
    // an empty database is created.
    // If the -db switch argument was
    // not specified, an exception is
    // thrown.
    ccdoc::database db(sw);

    bool run_phase2 = sw.index();
    bool write_flag = false;

    // Is phase 1 enabled? This occurs when the -pkg <name> switch
    // is specified or when source files are specified.
    if( sw.pkg().size() || sw.num_files() ) {
      write_flag = true;
      if( sw.html().size() ) {
	run_phase2 = true;
      }
      if( ! ccdoc::phase1::run(sw,db) )
	return status(1,sw.verbose());
    }

    // Is phase 2 enabled? This occurs when the -index switch
    // is specified or when phase3 was specified with some new
    // source files.
    if( run_phase2 ) {
      write_flag = true;
      if( ! ccdoc::phase2::run(sw,db) )
	status(1,sw.verbose());
    }

    // Is phase 3 enabled? This occurs when the -htm or -html switch
    // is specified.
    if( sw.html().size() ) {
      if( !ccdoc::phase3::run(sw,db) )
	return status(1,sw.verbose());
      if( !write_flag )
	db.disable_write();
    }

    return status(0);
  }
  catch (const ccdoc::exceptions::base& e) {
    ccdoc::s_log << "Caught exception\n";
    e.report();
  }

  return status(1);
}

