// Verify that the -notcms switch works correctly.
// This switch tells ccdoc to ignore template class
// methods that are defined outside of a declaration.
template <class T>
class Test
{
public:
   Test();
   ~Test();
   T GetValue() const {return m_val;}
   void SetValue(T val);
   bool operator==(const T&) const;
private:
   T m_val;
};
template <class T>
Test<T>::Test()
{
}
template <class T>
Test<T>::~Test()
{
}
template <class T>
void Test<T>::SetValue(T val)
{
   m_val = val;
}
template <class T>
bool Test<T>::operator==(const T&) const
{
   return false;
}
template <class T>
T real_fct(T val)
{
   Test<T> f;
   f.SetValue(val);
   return f.GetValue();
}
template<> int real_fct<int>(int);
template<> class Test<double>;
