#!perl
# $Id: make_cygwin_pkg.pl,v 1.3 2004/09/30 07:34:13 jlinoff Exp $
#
# This script creates the cygwin release package
# automatically so that I don't have to remember
# all of the steps.
#
# The only thing that was not automated was the
# initial generation of the configuration script
# using autoconf.
#
use strict;
&Main;

# ================================================
# MAIN
# ================================================
sub Main
{
    # ================================================
    # Read the release.txt file contents.
    # ================================================
    my $file = "../src/release.txt";
    if( ! -e $file ) {
	print STDERR "ERROR: Can't read release.txt.\n";
	exit 1;
    }
    my $rev = "";
    my $date = "";
    open HND,"$file" || die "ERROR: Can't read '$file'.\n";
    while( <HND> ) {
	chop;
	next if ( /^\s*\#/ );
	if( /(\S+)\s+(\S+)/ ) {
	    $rev = $1;
	    $date = $2;
	    last;
	}
    }
    close HND;
    if( $rev eq "" || $date eq "" ) {
	print STDERR "ERROR: Invalid syntax in release.txt,\n";
	print STDERR "       Expected: <rev> <date>\n";
	exit 1;
    }
    my $relname = "ccdoc${rev}";

    # Now convert the release name to a cygwin name.
    # ccdocv08r39 --> ccdoc-0.8.39-1
    $relname =~ s/ccdoc/ccdoc-/;
    $relname =~ s/v08r/0.8./;
    $relname .= "-1";
    print "Creating cygwin package for ${relname} ...\n";
 
    # Create the work directory structure in work/cygwin
    # directory.
    my $rootdir = "../work/cygwin";
    mkdir "$rootdir" if( ! -d "$rootdir" );
    $rootdir .= "/$relname";
    mkdir "$rootdir" if( ! -d "$rootdir" );
    $rootdir .= "/usr";
    mkdir "$rootdir" if( ! -d "$rootdir" );
    system( "rm -rf $rootdir/*" );

    # ================================================
    # Create the source directory and populate it
    # with the correct stuff.
    # ================================================
    my $srcdir = "$rootdir/src";
    mkdir "$srcdir" if( ! -d "$srcdir" );
    $srcdir .= "/$relname";
    mkdir "$srcdir" if( ! -d "$srcdir" );
    system( "rm -rf $srcdir/*" );
    system( "cp ../src/*.cc ../src/*.h $srcdir/" );
    system( "cp ../src/copyright.txt $srcdir/LICENSE" );
    system( "cp ../utils/cygwin_readme.txt $srcdir/README" );
    system( "touch $srcdir/config.h.in" );
    system( "perl ../utils/makeman.pl -h ../src/help.txt -l ../src/copyright.txt -o $srcdir/ccdoc.1" );
    system( "chmod a-x $srcdir/*" );
    system( "cp ../utils/cygwin_configure $srcdir/configure" );
    system( "chmod a+x $srcdir/configure" );

    mkdir "$srcdir/CYGWIN-PATCHES" if( ! -d "$srcdir/CYGWIN-PATCHES" );

    # ================================================
    # Create the RELEASE_NOTES file.
    # ================================================
    my $file = "$srcdir/RELEASE_NOTES";
    open HND,">$file" or die "ERROR: Can't write '$file'.\n";
    print HND "Cygwin release ${relname} corresponds to ccdoc release ccdoc${rev}.\n";
    print HND "\n";
    print HND "See http://ccdoc.sourceforge.net for information about ccdoc${rev}\n";
    print HND "including release notes and the users manual.\n";
    close HND;
    system( "chmod a-x $file" );
    system( "perl ../utils/pc2unix.pl $file" );

    # ================================================
    # Create the setup.hint file
    # ================================================
    $file = "$srcdir/CYGWIN-PATCHES/setup.hint";
    open HND,">$file" or die "ERROR: Can't write '$file'.\n";
    print HND "@ ccdoc\n";
    print HND "category: Devel\n";
    print HND "requires: cygwin\n";
    print HND "version: ${relname}\n";
    print HND "sdesc: \"Generates HTML documentation for C++ interfaces.\"\n";
    print HND "ldesc: \"Automatically generates HTML web documentation from C++\n";
    print HND "programs by parsing the source file headers. It was designed to aid\n";
    print HND "collaboration between package users and package developers by\n";
    print HND "documenting the interface.\n";
    print HND "\n";
    print HND "More information about ccdoc can be found on the project page:\n";
    print HND "http://ccdoc.sourceforge.net\"\n";
    close HND;
    system( "chmod a-x $file" );
    system( "perl ../utils/pc2unix.pl $file" );

    # ================================================
    # Create Makefile.in from mkdepend.mk to insure
    # that it is up to date.
    # ================================================
    my $file = "$srcdir/Makefile.in";
    open HND,">$file" or die "ERROR: Can't write '$file'.\n";
    print HND "# Sample makefile.\n";
    print HND "# \@configure_input\@\n";
    print HND "prefix = \@prefix\@\n";
    print HND "exec_prefix = \@exec_prefix\@\n";
    print HND "\n";
    print HND "SRCDIR = \@srcdir\@\n";
    print HND "BINDIR = \@bindir\@\n";
    print HND "MANPAGE = \@mandir\@/man1/ccdoc.1\n";
    print HND "\n";
    print HND "CXXFLAGS = \@CXXFLAGS\@ -I\@srcdir\@\n";
    print HND "CXX = \@CXX\@\n";
    print HND "\n";
    print HND "#\n";
    print HND "# -------------------------------------------------\n";
    print HND "# There is no need to edit anything below this line.\n";
    print HND "\n";

    print HND "#\n";
    print HND "# Make the executable and install the man page.\n";
    print HND "#\n";
    print HND "all: exe\n";
    print HND "\n";
    print HND "exe: ccdoc.exe\n";
    print HND "\n";
    print HND "install: install_exe install_man\n";
    print HND "\n";
    print HND "install_exe: \${BINDIR}/ccdoc.exe\n";
    print HND "\n";
    print HND "install_man: \${MANPAGE}\n";
    print HND "\n";
    print HND "clean:\n";
    print HND "\trm -f *.o *.exe *~\n";
    print HND "\n";
    print HND "distclean: clean\n";
    print HND "\trm -f Makefile config.log config.status config.h\n";
    print HND "\n";

    # Load the object file rules.
    $file = "../src/mkdepend.mk";
    open SRC,"$file" or die "ERROR: Can't read '$file'\n";
    while( <SRC> ) {
	s/\${BIN_DIR}\///g;
	s/\${OBJ_EXT}/o/g;
	s/\${CXX_OUT}/-c -o /g;
	s/CXX_FLAGS/CXXFLAGS/g;
	print HND "$_";
    }
    close SRC;

    print HND "#\n";
    print HND "# Man page target.\n";
    print HND "#\n";
    print HND "\${MANPAGE}: ccdoc.1\n";
    print HND "	\@rm -f \$\@\n";
    print HND "	cp ccdoc.1 \$\@\n";

    print HND "\n";
    print HND "#\n";
    print HND "# Executable target.\n";
    print HND "#\n";
    print HND "\${BINDIR}/ccdoc.exe : ccdoc.exe\n";
    print HND "	\@rm -f \$\@\n";
    print HND "	cp ccdoc \$\@\n";
    print HND "\n";
    print HND "ccdoc.exe : \${OBJS}\n";
    print HND "	\@echo \"================================================\"\n";
    print HND "	\@echo \"Linking \$\@\"\n";
    print HND "	\@rm -f \$\@\n";
    print HND "	\${CXX} \${CXXFLAGS} -o \$\@ \${OBJS} \@LIBS\@\n";
    print HND "	strip \$\@\n";

    close HND;
    system( "chmod a-x $srcdir/Makefile.in" );
    system( "perl ../utils/pc2unix.pl $srcdir/Makefile.in" );

    # ================================================
    # Make sure that everything is in unix format.
    # Each file is done explicitly because wildcarding
    # (ala perl ../utils/pc2unix.pl $srcdir/*) didn't
    # work.
    # ================================================
    system( "perl ../utils/pc2unix.pl $srcdir/ccdoc.1" );

    # ================================================
    # Create the patch diff file by creating
    # a copy of the release directory called
    # ccdoc${rev} and copying everything over
    # except for the cygwin specific stuff.
    # ================================================
    system( "rm -rf $srcdir/../ccdoc${rev}" );
    system( "cp -r $srcdir $srcdir/../ccdoc${rev}/" );
    system( "rm -rf $srcdir/../ccdoc${rev}/CYGWIN*" );
    system( "rm -rf $srcdir/../ccdoc${rev}/RELEASE_NOTES*" );
    chdir "$srcdir/..";
    system( "pwd" );
    system( "diff -Nrup ccdoc${rev} $relname > ${relname}.patch" );

    # ================================================
    # Create the src bzip file.
    # ================================================
    system( "tar cf ${relname}-src.tar $relname ${relname}.patch" );
    system( "bzip2 ${relname}-src.tar" );

    # ================================================
    # Build the executable.
    # ================================================
    print "Build the executable...\n";
    chdir $relname;
    system( "pwd" );
    system( "bash ./configure" );
    system( "gmake" );
    system( "gmake install" );
    chdir "..";

    # ================================================
    # Create the binary release directories.
    # ================================================
    print "Create the binary release directories...\n";
    chdir "..";
    system( "pwd" );
    system( "rm -rf bin doc man pkg" );
    mkdir "bin";
    mkdir "doc";
    mkdir "doc/$relname";
    mkdir "man";
    mkdir "man/man1";
    mkdir "pkg";
    system( "cp src/${relname}/ccdoc.exe bin/" );
    system( "cp src/${relname}/ccdoc.1 man/man1" );
    system( "cp src/${relname}/LICENSE doc/${relname}" );
    system( "cp src/${relname}/README doc/${relname}" );
    system( "cp src/${relname}/RELEASE_NOTES doc/${relname}" );

    # ================================================
    # Create the binary archive.
    # ================================================
    print "Create the binary archive...\n";
    chdir "..";
    system( "pwd" );
    system( "tar cf ${relname}.tar usr/bin usr/man usr/doc" );
    system( "bzip2 ${relname}.tar" );

    # ================================================
    # Create the package contents.
    # ================================================
    print "Create the package contents...\n";
    chdir "usr";
    system( "pwd" );
    system( "mv ../${relname}.tar.bz2 pkg" );
    system( "cp src/${relname}-src.tar.bz2 pkg" );
    system( "cp src/${relname}/CYGWIN-PATCHES/setup.hint pkg" );

    # ================================================
    # Cd back to where we came from.
    # ================================================
    chdir "~/work/ccdoc/utils";
    system( "pwd" );
}
