#!perl
# $Id: update_downloads_page.pl,v 1.3 2004/09/30 07:34:13 jlinoff Exp $
#
# This script is run automatically by the "gmake rel" target
# (the makerelease.pl script).
#
# This script automatically updates the release file sizes on
# the downloads page. It must be run after all of the ports
# have been completed and an initial release has been made.
#
# It must be run from this directory or the src directory.
#
use strict;
&Main;

# ================================================
# MAIN
# ================================================
sub Main
{
    my $verbose = 0;
    while( $#ARGV>=0 ) {
	my $arg = shift @ARGV;
	if( $arg eq "-v" ) {
	    $verbose = 1;
	}
	else {
	    print STDERR "ERROR: Unknown switch '$arg' encountered.\n";
	    print STDERR "\n";
	    print STDERR "update_downloads_page.pl [-v]\n";
	    print STDERR "   -v  Verbose mode.\n";
	    print STDERR "\n";
	}
    }

    # ================================================
    # Read the release.txt file contents.
    # ================================================
    my $file = "../src/release.txt";
    if( ! -e $file ) {
	print STDERR "ERROR: Can't read release.txt.\n";
	exit 1;
    }
    my $rev = "";
    my $date = "";
    open HND,"$file" || die "ERROR: Can't read '$file'.\n";
    while( <HND> ) {
	chop;
	next if ( /^\s*\#/ );
	if( /(\S+)\s+(\S+)/ ) {
	    $rev = $1;
	    $date = $2;
	    last;
	}
    }
    close HND;
    if( $rev eq "" || $date eq "" ) {
	print STDERR "ERROR: Invalid syntax in release.txt,\n";
	print STDERR "       Expected: <rev> <date>\n";
	exit 1;
    }
    my $relname = "ccdoc${rev}";
    print "Updating the downloads page for $relname ...\n";

    # ================================================
    # Open the release.txt file in the release directory.
    # It contains the file size information.
    # ================================================
    my %sizes;
    my $ifile = "../$relname/release.txt";
    if( ! -e "$ifile" ) {
	print STDERR "ERROR: Can't read '$ifile'.\n";
	exit 1;
    }
    open HND,"$ifile" || die "ERROR: Can't read '$ifile'.\n";
    while(<HND>) {
	chop;
	if( /^bin_opt/ ) {
	    my $port = $_;
	    my $sz_exe;
	    my $sz_gz;
	    my $sz_zip;
	    # Now get the sizes from the next three lines.
	    while(<HND>) {
		chop;
		if( /^\s+ccdoc.exe\s+(\S+)\s+(\S+)/ ) {
		    $sz_exe = "${2}k";
		    $sizes{"$port/ccdoc.exe"} = $sz_exe;
		}
		elsif( /^\s+ccdoc.exe.gz\s+(\S+)\s+(\S+)/ ) {
		    $sz_gz = "${2}k";
		    $sizes{"$port/ccdoc.exe.gz"} = $sz_gz;
		}
		elsif( /^\s+ccdoc.exe.zip\s+(\S+)\s+(\S+)/ ) {
		    $sz_zip = "${2}k";
		    $sizes{"$port/ccdoc.exe.zip"} = $sz_zip;
		    last;
		}
	    }
	}
	elsif ( /^\s+src\.tar\.gz\s+(\S+)\s+(\S+)/ ) {
	    my $port = "src.tar.gz";
	    my $sz_gz = "${2}k";
	    $sizes{$port} = $sz_gz;
	}
	elsif ( /^\s+doc\.tar\.gz\s+(\S+)\s+(\S+)/ ) {
	    my $port = "doc.tar.gz";
	    my $sz_gz = $2;
	    my $sz_gz = "${2}k";
	    $sizes{$port} = $sz_gz;
	}
    }
    close HND;

    # ================================================
    # Report the sizes for debugging purposes.
    # ================================================ 
    if( $verbose ) {
	my $key;
	foreach $key ( sort keys %sizes ) {
	    my $sz = $sizes{$key};
	    printf "%-64s ",$key;
	    print "$sz\n";
	}
    }

    # ================================================ 
    # Update the downloads page.
    # ================================================ 
    $ifile = "../doc/htdocs/downloads.htm";
    my $ofile = "../doc/htdocs/downloads-tmp.htm";
    open HND,"$ifile" || die "ERROR: Can't read '$ifile'.\n";
    open OUT,">$ofile" || die "ERROR: Can't write '$ofile'.\n";
    my $lineno = 0;
    while(<HND>) {
	$lineno++;
	chop;
	my $line = $_;

	# Replace the previous revision number.
	if( /<td>(v08r[0-9]{2})<\/td>/ ) {
	    if( $verbose ) {
		print "Found: Revision at line $lineno.\n";
		print "  old_rev = $1\n";
		print "  new_rev = $rev\n";
	    }
	    $line =~ s/<td>v08r[0-9]{2}<\/td>/<td>$rev<\/td>/;
	    print OUT "$line\n";
	}
	elsif( /\/downloads\/([^\"]+)\"/ ) {
	    # Replace the sizes and release date.
	    my $found = 0;
	    my $key;
	    foreach $key ( sort keys %sizes ) {
		my $port = $key;
		if( /$port\"/ ) {
		    if( $verbose ) {
			print "Found: $port at line $lineno.\n";
		    }
		    if( />([0-9,]+k)<\/a>/ ) {
			my $sz = $sizes{$port};
			if( $verbose ) {
			    print "  old_size = $1\n";
			    print "  new_size = $sz\n";
			}
			$line =~ s/>[0-9,]+k<\/a>/>$sz<\/a>/;
			print OUT "$line\n";
			$found = 1;

			# Now look ahead for the date and update it.
			while( <HND> ) {
			    $lineno++;
			    chop;
			    my $line = $_;
			    if( />([0-9]{4})\/([0-9]{2})\/([0-9]{2})<\/font>/ ) {
				if( $verbose ) {
				    print "  old_date = $1/$2/$3\n";
				    print "  new_date = $date\n";
				}
				$line =~ s/>[0-9]{4}\/[0-9]{2}\/[0-9]{2}<\/font>/>${date}<\/font>/;
				print OUT "$line\n";
				last;
			    }
			    print OUT "$line\n";
			}
		    }
		    else {
			print OUT "$line\n";
			# This is the src.tar.gz and doc.tar.gz.
			# Look ahead until the sizes are found.
			while( <HND> ) {
			    $lineno++;
			    chop;
			    my $line = $_;
			    if( />([0-9,]+k)<\/div>/ ) {
				my $sz = $sizes{$port};
				if( $verbose ) {
				    print "  old_size = $1\n";
				    print "  new_size = $sz\n";
				}
				$line = $_;
				$line =~ s/>[0-9,]+k<\/div>/>$sz<\/div>/;
				print OUT "$line\n";
				$found = 1;
				last;
			    }
			    print OUT "$line\n";
			}
		    }
		    last;
		}
	    }
	    if( !$found ) {
		print STDERR "WARNING: $1 not defined at line $lineno.\n";
		print OUT "$line\n";
	    }
	}
	else {
	    print OUT "$line\n";
	}
    }
    close OUT;
    close HND;

    print "You must manually rename downloads-tmp.htm to downloads.htm.\n";
	
    exit 0;
}
