/* $Id: name_mangle.c,v 1.1 2000/09/17 03:14:38 cwilson Exp $ */

/*
 *   IPC package for CygWin
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 *
 */

#include <IpcNtLit.h>

const char *packageName = CYGWIN_IPCNT_PKGNAME;
extern void reverse(char s[]);

void name_mangle(int n,char s[])
{
    int i = 0;
	 int sign = n;
    const char *p = packageName;
	 char *numberStart;

    for (; *p ;)
	 {
        s[i++] = *p++;
    }

    numberStart = &(s[i]);

    if (sign < 0)
    {
        n = -n;
    }

    do
    {
        s[i++] = n % 10 + '0';
    }
    while( (n /= 10) > 0);

    if( sign < 0) 
        s[i++] = '-';
    s[i] = '\0';
    reverse(numberStart);
}
